/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.service.operations;

import com.google.protobuf.Message;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.xtreemfs.babudb.pbrpc.GlobalTypes;
import org.xtreemfs.babudb.replication.FleaseMessageReceiver;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Operation;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Request;
import org.xtreemfs.foundation.flease.comm.FleaseMessage;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.util.OutputUtils;

public class FleaseOperation
extends Operation {
    private final FleaseMessageReceiver receiver;

    public FleaseOperation(FleaseMessageReceiver receiver) {
        this.receiver = receiver;
    }

    @Override
    public int getProcedureId() {
        return 4;
    }

    @Override
    public Message getDefaultRequest() {
        return GlobalTypes.FLease.getDefaultInstance();
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(Request rq) {
        RPC.RPCHeader.ErrorResponse resp = super.parseRPCMessage(rq);
        if (resp == null) {
            InetSocketAddress sender;
            FleaseMessage message = new FleaseMessage(rq.getData());
            GlobalTypes.FLease rpcrq = (GlobalTypes.FLease)rq.getRequestMessage();
            assert (message != null);
            try {
                sender = new InetSocketAddress(InetAddress.getByName(rpcrq.getHost()), rpcrq.getPort());
            }
            catch (UnknownHostException e) {
                return RPC.RPCHeader.ErrorResponse.newBuilder().setErrorMessage(e.getMessage()).setErrorType(RPC.ErrorType.IO_ERROR).setDebugInfo(OutputUtils.stackTraceToString((Throwable)e)).build();
            }
            assert (sender != null);
            message.setSender(sender);
            rq.setAttachment(message);
        }
        return resp;
    }

    @Override
    public void processRequest(Request rq) {
        FleaseMessage msg = (FleaseMessage)rq.getAttachment();
        Logging.logMessage((int)7, (Object)this, (String)"FleaseOperation: received message %s", (Object[])new Object[]{msg.toString()});
        this.receiver.receive(msg);
        rq.sendSuccess((Message)GlobalTypes.ErrorCodeResponse.getDefaultInstance());
    }
}

