/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.service.operations;

import com.google.protobuf.Message;
import java.net.InetSocketAddress;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.pbrpc.GlobalTypes;
import org.xtreemfs.babudb.replication.service.accounting.ParticipantsStates;
import org.xtreemfs.babudb.replication.service.accounting.StatesManipulation;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Operation;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Request;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;

public class HeartbeatOperation
extends Operation {
    private final StatesManipulation sManipulator;

    public HeartbeatOperation(StatesManipulation statesManipulator) {
        this.sManipulator = statesManipulator;
    }

    @Override
    public int getProcedureId() {
        return 7;
    }

    @Override
    public Message getDefaultRequest() {
        return GlobalTypes.HeartbeatMessage.getDefaultInstance();
    }

    @Override
    public void processRequest(Request rq) {
        GlobalTypes.HeartbeatMessage message = (GlobalTypes.HeartbeatMessage)rq.getRequestMessage();
        GlobalTypes.LSN rawLSN = message.getLsn();
        LSN lsn = new LSN(rawLSN.getViewId(), rawLSN.getSequenceNo());
        try {
            InetSocketAddress participant = new InetSocketAddress(rq.getSenderAddress().getAddress(), message.getPort());
            this.sManipulator.update(participant, lsn, TimeSync.getGlobalTime());
            Logging.logMessage((int)7, (Object)this, (String)"HeartbeatOperation: received %s from %s.", (Object[])new Object[]{lsn.toString(), participant});
            rq.sendSuccess((Message)GlobalTypes.ErrorCodeResponse.getDefaultInstance());
        }
        catch (ParticipantsStates.UnknownParticipantException e) {
            rq.sendError(RPC.RPCHeader.ErrorResponse.newBuilder().setErrorMessage("The sender address of the received request did not match any expected address.").setErrorType(RPC.ErrorType.AUTH_FAILED).build());
        }
    }
}

