/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.service.operations;

import com.google.protobuf.Message;
import java.util.concurrent.atomic.AtomicReference;
import org.xtreemfs.babudb.lsmdb.LSMDatabase;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.pbrpc.GlobalTypes;
import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.transmission.FileIOInterface;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Operation;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Request;
import org.xtreemfs.foundation.logging.Logging;

public class LoadOperation
extends Operation {
    private final AtomicReference<LSN> lastOnView;
    private final BabuDBInterface babuInterface;
    private final FileIOInterface fileIO;
    private final int maxChunkSize;

    public LoadOperation(AtomicReference<LSN> lastOnView, int maxChunkSize, BabuDBInterface babuInterface, FileIOInterface fileIO) {
        this.fileIO = fileIO;
        this.maxChunkSize = maxChunkSize;
        this.babuInterface = babuInterface;
        this.lastOnView = lastOnView;
    }

    @Override
    public int getProcedureId() {
        return 2;
    }

    @Override
    public Message getDefaultRequest() {
        return GlobalTypes.LSN.getDefaultInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(Request rq) {
        GlobalTypes.LSN request = (GlobalTypes.LSN)rq.getRequestMessage();
        LSN lov = this.lastOnView.get();
        Logging.logMessage((int)7, (Object)this, (String)"LOAD from LSN(%s), by %s (LastOnView: LSN(%s))", (Object[])new Object[]{request.toString(), rq.getSenderAddress().toString(), lov.toString()});
        if (new LSN(request.getViewId(), request.getSequenceNo()).equals((Object)lov)) {
            rq.sendSuccess((Message)GlobalTypes.DBFileMetaDatas.getDefaultInstance());
        } else {
            GlobalTypes.DBFileMetaDatas.Builder result = GlobalTypes.DBFileMetaDatas.newBuilder();
            result.setMaxChunkSize(this.maxChunkSize);
            Object object = this.babuInterface.getDBModificationLock();
            synchronized (object) {
                Object object2 = this.babuInterface.getCheckpointerLock();
                synchronized (object2) {
                    result.addDbFileMetadatas(this.convert(this.fileIO.getConfigFileMetaData()));
                    for (LSMDatabase.DBFileMetaData md : this.babuInterface.getAllSnapshotFiles()) {
                        result.addDbFileMetadatas(this.convert(md));
                    }
                }
            }
            rq.sendSuccess((Message)result.build());
        }
    }

    private GlobalTypes.DBFileMetaData convert(LSMDatabase.DBFileMetaData metaData) {
        return GlobalTypes.DBFileMetaData.newBuilder().setFileName(metaData.file).setFileSize(metaData.size).build();
    }
}

