/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.service.operations;

import com.google.protobuf.Message;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.xtreemfs.babudb.log.DiskLogIterator;
import org.xtreemfs.babudb.log.LogEntry;
import org.xtreemfs.babudb.log.LogEntryException;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.pbrpc.GlobalTypes;
import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.transmission.FileIOInterface;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Operation;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Request;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;

public class ReplicaOperation
extends Operation {
    private static final int MAX_LOGENTRIES_PER_REQUEST = 100;
    private final Checksum checksum = new CRC32();
    private final AtomicReference<LSN> lastOnView;
    private final BabuDBInterface babuInterface;
    private final FileIOInterface fileIO;

    public ReplicaOperation(AtomicReference<LSN> lastOnView, BabuDBInterface babuInterface, FileIOInterface fileIO) {
        this.fileIO = fileIO;
        this.babuInterface = babuInterface;
        this.lastOnView = lastOnView;
    }

    @Override
    public int getProcedureId() {
        return 6;
    }

    @Override
    public Message getDefaultRequest() {
        return GlobalTypes.LSNRange.getDefaultInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(Request rq) {
        GlobalTypes.LSNRange request = (GlobalTypes.LSNRange)rq.getRequestMessage();
        LSN lastInserted = new LSN(request.getStart().getViewId(), request.getStart().getSequenceNo());
        LSN end = new LSN(request.getEnd().getViewId(), request.getEnd().getSequenceNo());
        GlobalTypes.LogEntries.Builder result = GlobalTypes.LogEntries.newBuilder();
        ReusableBuffer resultPayLoad = BufferPool.allocate((int)0);
        Logging.logMessage((int)6, (Object)this, (String)"REQUEST received (start: %s, end: %s) from %s", (Object[])new Object[]{lastInserted.toString(), end.toString(), rq.getSenderAddress().toString()});
        if (lastInserted.equals((Object)this.lastOnView.get())) {
            Logging.logMessage((int)7, (Object)this, (String)"REQUEST answer is empty (there has been a failover only).", (Object[])new Object[0]);
            rq.sendSuccess((Message)result.build());
            return;
        }
        LSN firstEntryNeeded = new LSN(lastInserted.getViewId(), lastInserted.getSequenceNo() + 1L);
        assert (firstEntryNeeded.compareTo(end) <= 0) : "At least one LogEntry has to be requested!";
        DiskLogIterator it = null;
        LogEntry le = null;
        Object object = this.babuInterface.getCheckpointerLock();
        synchronized (object) {
            try {
                this.babuInterface.waitForCheckpoint();
                try {
                    it = this.fileIO.getLogEntryIterator(firstEntryNeeded);
                }
                catch (LogEntryException exc) {
                    Logging.logMessage((int)7, (Object)this, (String)"Entry-log since LSN(%s) is unavailable.", (Object[])new Object[]{firstEntryNeeded.toString()});
                    Logging.logError((int)7, (Object)this, (Throwable)exc);
                    if (resultPayLoad != null) {
                        BufferPool.free((ReusableBuffer)resultPayLoad);
                    }
                    rq.sendSuccess((Message)result.setErrorCode(4).build());
                    if (le != null) {
                        le.free();
                    }
                    if (it != null) {
                        try {
                            it.destroy();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    return;
                }
                while (it.hasNext() && result.getLogEntriesCount() < 100) {
                    le = it.next();
                    try {
                        if (le.getLSN().compareTo(firstEntryNeeded) < 0) continue;
                        if (le.getLSN().compareTo(firstEntryNeeded) > 0 && result.getLogEntriesCount() == 0 || le.getLSN().compareTo(end) > 0) break;
                        assert (le.getPayload().array().length > 0) : "Empty log-entries are not allowed!";
                        ReusableBuffer buf = le.serialize(this.checksum);
                        result.addLogEntries(GlobalTypes.LogEntry.newBuilder().setLength(buf.remaining()));
                        int newSize = resultPayLoad.position() + buf.remaining();
                        if (!resultPayLoad.enlarge(newSize)) {
                            ReusableBuffer tmp = BufferPool.allocate((int)newSize);
                            tmp.put(resultPayLoad);
                            BufferPool.free((ReusableBuffer)resultPayLoad);
                            resultPayLoad = tmp;
                            assert (resultPayLoad.remaining() >= buf.remaining()) : "the target buffer (" + resultPayLoad.remaining() + ") has " + "not enough space allocated to fetch the src buffer (" + buf.remaining() + ")";
                        }
                        assert (resultPayLoad.remaining() >= buf.remaining()) : "the target buffer (" + resultPayLoad.remaining() + ") was not " + "correctly enlarged to fetch the src buffer (" + buf.remaining() + "), newSize: " + newSize;
                        resultPayLoad.put(buf);
                        BufferPool.free((ReusableBuffer)buf);
                    }
                    finally {
                        this.checksum.reset();
                        if (le == null) continue;
                        le.free();
                        le = null;
                    }
                }
                if (result.getLogEntriesCount() > 0) {
                    Logging.logMessage((int)7, (Object)this, (String)"REQUEST: returning %d log-entries to %s.", (Object[])new Object[]{result.getLogEntriesCount(), rq.getSenderAddress().toString()});
                    resultPayLoad.flip();
                    rq.sendSuccess((Message)result.build(), resultPayLoad);
                } else {
                    Logging.logMessage((int)7, (Object)this, (String)"No logentries could have been retrieved.", (Object[])new Object[0]);
                    rq.sendSuccess((Message)result.setErrorCode(4).build());
                }
            }
            catch (Exception e) {
                Logging.logError((int)6, (Object)this, (Throwable)e);
                BufferPool.free((ReusableBuffer)resultPayLoad);
                rq.sendSuccess((Message)result.setErrorCode(1).build());
            }
            finally {
                if (le != null) {
                    le.free();
                }
                if (it != null) {
                    try {
                        it.destroy();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }
}

