/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.service.operations;

import com.google.protobuf.Message;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.xtreemfs.babudb.log.LogEntry;
import org.xtreemfs.babudb.log.LogEntryException;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.pbrpc.GlobalTypes;
import org.xtreemfs.babudb.replication.service.RequestManagement;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Operation;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Request;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;

public class ReplicateOperation
extends Operation {
    private final Checksum checksum = new CRC32();
    private final RequestManagement rqMan;

    public ReplicateOperation(RequestManagement rqMan) {
        this.rqMan = rqMan;
    }

    @Override
    public int getProcedureId() {
        return 8;
    }

    @Override
    public Message getDefaultRequest() {
        return GlobalTypes.LSN.getDefaultInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(Request rq) {
        RPC.RPCHeader.ErrorResponse resp = null;
        if (resp == null) {
            resp = super.parseRPCMessage(rq);
        }
        if (resp == null) {
            ReusableBuffer data = rq.getData().createViewBuffer();
            try {
                rq.setAttachment(LogEntry.deserialize((ReusableBuffer)data, (Checksum)this.checksum));
            }
            catch (LogEntryException e) {
                Logging.logError((int)4, (Object)this, (Throwable)e);
                resp = RPC.RPCHeader.ErrorResponse.newBuilder().setErrorMessage(e.getMessage()).setErrorType(RPC.ErrorType.IO_ERROR).build();
            }
            finally {
                this.checksum.reset();
                if (data != null) {
                    BufferPool.free((ReusableBuffer)data);
                }
            }
        }
        return resp;
    }

    @Override
    public void processRequest(Request rq) {
        LogEntry le = (LogEntry)rq.getAttachment();
        LSN lsn = le.getLSN();
        try {
            Logging.logMessage((int)7, (Object)this, (String)"ReplicateOperation: received %s", (Object[])new Object[]{le.toString()});
            this.rqMan.enqueueOperation(new Object[]{lsn, le});
            rq.sendSuccess((Message)GlobalTypes.ErrorCodeResponse.getDefaultInstance());
        }
        catch (Exception e) {
            if (le != null) {
                le.free();
            }
            rq.sendSuccess((Message)GlobalTypes.ErrorCodeResponse.newBuilder().setErrorCode(1).build());
        }
    }
}

