/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.service.operations;

import com.google.protobuf.Message;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.pbrpc.GlobalTypes;
import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.control.ControlLayerInterface;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Operation;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Request;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;

public class StateOperation
extends Operation {
    private final BabuDBInterface dbInterface;
    private final ControlLayerInterface topLayer;

    public StateOperation(BabuDBInterface dbInterface, ControlLayerInterface topLayer) {
        this.dbInterface = dbInterface;
        this.topLayer = topLayer;
    }

    @Override
    public int getProcedureId() {
        return 1;
    }

    @Override
    public Message getDefaultRequest() {
        return GlobalTypes.LSN.getDefaultInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(Request rq) {
        try {
            this.topLayer.lockReplication();
            LSN state = this.dbInterface.getState();
            Logging.logMessage((int)6, (Object)this, (String)"StateOperation: reporting %s to %s.", (Object[])new Object[]{state.toString(), rq.getSenderAddress().toString()});
            rq.sendSuccess((Message)GlobalTypes.LSN.newBuilder().setViewId(state.getViewId()).setSequenceNo(state.getSequenceNo()).build());
        }
        catch (InterruptedException e) {
            Logging.logError((int)4, (Object)this, (Throwable)e);
            rq.sendError(RPC.ErrorType.INTERNAL_SERVER_ERROR, "Server could not establish a stable state, because: " + e.getMessage());
        }
        finally {
            this.topLayer.unlockReplication();
        }
    }
}

