/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.service.operations;

import com.google.protobuf.Message;
import java.net.InetSocketAddress;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.pbrpc.GlobalTypes;
import org.xtreemfs.babudb.replication.control.ControlLayerInterface;
import org.xtreemfs.babudb.replication.service.RequestManagement;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Operation;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Request;
import org.xtreemfs.foundation.logging.Logging;

public class SynchronizeOperation
extends Operation {
    private final RequestManagement rqMan;
    private final ControlLayerInterface control;

    public SynchronizeOperation(RequestManagement rqManagement, ControlLayerInterface control) {
        this.rqMan = rqManagement;
        this.control = control;
    }

    @Override
    public int getProcedureId() {
        return 9;
    }

    @Override
    public Message getDefaultRequest() {
        return GlobalTypes.HeartbeatMessage.getDefaultInstance();
    }

    @Override
    public void processRequest(Request rq) {
        GlobalTypes.HeartbeatMessage message = (GlobalTypes.HeartbeatMessage)rq.getRequestMessage();
        GlobalTypes.LSN mLSN = message.getLsn();
        LSN lsn = new LSN(mLSN.getViewId(), mLSN.getSequenceNo());
        InetSocketAddress participant = new InetSocketAddress(rq.getSenderAddress().getAddress(), message.getPort());
        Logging.logMessage((int)6, (Object)this, (String)"SynchronizeOperation:  received %s by %s", (Object[])new Object[]{lsn.toString(), participant.toString()});
        try {
            this.rqMan.createStableState(lsn, participant, this.control);
            rq.sendSuccess((Message)GlobalTypes.ErrorCodeResponse.getDefaultInstance());
        }
        catch (InterruptedException ie) {
            Logging.logMessage((int)4, (Object)this, (String)"Participant was not able to establish stable state @ LSN (%s).", (Object[])new Object[]{lsn.toString()});
            rq.sendSuccess((Message)GlobalTypes.ErrorCodeResponse.newBuilder().setErrorCode(2).build());
        }
    }
}

