/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.service.operations;

import com.google.protobuf.Message;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.pbrpc.GlobalTypes;
import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Operation;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Request;
import org.xtreemfs.foundation.logging.Logging;

public class VolatileStateOperation
extends Operation {
    private final BabuDBInterface dbInterface;

    public VolatileStateOperation(BabuDBInterface dbInterface) {
        this.dbInterface = dbInterface;
    }

    @Override
    public int getProcedureId() {
        return 10;
    }

    @Override
    public Message getDefaultRequest() {
        return GlobalTypes.LSN.getDefaultInstance();
    }

    @Override
    public void processRequest(Request rq) {
        LSN state = this.dbInterface.getState();
        Logging.logMessage((int)6, (Object)this, (String)"StateOperation: reporting %s to %s.", (Object[])new Object[]{state.toString(), rq.getSenderAddress().toString()});
        rq.sendSuccess((Message)GlobalTypes.LSN.newBuilder().setViewId(state.getViewId()).setSequenceNo(state.getSequenceNo()).build());
    }
}

