/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.transmission;

import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.foundation.logging.Logging;

public final class ErrorCode {
    public static final int OK = 0;
    public static final int BUSY = 1;
    public static final int SERVICE_UNAVAILABLE = 2;
    public static final int FILE_UNAVAILABLE = 3;
    public static final int LOG_UNAVAILABLE = 4;
    public static final int T_DB_EXISTS = 10;
    public static final int T_NO_SUCH_DB = 11;
    public static final int T_NO_SUCH_INDEX = 12;
    public static final int T_SNAP_EXISTS = 13;
    public static final int T_NO_SUCH_SNAPSHOT = 14;
    public static final int UNKNOWN = 99;

    public static final int mapUserError(BabuDBException e) {
        switch (e.getErrorCode()) {
            case DB_EXISTS: {
                return 10;
            }
            case NO_SUCH_DB: {
                return 11;
            }
            case NO_SUCH_INDEX: {
                return 12;
            }
            case SNAP_EXISTS: {
                return 13;
            }
            case NO_SUCH_SNAPSHOT: {
                return 14;
            }
        }
        Logging.logError((int)7, (Object)((Object)e), (Throwable)e);
        return 99;
    }

    public static final BabuDBException.ErrorCode mapTransmissionError(int e) {
        switch (e) {
            case 10: {
                return BabuDBException.ErrorCode.DB_EXISTS;
            }
            case 11: {
                return BabuDBException.ErrorCode.NO_SUCH_DB;
            }
            case 12: {
                return BabuDBException.ErrorCode.NO_SUCH_INDEX;
            }
            case 13: {
                return BabuDBException.ErrorCode.SNAP_EXISTS;
            }
            case 14: {
                return BabuDBException.ErrorCode.NO_SUCH_SNAPSHOT;
            }
        }
        return BabuDBException.ErrorCode.REPLICATION_FAILURE;
    }
}

