/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.transmission;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.xtreemfs.babudb.config.ReplicationConfig;
import org.xtreemfs.babudb.log.DiskLogIterator;
import org.xtreemfs.babudb.log.LogEntryException;
import org.xtreemfs.babudb.lsmdb.LSMDatabase;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.replication.transmission.FileIOInterface;
import org.xtreemfs.foundation.util.FSUtils;

public class FileIO
implements FileIOInterface {
    static final String BACKUP_BASE_DIR = "base";
    static final String BACKUP_LOG_DIR = "log";
    static final String BACKUP_LOCK_FILE = ".backupLock";
    private final ReplicationConfig configuration;

    public FileIO(ReplicationConfig config) {
        this.configuration = config;
    }

    @Override
    public LSMDatabase.DBFileMetaData getConfigFileMetaData() {
        String path = this.configuration.getBabuDBConfig().getBaseDir() + this.configuration.getBabuDBConfig().getDbCfgFile();
        long length = new File(path).length();
        return new LSMDatabase.DBFileMetaData(path, length);
    }

    @Override
    public File getFile(String fileName) throws IOException {
        File result;
        File chnk = new File(fileName);
        String fName = chnk.getName();
        String pName = chnk.getParentFile().getName();
        String baseDir = this.configuration.getBabuDBConfig().getBaseDir();
        if (LSMDatabase.isSnapshotFilename((String)pName)) {
            new File(baseDir + pName + File.separatorChar).mkdirs();
            result = new File(baseDir + chnk.getParentFile().getParentFile().getName() + File.separatorChar + pName + File.separator + fName);
            result.getParentFile().mkdirs();
            result.createNewFile();
        } else {
            result = new File(baseDir + this.configuration.getBabuDBConfig().getDbCfgFile());
            result.getParentFile().mkdirs();
            result.createNewFile();
        }
        return result;
    }

    @Override
    public DiskLogIterator getLogEntryIterator(LSN from) throws LogEntryException, IOException {
        return new DiskLogIterator(this.getLogFiles(), from);
    }

    @Override
    public void removeBackupFiles() {
        File backupDir = new File(this.configuration.getTempDir());
        if (backupDir.exists()) {
            File backupLock = new File(backupDir.getPath() + File.separator + BACKUP_LOCK_FILE);
            if (backupLock.exists()) {
                backupLock.delete();
            }
            FSUtils.delTree((File)backupDir);
        }
    }

    @Override
    public void replayBackupFiles() throws IOException {
        File backupDir = new File(this.configuration.getTempDir());
        if (backupDir.exists()) {
            File backupLock = new File(backupDir.getPath() + File.separator + BACKUP_LOCK_FILE);
            if (backupLock.exists()) {
                File baseDir = new File(this.configuration.getBabuDBConfig().getBaseDir());
                File logDir = new File(this.configuration.getBabuDBConfig().getDbLogDir());
                this.cleanUpFiles(logDir);
                this.cleanUpFiles(baseDir);
                assert (baseDir.listFiles().length == 0);
                assert (logDir.listFiles().length == 0);
                File backupBaseDir = new File(backupDir.getPath() + File.separator + BACKUP_BASE_DIR + File.separator);
                File backupLogDir = new File(backupDir.getPath() + File.separator + BACKUP_LOG_DIR + File.separator);
                FSUtils.copyTree((File)backupBaseDir, (File)baseDir);
                FSUtils.copyTree((File)backupLogDir, (File)logDir);
            }
            this.cleanUpFiles(backupDir);
            assert (backupDir.listFiles().length == 0);
        }
    }

    @Override
    public void backupFiles() throws IOException {
        File backupLock;
        File backupDir = new File(this.configuration.getTempDir());
        File baseDir = new File(this.configuration.getBabuDBConfig().getBaseDir());
        File logDir = new File(this.configuration.getBabuDBConfig().getDbLogDir());
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        }
        if (!(backupLock = new File(backupDir.getPath() + File.separator + BACKUP_LOCK_FILE)).exists()) {
            this.cleanUpFiles(backupDir);
            assert (backupDir.listFiles().length == 0);
            File backupBaseDir = new File(backupDir.getPath() + File.separator + BACKUP_BASE_DIR + File.separator);
            backupBaseDir.mkdir();
            File backupLogDir = new File(backupDir.getPath() + File.separator + BACKUP_LOG_DIR + File.separator);
            backupLogDir.mkdir();
            FSUtils.copyTree((File)baseDir, (File)backupBaseDir);
            FSUtils.copyTree((File)logDir, (File)backupLogDir);
            backupLock.createNewFile();
        }
        this.cleanUpFiles(baseDir);
        this.cleanUpFiles(logDir);
        assert (baseDir.listFiles().length == 0);
        assert (logDir.listFiles().length == 0);
    }

    private void cleanUpFiles(File parent) {
        if (parent.exists()) {
            assert (parent.isDirectory());
            for (File f : parent.listFiles()) {
                if (f.isFile()) {
                    f.delete();
                    continue;
                }
                if (f.isDirectory()) {
                    FSUtils.delTree((File)f);
                    continue;
                }
                assert (false);
            }
        }
    }

    private File[] getLogFiles() {
        File f = new File(this.configuration.getBabuDBConfig().getDbLogDir());
        File[] result = f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".dbl");
            }
        });
        return result;
    }
}

