/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.transmission;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.xtreemfs.babudb.config.ReplicationConfig;
import org.xtreemfs.babudb.replication.Layer;
import org.xtreemfs.babudb.replication.proxy.DatabaseManagerProxy;
import org.xtreemfs.babudb.replication.proxy.ProxyAccessClient;
import org.xtreemfs.babudb.replication.transmission.FileIO;
import org.xtreemfs.babudb.replication.transmission.FileIOInterface;
import org.xtreemfs.babudb.replication.transmission.TransmissionToServiceInterface;
import org.xtreemfs.babudb.replication.transmission.client.ClientFactory;
import org.xtreemfs.babudb.replication.transmission.client.ProxyAccessClientAdapter;
import org.xtreemfs.babudb.replication.transmission.client.ReplicationClientAdapter;
import org.xtreemfs.babudb.replication.transmission.dispatcher.RequestDispatcher;
import org.xtreemfs.babudb.replication.transmission.dispatcher.RequestHandler;
import org.xtreemfs.foundation.LifeCycleListener;
import org.xtreemfs.foundation.pbrpc.client.RPCNIOSocketClient;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;

public class TransmissionLayer
extends Layer
implements ClientFactory,
TransmissionToServiceInterface {
    public static final RPC.AuthType AUTH_TYPE = RPC.AuthType.AUTH_NONE;
    public static final String USER = "1.1";
    public static final RPC.Auth AUTHENTICATION = RPC.Auth.newBuilder().setAuthType(AUTH_TYPE).build();
    public static final RPC.UserCredentials USER_CREDENTIALS = RPC.UserCredentials.newBuilder().setUsername("1.1").build();
    private final RPCNIOSocketClient rpcClient;
    private final RequestDispatcher dispatcher;
    private final FileIO fileIO;

    public TransmissionLayer(ReplicationConfig config) throws IOException {
        this.fileIO = new FileIO(config);
        InetSocketAddress bindPoint = config.getAddress() != null ? new InetSocketAddress(config.getAddress(), 0) : null;
        this.rpcClient = new RPCNIOSocketClient(config.getSSLOptions(), 1000, 300000, -1, -1, (SocketAddress)bindPoint, "BabuDB Transmission Layer");
        this.dispatcher = new RequestDispatcher(config);
    }

    @Override
    public FileIOInterface getFileIOInterface() {
        return this.fileIO;
    }

    @Override
    public ReplicationClientAdapter getClient(InetSocketAddress receiver) {
        return new ReplicationClientAdapter(this.rpcClient, receiver);
    }

    @Override
    public ProxyAccessClient getProxyClient(DatabaseManagerProxy dbManProxy) {
        return new ProxyAccessClientAdapter(this.rpcClient, dbManProxy);
    }

    @Override
    public void _setLifeCycleListener(LifeCycleListener listener) {
        this.dispatcher.setLifeCycleListener(listener);
        this.rpcClient.setLifeCycleListener(listener);
    }

    @Override
    public void start() {
        try {
            this.dispatcher.start();
            this.dispatcher.waitForStartup();
            this.rpcClient.start();
            this.rpcClient.waitForStartup();
        }
        catch (Exception e) {
            this.listener.crashPerformed((Throwable)e);
        }
    }

    @Override
    public void asyncShutdown() {
        this.dispatcher.shutdown();
        this.rpcClient.shutdown();
    }

    @Override
    public void shutdown() {
        try {
            this.dispatcher.shutdown();
            this.dispatcher.waitForShutdown();
            this.rpcClient.shutdown();
            this.rpcClient.waitForShutdown();
        }
        catch (Exception e) {
            this.listener.crashPerformed((Throwable)e);
        }
    }

    @Override
    public void addRequestHandler(RequestHandler handler) {
        this.dispatcher.addHandler(handler);
    }
}

