/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.transmission.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.pbrpc.GlobalTypes;
import org.xtreemfs.babudb.pbrpc.RemoteAccessServiceClient;
import org.xtreemfs.babudb.replication.proxy.DatabaseManagerProxy;
import org.xtreemfs.babudb.replication.proxy.DatabaseProxy;
import org.xtreemfs.babudb.replication.proxy.ProxyAccessClient;
import org.xtreemfs.babudb.replication.service.clients.ClientResponseFuture;
import org.xtreemfs.babudb.replication.transmission.TransmissionLayer;
import org.xtreemfs.babudb.replication.transmission.client.ReplicationClientAdapter;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.pbrpc.client.RPCNIOSocketClient;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;

public class ProxyAccessClientAdapter
extends RemoteAccessServiceClient
implements ProxyAccessClient {
    private final DatabaseManagerProxy dbMan;

    public ProxyAccessClientAdapter(RPCNIOSocketClient client, DatabaseManagerProxy dbMan) {
        super(client, null);
        this.dbMan = dbMan;
    }

    @Override
    public ClientResponseFuture<Object, GlobalTypes.Database> makePersistent(InetSocketAddress master, ReusableBuffer data) {
        assert (master != null);
        try {
            RPCResponse<GlobalTypes.Database> result = this.makePersistent(master, TransmissionLayer.AUTHENTICATION, TransmissionLayer.USER_CREDENTIALS, data);
            return new ClientResponseFuture<Object, GlobalTypes.Database>(result){

                @Override
                public Object resolve(GlobalTypes.Database response, ReusableBuffer data) throws ReplicationClientAdapter.ErrorCodeException, IOException {
                    if (response.getErrorCode() != 0) {
                        throw new ReplicationClientAdapter.ErrorCodeException(response.getErrorCode());
                    }
                    if (response.getDatabaseId() > -1) {
                        return new Object[]{new DatabaseProxy(response.getDatabaseName(), response.getDatabaseId(), ProxyAccessClientAdapter.this.dbMan)};
                    }
                    return new Object[0];
                }
            };
        }
        catch (IOException e) {
            return new ClientResponseFuture<Object, GlobalTypes.Database>(null){

                @Override
                public Object resolve(GlobalTypes.Database response, ReusableBuffer data) throws ReplicationClientAdapter.ErrorCodeException, IOException {
                    throw e;
                }
            };
        }
    }

    @Override
    public ClientResponseFuture<Integer, GlobalTypes.Database> getDatabase(String dbName, InetSocketAddress master) {
        assert (master != null);
        try {
            RPCResponse<GlobalTypes.Database> result = this.getDatabaseByName(master, TransmissionLayer.AUTHENTICATION, TransmissionLayer.USER_CREDENTIALS, dbName);
            return new ClientResponseFuture<Integer, GlobalTypes.Database>(result){

                @Override
                public Integer resolve(GlobalTypes.Database response, ReusableBuffer data) throws ReplicationClientAdapter.ErrorCodeException, IOException {
                    if (response.getErrorCode() != 0) {
                        throw new ReplicationClientAdapter.ErrorCodeException(response.getErrorCode());
                    }
                    return response.getDatabaseId();
                }
            };
        }
        catch (IOException e) {
            return new ClientResponseFuture<Integer, GlobalTypes.Database>(null){

                @Override
                public Integer resolve(GlobalTypes.Database response, ReusableBuffer data) throws ReplicationClientAdapter.ErrorCodeException, IOException {
                    throw e;
                }
            };
        }
    }

    @Override
    public ClientResponseFuture<Map<String, Integer>, GlobalTypes.Databases> getDatabases(InetSocketAddress master) {
        assert (master != null);
        try {
            RPCResponse<GlobalTypes.Databases> result = this.getDatabases(master, TransmissionLayer.AUTHENTICATION, TransmissionLayer.USER_CREDENTIALS);
            return new ClientResponseFuture<Map<String, Integer>, GlobalTypes.Databases>(result){

                @Override
                public Map<String, Integer> resolve(GlobalTypes.Databases response, ReusableBuffer data) throws ReplicationClientAdapter.ErrorCodeException, IOException {
                    HashMap<String, Integer> r = new HashMap<String, Integer>();
                    for (GlobalTypes.Database db : response.getDatabaseList()) {
                        r.put(db.getDatabaseName(), db.getDatabaseId());
                    }
                    return r;
                }
            };
        }
        catch (IOException e) {
            return new ClientResponseFuture<Map<String, Integer>, GlobalTypes.Databases>(null){

                @Override
                public Map<String, Integer> resolve(GlobalTypes.Databases response, ReusableBuffer data) throws ReplicationClientAdapter.ErrorCodeException, IOException {
                    throw e;
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientResponseFuture<byte[], GlobalTypes.ErrorCodeResponse> lookup(String dbName, int indexId, ReusableBuffer key, InetSocketAddress master) {
        assert (master != null);
        try {
            RPCResponse<GlobalTypes.ErrorCodeResponse> result = this.lookup(master, TransmissionLayer.AUTHENTICATION, TransmissionLayer.USER_CREDENTIALS, dbName, indexId, key);
            ClientResponseFuture<byte[], GlobalTypes.ErrorCodeResponse> clientResponseFuture = new ClientResponseFuture<byte[], GlobalTypes.ErrorCodeResponse>(result){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public byte[] resolve(GlobalTypes.ErrorCodeResponse response, ReusableBuffer data) throws ReplicationClientAdapter.ErrorCodeException, IOException {
                    if (response.getErrorCode() != 0) {
                        throw new ReplicationClientAdapter.ErrorCodeException(response.getErrorCode());
                    }
                    try {
                        byte[] byArray = data == null ? null : data.array();
                        return byArray;
                    }
                    finally {
                        if (data != null) {
                            BufferPool.free((ReusableBuffer)data);
                        }
                    }
                }
            };
            return clientResponseFuture;
        }
        catch (IOException e) {
            ClientResponseFuture<byte[], GlobalTypes.ErrorCodeResponse> clientResponseFuture = new ClientResponseFuture<byte[], GlobalTypes.ErrorCodeResponse>(null){

                @Override
                public byte[] resolve(GlobalTypes.ErrorCodeResponse response, ReusableBuffer data) throws ReplicationClientAdapter.ErrorCodeException, IOException {
                    throw e;
                }
            };
            return clientResponseFuture;
        }
        finally {
            BufferPool.free((ReusableBuffer)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientResponseFuture<ResultSet<byte[], byte[]>, GlobalTypes.EntryMap> prefixLookup(String dbName, int indexId, ReusableBuffer key, InetSocketAddress master) {
        assert (master != null);
        try {
            RPCResponse<GlobalTypes.EntryMap> result = this.plookup(master, TransmissionLayer.AUTHENTICATION, TransmissionLayer.USER_CREDENTIALS, dbName, indexId, key);
            ClientResponseFuture<ResultSet<byte[], byte[]>, GlobalTypes.EntryMap> clientResponseFuture = new ClientResponseFuture<ResultSet<byte[], byte[]>, GlobalTypes.EntryMap>(result){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ResultSet<byte[], byte[]> resolve(GlobalTypes.EntryMap response, ReusableBuffer data) throws ReplicationClientAdapter.ErrorCodeException, IOException {
                    if (response.getErrorCode() != 0) {
                        throw new ReplicationClientAdapter.ErrorCodeException(response.getErrorCode());
                    }
                    try {
                        int count = response.getLengthCount();
                        assert (count % 2 == 0);
                        ArrayList m = new ArrayList();
                        byte[] k = null;
                        byte[] v = null;
                        for (int i = 0; i < count; ++i) {
                            int length = response.getLength(i);
                            v = new byte[length];
                            data.get(v, 0, length);
                            if (i % 2 == 0) {
                                k = v;
                                continue;
                            }
                            m.add(new SimpleEntry(k, v));
                        }
                        final Iterator iter = m.iterator();
                        ResultSet<byte[], byte[]> resultSet = new ResultSet<byte[], byte[]>(){

                            public void remove() {
                                iter.remove();
                            }

                            public Map.Entry<byte[], byte[]> next() {
                                return (Map.Entry)iter.next();
                            }

                            public boolean hasNext() {
                                return iter.hasNext();
                            }

                            public void free() {
                            }
                        };
                        return resultSet;
                    }
                    finally {
                        BufferPool.free((ReusableBuffer)data);
                    }
                }
            };
            return clientResponseFuture;
        }
        catch (IOException e) {
            ClientResponseFuture<ResultSet<byte[], byte[]>, GlobalTypes.EntryMap> clientResponseFuture = new ClientResponseFuture<ResultSet<byte[], byte[]>, GlobalTypes.EntryMap>(null){

                @Override
                public ResultSet<byte[], byte[]> resolve(GlobalTypes.EntryMap response, ReusableBuffer data) throws ReplicationClientAdapter.ErrorCodeException, IOException {
                    throw e;
                }
            };
            return clientResponseFuture;
        }
        finally {
            BufferPool.free((ReusableBuffer)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientResponseFuture<ResultSet<byte[], byte[]>, GlobalTypes.EntryMap> prefixLookupR(String dbName, int indexId, ReusableBuffer key, InetSocketAddress master) {
        assert (master != null);
        try {
            RPCResponse<GlobalTypes.EntryMap> result = this.plookupReverse(master, TransmissionLayer.AUTHENTICATION, TransmissionLayer.USER_CREDENTIALS, dbName, indexId, key);
            ClientResponseFuture<ResultSet<byte[], byte[]>, GlobalTypes.EntryMap> clientResponseFuture = new ClientResponseFuture<ResultSet<byte[], byte[]>, GlobalTypes.EntryMap>(result){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ResultSet<byte[], byte[]> resolve(GlobalTypes.EntryMap response, ReusableBuffer data) throws ReplicationClientAdapter.ErrorCodeException, IOException {
                    if (response.getErrorCode() != 0) {
                        throw new ReplicationClientAdapter.ErrorCodeException(response.getErrorCode());
                    }
                    try {
                        int count = response.getLengthCount();
                        assert (count % 2 == 0);
                        ArrayList m = new ArrayList();
                        byte[] k = null;
                        byte[] v = null;
                        for (int i = 0; i < count; ++i) {
                            int length = response.getLength(i);
                            v = new byte[length];
                            data.get(v, 0, length);
                            if (i % 2 == 0) {
                                k = v;
                                continue;
                            }
                            m.add(new SimpleEntry(k, v));
                        }
                        final Iterator iter = m.iterator();
                        ResultSet<byte[], byte[]> resultSet = new ResultSet<byte[], byte[]>(){

                            public void remove() {
                                iter.remove();
                            }

                            public Map.Entry<byte[], byte[]> next() {
                                return (Map.Entry)iter.next();
                            }

                            public boolean hasNext() {
                                return iter.hasNext();
                            }

                            public void free() {
                            }
                        };
                        return resultSet;
                    }
                    finally {
                        BufferPool.free((ReusableBuffer)data);
                    }
                }
            };
            return clientResponseFuture;
        }
        catch (IOException e) {
            ClientResponseFuture<ResultSet<byte[], byte[]>, GlobalTypes.EntryMap> clientResponseFuture = new ClientResponseFuture<ResultSet<byte[], byte[]>, GlobalTypes.EntryMap>(null){

                @Override
                public ResultSet<byte[], byte[]> resolve(GlobalTypes.EntryMap response, ReusableBuffer data) throws ReplicationClientAdapter.ErrorCodeException, IOException {
                    throw e;
                }
            };
            return clientResponseFuture;
        }
        finally {
            BufferPool.free((ReusableBuffer)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientResponseFuture<ResultSet<byte[], byte[]>, GlobalTypes.EntryMap> rangeLookup(String dbName, int indexId, ReusableBuffer from, ReusableBuffer to, InetSocketAddress master) {
        assert (master != null);
        ReusableBuffer payload = BufferPool.allocate((int)(from.remaining() + to.remaining()));
        payload.put(from);
        payload.put(to);
        try {
            RPCResponse<GlobalTypes.EntryMap> result = this.rlookup(master, TransmissionLayer.AUTHENTICATION, TransmissionLayer.USER_CREDENTIALS, dbName, indexId, from.remaining(), payload);
            ClientResponseFuture<ResultSet<byte[], byte[]>, GlobalTypes.EntryMap> clientResponseFuture = new ClientResponseFuture<ResultSet<byte[], byte[]>, GlobalTypes.EntryMap>(result){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ResultSet<byte[], byte[]> resolve(GlobalTypes.EntryMap response, ReusableBuffer data) throws ReplicationClientAdapter.ErrorCodeException, IOException {
                    if (response.getErrorCode() != 0) {
                        throw new ReplicationClientAdapter.ErrorCodeException(response.getErrorCode());
                    }
                    try {
                        int count = response.getLengthCount();
                        assert (count % 2 == 0);
                        ArrayList m = new ArrayList();
                        byte[] k = null;
                        byte[] v = null;
                        for (int i = 0; i < count; ++i) {
                            int length = response.getLength(i);
                            v = new byte[length];
                            data.get(v, 0, length);
                            if (i % 2 == 0) {
                                k = v;
                                continue;
                            }
                            m.add(new SimpleEntry(k, v));
                        }
                        final Iterator iter = m.iterator();
                        ResultSet<byte[], byte[]> resultSet = new ResultSet<byte[], byte[]>(){

                            public void remove() {
                                iter.remove();
                            }

                            public Map.Entry<byte[], byte[]> next() {
                                return (Map.Entry)iter.next();
                            }

                            public boolean hasNext() {
                                return iter.hasNext();
                            }

                            public void free() {
                            }
                        };
                        return resultSet;
                    }
                    finally {
                        BufferPool.free((ReusableBuffer)data);
                    }
                }
            };
            return clientResponseFuture;
        }
        catch (IOException e) {
            ClientResponseFuture<ResultSet<byte[], byte[]>, GlobalTypes.EntryMap> clientResponseFuture = new ClientResponseFuture<ResultSet<byte[], byte[]>, GlobalTypes.EntryMap>(null){

                @Override
                public ResultSet<byte[], byte[]> resolve(GlobalTypes.EntryMap response, ReusableBuffer data) throws ReplicationClientAdapter.ErrorCodeException, IOException {
                    throw e;
                }
            };
            return clientResponseFuture;
        }
        finally {
            BufferPool.free((ReusableBuffer)from);
            BufferPool.free((ReusableBuffer)to);
            BufferPool.free((ReusableBuffer)payload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientResponseFuture<ResultSet<byte[], byte[]>, GlobalTypes.EntryMap> rangeLookupR(String dbName, int indexId, ReusableBuffer from, ReusableBuffer to, InetSocketAddress master) {
        assert (master != null);
        ReusableBuffer payload = BufferPool.allocate((int)(from.remaining() + to.remaining()));
        payload.put(from);
        payload.put(to);
        try {
            RPCResponse<GlobalTypes.EntryMap> result = this.rlookupReverse(master, TransmissionLayer.AUTHENTICATION, TransmissionLayer.USER_CREDENTIALS, dbName, indexId, from.remaining(), payload);
            ClientResponseFuture<ResultSet<byte[], byte[]>, GlobalTypes.EntryMap> clientResponseFuture = new ClientResponseFuture<ResultSet<byte[], byte[]>, GlobalTypes.EntryMap>(result){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ResultSet<byte[], byte[]> resolve(GlobalTypes.EntryMap response, ReusableBuffer data) throws ReplicationClientAdapter.ErrorCodeException, IOException {
                    if (response.getErrorCode() != 0) {
                        throw new ReplicationClientAdapter.ErrorCodeException(response.getErrorCode());
                    }
                    try {
                        int count = response.getLengthCount();
                        assert (count % 2 == 0);
                        ArrayList m = new ArrayList();
                        byte[] k = null;
                        byte[] v = null;
                        for (int i = 0; i < count; ++i) {
                            int length = response.getLength(i);
                            v = new byte[length];
                            data.get(v, 0, length);
                            if (i % 2 == 0) {
                                k = v;
                                continue;
                            }
                            m.add(new SimpleEntry(k, v));
                        }
                        final Iterator iter = m.iterator();
                        ResultSet<byte[], byte[]> resultSet = new ResultSet<byte[], byte[]>(){

                            public void remove() {
                                iter.remove();
                            }

                            public Map.Entry<byte[], byte[]> next() {
                                return (Map.Entry)iter.next();
                            }

                            public boolean hasNext() {
                                return iter.hasNext();
                            }

                            public void free() {
                            }
                        };
                        return resultSet;
                    }
                    finally {
                        BufferPool.free((ReusableBuffer)data);
                    }
                }
            };
            return clientResponseFuture;
        }
        catch (IOException e) {
            ClientResponseFuture<ResultSet<byte[], byte[]>, GlobalTypes.EntryMap> clientResponseFuture = new ClientResponseFuture<ResultSet<byte[], byte[]>, GlobalTypes.EntryMap>(null){

                @Override
                public ResultSet<byte[], byte[]> resolve(GlobalTypes.EntryMap response, ReusableBuffer data) throws ReplicationClientAdapter.ErrorCodeException, IOException {
                    throw e;
                }
            };
            return clientResponseFuture;
        }
        finally {
            BufferPool.free((ReusableBuffer)from);
            BufferPool.free((ReusableBuffer)to);
            BufferPool.free((ReusableBuffer)payload);
        }
    }

    @Override
    public ClientResponseFuture<String, GlobalTypes.Database> getDatabase(int dbId, InetSocketAddress master) {
        assert (master != null);
        try {
            RPCResponse<GlobalTypes.Database> result = this.getDatabaseById(master, TransmissionLayer.AUTHENTICATION, TransmissionLayer.USER_CREDENTIALS, dbId);
            return new ClientResponseFuture<String, GlobalTypes.Database>(result){

                @Override
                public String resolve(GlobalTypes.Database response, ReusableBuffer data) throws ReplicationClientAdapter.ErrorCodeException, IOException {
                    if (response.getErrorCode() != 0) {
                        throw new ReplicationClientAdapter.ErrorCodeException(response.getErrorCode());
                    }
                    return response.getDatabaseName();
                }
            };
        }
        catch (IOException e) {
            return new ClientResponseFuture<String, GlobalTypes.Database>(null){

                @Override
                public String resolve(GlobalTypes.Database response, ReusableBuffer data) throws ReplicationClientAdapter.ErrorCodeException, IOException {
                    throw e;
                }
            };
        }
    }

    private static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        private SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

