/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.transmission.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.xtreemfs.babudb.lsmdb.LSMDatabase;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.pbrpc.GlobalTypes;
import org.xtreemfs.babudb.pbrpc.ReplicationServiceClient;
import org.xtreemfs.babudb.replication.service.clients.ClientInterface;
import org.xtreemfs.babudb.replication.service.clients.ClientResponseFuture;
import org.xtreemfs.babudb.replication.service.clients.MasterClient;
import org.xtreemfs.babudb.replication.service.clients.SlaveClient;
import org.xtreemfs.babudb.replication.service.logic.LoadLogic;
import org.xtreemfs.babudb.replication.transmission.TransmissionLayer;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.flease.comm.FleaseMessage;
import org.xtreemfs.foundation.pbrpc.client.RPCNIOSocketClient;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;

public class ReplicationClientAdapter
extends ReplicationServiceClient
implements MasterClient,
SlaveClient {
    private final InetSocketAddress defaultServer;

    public ReplicationClientAdapter(RPCNIOSocketClient client, InetSocketAddress defaultServer) {
        super(client, defaultServer);
        this.defaultServer = defaultServer;
    }

    @Override
    public InetSocketAddress getDefaultServerAddress() {
        return this.defaultServer;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ClientInterface) {
            return this.getDefaultServerAddress().equals(((ClientInterface)obj).getDefaultServerAddress());
        }
        return false;
    }

    @Override
    public String toString() {
        return "RPC-Client for server " + this.defaultServer.toString();
    }

    @Override
    public ClientResponseFuture<LSN, GlobalTypes.LSN> state() {
        RPCResponse<GlobalTypes.LSN> result = null;
        try {
            result = this.state(null, TransmissionLayer.AUTHENTICATION, TransmissionLayer.USER_CREDENTIALS);
            return new ClientResponseFuture<LSN, GlobalTypes.LSN>(result){

                @Override
                public LSN resolve(GlobalTypes.LSN response, ReusableBuffer data) throws ErrorCodeException {
                    return new LSN(response.getViewId(), response.getSequenceNo());
                }
            };
        }
        catch (IOException e) {
            return new ClientResponseFuture<LSN, GlobalTypes.LSN>(null){

                @Override
                public LSN resolve(GlobalTypes.LSN response, ReusableBuffer data) throws ErrorCodeException, IOException {
                    throw e;
                }
            };
        }
    }

    @Override
    public ClientResponseFuture<LSN, GlobalTypes.LSN> volatileState() {
        try {
            RPCResponse<GlobalTypes.LSN> result = this.volatileState(null, TransmissionLayer.AUTHENTICATION, TransmissionLayer.USER_CREDENTIALS);
            return new ClientResponseFuture<LSN, GlobalTypes.LSN>(result){

                @Override
                public LSN resolve(GlobalTypes.LSN response, ReusableBuffer data) throws ErrorCodeException, IOException {
                    return new LSN(response.getViewId(), response.getSequenceNo());
                }
            };
        }
        catch (IOException e) {
            return new ClientResponseFuture<LSN, GlobalTypes.LSN>(null){

                @Override
                public LSN resolve(GlobalTypes.LSN response, ReusableBuffer data) throws ErrorCodeException, IOException {
                    throw e;
                }
            };
        }
    }

    @Override
    public ClientResponseFuture<Long, GlobalTypes.Timestamp> time() {
        try {
            RPCResponse<GlobalTypes.Timestamp> result = this.localTime(null, TransmissionLayer.AUTHENTICATION, TransmissionLayer.USER_CREDENTIALS);
            return new ClientResponseFuture<Long, GlobalTypes.Timestamp>(result){

                @Override
                public Long resolve(GlobalTypes.Timestamp response, ReusableBuffer data) throws ErrorCodeException, IOException {
                    if (response.getErrorCode() != 0) {
                        throw new ErrorCodeException(response.getErrorCode());
                    }
                    return response.getValue();
                }
            };
        }
        catch (IOException e) {
            return new ClientResponseFuture<Long, GlobalTypes.Timestamp>(null){

                @Override
                public Long resolve(GlobalTypes.Timestamp response, ReusableBuffer data) throws ErrorCodeException, IOException {
                    throw e;
                }
            };
        }
    }

    @Override
    public ClientResponseFuture<Object, GlobalTypes.ErrorCodeResponse> flease(FleaseMessage message) {
        ReusableBuffer payload = BufferPool.allocate((int)message.getSize());
        InetSocketAddress sender = message.getSender();
        message.serialize(payload);
        payload.flip();
        try {
            RPCResponse<GlobalTypes.ErrorCodeResponse> result = this.flease(null, TransmissionLayer.AUTHENTICATION, TransmissionLayer.USER_CREDENTIALS, sender.getAddress().getHostAddress(), sender.getPort(), payload);
            return new ClientResponseFuture<Object, GlobalTypes.ErrorCodeResponse>(result){

                @Override
                public Object resolve(GlobalTypes.ErrorCodeResponse response, ReusableBuffer data) throws ErrorCodeException, IOException {
                    if (response.getErrorCode() != 0) {
                        throw new ErrorCodeException(response.getErrorCode());
                    }
                    return null;
                }
            };
        }
        catch (IOException e) {
            BufferPool.free((ReusableBuffer)payload);
            return new ClientResponseFuture<Object, GlobalTypes.ErrorCodeResponse>(null){

                @Override
                public Object resolve(GlobalTypes.ErrorCodeResponse response, ReusableBuffer data) throws ErrorCodeException, IOException {
                    throw e;
                }
            };
        }
    }

    @Override
    public ClientResponseFuture<Object, GlobalTypes.ErrorCodeResponse> heartbeat(LSN lsn, int port) {
        try {
            RPCResponse<GlobalTypes.ErrorCodeResponse> result = this.heartbeat(null, TransmissionLayer.AUTHENTICATION, TransmissionLayer.USER_CREDENTIALS, port, GlobalTypes.LSN.newBuilder().setViewId(lsn.getViewId()).setSequenceNo(lsn.getSequenceNo()).build());
            return new ClientResponseFuture<Object, GlobalTypes.ErrorCodeResponse>(result){

                @Override
                public Object resolve(GlobalTypes.ErrorCodeResponse response, ReusableBuffer data) throws ErrorCodeException, IOException {
                    if (response.getErrorCode() != 0) {
                        throw new ErrorCodeException(response.getErrorCode());
                    }
                    return null;
                }
            };
        }
        catch (IOException e) {
            return new ClientResponseFuture<Object, GlobalTypes.ErrorCodeResponse>(null){

                @Override
                public Object resolve(GlobalTypes.ErrorCodeResponse response, ReusableBuffer data) throws ErrorCodeException, IOException {
                    throw e;
                }
            };
        }
    }

    @Override
    public ClientResponseFuture<Object, GlobalTypes.ErrorCodeResponse> synchronize(LSN lsn, int port) {
        try {
            RPCResponse<GlobalTypes.ErrorCodeResponse> result = this.synchronize(null, TransmissionLayer.AUTHENTICATION, TransmissionLayer.USER_CREDENTIALS, port, GlobalTypes.LSN.newBuilder().setViewId(lsn.getViewId()).setSequenceNo(lsn.getSequenceNo()).build());
            return new ClientResponseFuture<Object, GlobalTypes.ErrorCodeResponse>(result){

                @Override
                public Object resolve(GlobalTypes.ErrorCodeResponse response, ReusableBuffer data) throws ErrorCodeException, IOException {
                    if (response.getErrorCode() != 0) {
                        throw new ErrorCodeException(response.getErrorCode());
                    }
                    return null;
                }
            };
        }
        catch (IOException e) {
            return new ClientResponseFuture<Object, GlobalTypes.ErrorCodeResponse>(null){

                @Override
                public Object resolve(GlobalTypes.ErrorCodeResponse response, ReusableBuffer data) throws ErrorCodeException, IOException {
                    throw e;
                }
            };
        }
    }

    @Override
    public ClientResponseFuture<ReusableBuffer[], GlobalTypes.LogEntries> replica(LSN lastInserted, LSN end) {
        GlobalTypes.LSN s = GlobalTypes.LSN.newBuilder().setViewId(lastInserted.getViewId()).setSequenceNo(lastInserted.getSequenceNo()).build();
        GlobalTypes.LSN f = GlobalTypes.LSN.newBuilder().setViewId(end.getViewId()).setSequenceNo(end.getSequenceNo()).build();
        try {
            RPCResponse<GlobalTypes.LogEntries> result = this.replica(null, TransmissionLayer.AUTHENTICATION, TransmissionLayer.USER_CREDENTIALS, s, f);
            return new ClientResponseFuture<ReusableBuffer[], GlobalTypes.LogEntries>(result){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ReusableBuffer[] resolve(GlobalTypes.LogEntries response, ReusableBuffer data) throws ErrorCodeException, IOException {
                    try {
                        if (response.getErrorCode() != 0) {
                            throw new ErrorCodeException(response.getErrorCode());
                        }
                        int leCount = response.getLogEntriesCount();
                        ReusableBuffer[] r = new ReusableBuffer[leCount];
                        if (data != null) {
                            int pos = 0;
                            for (int i = 0; i < leCount; ++i) {
                                r[i] = data.createViewBuffer();
                                r[i].position(pos);
                                assert (response.getLogEntries(i).getLength() > 0L);
                                pos = (int)((long)pos + response.getLogEntries(i).getLength());
                                r[i].limit(pos);
                            }
                            assert (pos == data.remaining()) : "pos " + pos + " != remaining " + data.remaining();
                        }
                        ReusableBuffer[] reusableBufferArray = r;
                        return reusableBufferArray;
                    }
                    finally {
                        if (data != null) {
                            BufferPool.free((ReusableBuffer)data);
                        }
                    }
                }
            };
        }
        catch (IOException e) {
            return new ClientResponseFuture<ReusableBuffer[], GlobalTypes.LogEntries>(null){

                @Override
                public ReusableBuffer[] resolve(GlobalTypes.LogEntries response, ReusableBuffer data) throws ErrorCodeException, IOException {
                    throw e;
                }
            };
        }
    }

    @Override
    public ClientResponseFuture<ReusableBuffer, GlobalTypes.ErrorCodeResponse> chunk(String fileName, long start, long end) {
        try {
            RPCResponse<GlobalTypes.ErrorCodeResponse> result = this.chunk(null, TransmissionLayer.AUTHENTICATION, TransmissionLayer.USER_CREDENTIALS, fileName, start, end);
            return new ClientResponseFuture<ReusableBuffer, GlobalTypes.ErrorCodeResponse>(result){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ReusableBuffer resolve(GlobalTypes.ErrorCodeResponse response, ReusableBuffer data) throws ErrorCodeException, IOException {
                    try {
                        if (response.getErrorCode() != 0) {
                            throw new ErrorCodeException(response.getErrorCode());
                        }
                        ReusableBuffer reusableBuffer = data.createViewBuffer();
                        return reusableBuffer;
                    }
                    finally {
                        if (data != null) {
                            BufferPool.free((ReusableBuffer)data);
                        }
                    }
                }
            };
        }
        catch (IOException e) {
            return new ClientResponseFuture<ReusableBuffer, GlobalTypes.ErrorCodeResponse>(null){

                @Override
                public ReusableBuffer resolve(GlobalTypes.ErrorCodeResponse response, ReusableBuffer data) throws ErrorCodeException, IOException {
                    throw e;
                }
            };
        }
    }

    @Override
    public ClientResponseFuture<LoadLogic.DBFileMetaDataSet, GlobalTypes.DBFileMetaDatas> load(LSN lsn) {
        try {
            RPCResponse<GlobalTypes.DBFileMetaDatas> result = this.load(null, TransmissionLayer.AUTHENTICATION, TransmissionLayer.USER_CREDENTIALS, lsn.getViewId(), lsn.getSequenceNo());
            return new ClientResponseFuture<LoadLogic.DBFileMetaDataSet, GlobalTypes.DBFileMetaDatas>(result){

                @Override
                public LoadLogic.DBFileMetaDataSet resolve(GlobalTypes.DBFileMetaDatas response, ReusableBuffer data) throws ErrorCodeException, IOException {
                    if (response.getErrorCode() != 0) {
                        throw new ErrorCodeException(response.getErrorCode());
                    }
                    ArrayList<LSMDatabase.DBFileMetaData> c = new ArrayList<LSMDatabase.DBFileMetaData>();
                    for (int i = 0; i < response.getDbFileMetadatasCount(); ++i) {
                        GlobalTypes.DBFileMetaData md = response.getDbFileMetadatas(i);
                        c.add(new LSMDatabase.DBFileMetaData(md.getFileName(), md.getFileSize()));
                    }
                    return new LoadLogic.DBFileMetaDataSet(response.getMaxChunkSize(), c);
                }
            };
        }
        catch (IOException e) {
            return new ClientResponseFuture<LoadLogic.DBFileMetaDataSet, GlobalTypes.DBFileMetaDatas>(null){

                @Override
                public LoadLogic.DBFileMetaDataSet resolve(GlobalTypes.DBFileMetaDatas response, ReusableBuffer data) throws ErrorCodeException, IOException {
                    throw e;
                }
            };
        }
    }

    @Override
    public ClientResponseFuture<Object, GlobalTypes.ErrorCodeResponse> replicate(LSN lsn, ReusableBuffer data) {
        try {
            RPCResponse<GlobalTypes.ErrorCodeResponse> result = this.replicate(null, TransmissionLayer.AUTHENTICATION, TransmissionLayer.USER_CREDENTIALS, lsn.getViewId(), lsn.getSequenceNo(), data);
            return new ClientResponseFuture<Object, GlobalTypes.ErrorCodeResponse>(result){

                @Override
                public Object resolve(GlobalTypes.ErrorCodeResponse response, ReusableBuffer data) throws ErrorCodeException, IOException {
                    if (response.getErrorCode() != 0) {
                        throw new ErrorCodeException(response.getErrorCode());
                    }
                    return null;
                }
            };
        }
        catch (IOException e) {
            return new ClientResponseFuture<Object, GlobalTypes.ErrorCodeResponse>(null){

                @Override
                public Object resolve(GlobalTypes.ErrorCodeResponse response, ReusableBuffer data) throws ErrorCodeException, IOException {
                    throw e;
                }
            };
        }
    }

    public static final class ErrorCodeException
    extends Exception {
        private static final long serialVersionUID = 5809888158292614295L;
        private final int code;

        public ErrorCodeException(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        @Override
        public String getMessage() {
            return "Operation failed with transmitting-error-code: " + this.code;
        }
    }
}

