/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.transmission.dispatcher;

import com.google.protobuf.Message;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import org.xtreemfs.babudb.log.LogEntry;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Operation;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.server.RPCServerRequest;
import org.xtreemfs.foundation.pbrpc.utils.ReusableBufferInputStream;
import org.xtreemfs.foundation.util.OutputUtils;

public class Request
implements Comparable<Request> {
    private static long rqIdCounter = 1L;
    private final RPCServerRequest rpcRequest;
    private Message requestMessage;
    private long requestId;
    private Object attachment;
    private final Operation replicationOperation;
    private final long timestamp;
    private boolean expired;

    Request(RPCServerRequest rpcRequest, long timestamp, Operation operation) {
        this.rpcRequest = rpcRequest;
        this.requestId = rqIdCounter++;
        this.timestamp = timestamp;
        this.replicationOperation = operation;
    }

    public void deserializeMessage(Message message) throws IOException {
        ReusableBuffer payload = this.rpcRequest.getMessage();
        if (message != null) {
            if (payload != null) {
                ReusableBufferInputStream istream = new ReusableBufferInputStream(payload);
                this.requestMessage = message.newBuilderForType().mergeFrom((InputStream)istream).build();
                if (Logging.isDebug()) {
                    Logging.logMessage((int)7, (Object)this, (String)"parsed request: %s", (Object[])new Object[]{this.requestMessage.toString()});
                }
            } else {
                this.requestMessage = message.getDefaultInstanceForType();
            }
        } else {
            this.requestMessage = null;
            if (Logging.isDebug()) {
                Logging.logMessage((int)7, (Object)this, (String)"parsed request: empty message (emptyRequest)", (Object[])new Object[0]);
            }
        }
    }

    public void sendSuccess(Message response) {
        this.sendSuccess(response, null);
    }

    public void sendSuccess(Message response, ReusableBuffer data) {
        try {
            this.rpcRequest.sendResponse(response, data);
        }
        catch (IOException ex) {
            Logging.logError((int)3, (Object)this, (Throwable)ex);
        }
    }

    public void sendInternalServerError(Throwable cause) {
        if (this.rpcRequest != null) {
            this.rpcRequest.sendError(RPC.ErrorType.INTERNAL_SERVER_ERROR, RPC.POSIXErrno.POSIX_ERROR_NONE, "internal server error:" + cause, OutputUtils.stackTraceToString((Throwable)cause));
        } else {
            Logging.logMessage((int)3, (Object)this, (String)"internal server error on internal request: %s", (Object[])new Object[]{cause.toString()});
            Logging.logError((int)3, (Object)this, (Throwable)cause);
        }
    }

    public void sendError(RPC.ErrorType type, String message) {
        if (Logging.isDebug()) {
            Logging.logMessage((int)7, (Logging.Category)Logging.Category.stage, (Object)this, (String)"sending errno exception %s/%s", (Object[])new Object[]{type, message});
        }
        this.rpcRequest.sendError(type, RPC.POSIXErrno.POSIX_ERROR_NONE, message);
    }

    public void sendError(RPC.ErrorType type, String message, String debugInfo) {
        if (Logging.isDebug()) {
            Logging.logMessage((int)7, (Logging.Category)Logging.Category.stage, (Object)this, (String)"sending errno exception %s/%s/%s", (Object[])new Object[]{type, message, debugInfo});
        }
        this.rpcRequest.sendError(type, RPC.POSIXErrno.POSIX_ERROR_NONE, message, debugInfo);
    }

    public void sendError(RPC.RPCHeader.ErrorResponse error) {
        this.rpcRequest.sendError(error);
    }

    public long getRequestId() {
        return this.requestId;
    }

    public ReusableBuffer getData() {
        return this.rpcRequest.getData();
    }

    public InetSocketAddress getSenderAddress() {
        return (InetSocketAddress)this.rpcRequest.getSenderAddress();
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    public Operation getOperation() {
        return this.replicationOperation;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public boolean expired() {
        if (this.expired) {
            return true;
        }
        if (this.timestamp + 1000L < TimeSync.getGlobalTime()) {
            this.free();
            this.expired = true;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Request o) {
        return (int)(this.timestamp - o.timestamp);
    }

    private final void free() {
        this.rpcRequest.freeBuffers();
        if (this.attachment instanceof ReusableBuffer) {
            BufferPool.free((ReusableBuffer)((ReusableBuffer)this.attachment));
        } else if (this.attachment instanceof LogEntry) {
            ((LogEntry)this.attachment).free();
        }
    }
}

