/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.transmission.dispatcher;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xtreemfs.babudb.config.ReplicationConfig;
import org.xtreemfs.babudb.replication.transmission.TransmissionLayer;
import org.xtreemfs.babudb.replication.transmission.dispatcher.RequestHandler;
import org.xtreemfs.foundation.LifeCycleListener;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.server.RPCNIOSocketServer;
import org.xtreemfs.foundation.pbrpc.server.RPCServerRequest;
import org.xtreemfs.foundation.pbrpc.server.RPCServerRequestListener;

public class RequestDispatcher
implements RPCServerRequestListener {
    private final RPCNIOSocketServer rpcServer;
    private final Map<Integer, RequestHandler> handlers = new HashMap<Integer, RequestHandler>();

    public RequestDispatcher(ReplicationConfig config) throws IOException {
        this.rpcServer = new RPCNIOSocketServer(config.getPort(), config.getAddress(), (RPCServerRequestListener)this, config.getSSLOptions());
    }

    public void addHandler(RequestHandler handler) {
        this.handlers.put(handler.getInterfaceID(), handler);
    }

    public void setLifeCycleListener(LifeCycleListener listener) {
        this.rpcServer.setLifeCycleListener(listener);
    }

    public void start() {
        if (this.handlers.size() == 0) {
            Logging.logMessage((int)3, (Object)this, (String)"The dispatcher cannot be started, without any handler registered at!", (Object[])new Object[0]);
            Logging.logError((int)3, (Object)this, (Throwable)new Exception());
            throw new RuntimeException("Fatal error while initializing the replication plugin. Check log for details.");
        }
        this.rpcServer.start();
    }

    public void waitForStartup() throws Exception {
        this.rpcServer.waitForStartup();
    }

    public void waitForShutdown() throws Exception {
        this.rpcServer.waitForShutdown();
    }

    public void shutdown() {
        this.rpcServer.shutdown();
    }

    public void receiveRecord(RPCServerRequest rq) {
        Logging.logMessage((int)7, (Object)this, (String)"Dispatching request %s ...", (Object[])new Object[]{rq.toString()});
        RPC.RPCHeader hdr = rq.getHeader();
        if (hdr.getMessageType() != RPC.MessageType.RPC_REQUEST) {
            rq.sendError(RPC.ErrorType.GARBAGE_ARGS, RPC.POSIXErrno.POSIX_ERROR_NONE, "expected RPC request message type but got " + hdr.getMessageType());
            return;
        }
        RPC.RPCHeader.RequestHeader rqHdr = hdr.getRequestHeader();
        if (!rqHdr.hasAuthData() || !rqHdr.getAuthData().getAuthType().equals((Object)TransmissionLayer.AUTH_TYPE)) {
            rq.sendError(RPC.ErrorType.AUTH_FAILED, RPC.POSIXErrno.POSIX_ERROR_NONE, "only '" + TransmissionLayer.AUTH_TYPE.toString() + "' is permitted");
            return;
        }
        if (!rqHdr.hasUserCreds() || !rqHdr.getUserCreds().getUsername().equals("1.1")) {
            rq.sendError(RPC.ErrorType.AUTH_FAILED, RPC.POSIXErrno.POSIX_ERROR_NONE, "expected request from user '1.1' only");
            return;
        }
        int interfaceId = hdr.getRequestHeader().getInterfaceId();
        RequestHandler handler = this.handlers.get(interfaceId);
        if (handler == null) {
            rq.sendError(RPC.ErrorType.INVALID_PROC_ID, RPC.POSIXErrno.POSIX_ERROR_NONE, "requested handler (#" + interfaceId + ") is not accessible");
            return;
        }
        Logging.logMessage((int)7, (Object)this, (String)"... using handler %d ...", (Object[])new Object[]{handler.getInterfaceID()});
        handler.handleRequest(rq);
    }
}

