/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.transmission.dispatcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Operation;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Request;
import org.xtreemfs.babudb.replication.transmission.dispatcher.RequestControl;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.server.RPCServerRequest;
import org.xtreemfs.foundation.util.OutputUtils;

public abstract class RequestHandler
implements RequestControl {
    protected final Map<Integer, Operation> operations = new HashMap<Integer, Operation>();
    private final AtomicBoolean queuingEnabled = new AtomicBoolean(false);
    private final List<Request> queue = new ArrayList<Request>();
    private final int MAX_Q;

    public RequestHandler(int maxQ) {
        this.MAX_Q = maxQ;
    }

    public abstract int getInterfaceID();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableQueuing() {
        AtomicBoolean atomicBoolean = this.queuingEnabled;
        synchronized (atomicBoolean) {
            this.queuingEnabled.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processQueue() {
        ArrayList<Request> todo;
        AtomicBoolean atomicBoolean = this.queuingEnabled;
        synchronized (atomicBoolean) {
            this.queuingEnabled.set(false);
            todo = new ArrayList<Request>(this.queue);
            this.queue.clear();
        }
        for (Request req : todo) {
            if (req.expired()) continue;
            req.getOperation().startRequest(req);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(RPCServerRequest rq) {
        RPC.RPCHeader.RequestHeader rqHdr = rq.getHeader().getRequestHeader();
        Operation op = this.operations.get(rqHdr.getProcId());
        if (op == null) {
            rq.sendError(RPC.ErrorType.INVALID_PROC_ID, RPC.POSIXErrno.POSIX_ERROR_NONE, "requested operation (" + rqHdr.getProcId() + ") is not available");
            return;
        }
        Logging.logMessage((int)7, (Object)this, (String)"... using operation %d ...", (Object[])new Object[]{op.getProcedureId()});
        Request rpcrq = new Request(rq, TimeSync.getGlobalTime(), op);
        RPC.RPCHeader.ErrorResponse message = op.parseRPCMessage(rpcrq);
        if (message != null) {
            rq.sendError(message);
            return;
        }
        Logging.logMessage((int)7, (Object)this, (String)"... parsed successfully ...", (Object[])new Object[0]);
        AtomicBoolean atomicBoolean = this.queuingEnabled;
        synchronized (atomicBoolean) {
            if (this.queuingEnabled.get()) {
                this.queue(rpcrq);
            } else {
                try {
                    op.startRequest(rpcrq);
                }
                catch (Throwable ex) {
                    Logging.logError((int)3, (Object)this, (Throwable)ex);
                    rq.sendError(RPC.ErrorType.INTERNAL_SERVER_ERROR, RPC.POSIXErrno.POSIX_ERROR_NONE, "internal server error: " + ex.toString(), OutputUtils.stackTraceToString((Throwable)ex));
                    return;
                }
            }
        }
    }

    private void queue(Request rq) {
        Request req;
        if (this.queue.size() == this.MAX_Q && !(req = this.queue.remove(0)).expired()) {
            req.sendError(RPC.ErrorType.INTERNAL_SERVER_ERROR, "Replication setup could not have been stabilized and servers run out of buffer.");
        }
        this.queue.add(rq);
    }
}

