/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.ClientHandler;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServer;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HttpBody;
import com.sun.jdmk.comm.HttpRequest;
import com.sun.jdmk.comm.HttpResponse;
import com.sun.jdmk.comm.MalformedHttpException;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectOutputStream;
import java.net.SocketException;
import java.util.Date;
import javax.management.MBeanServer;
import javax.management.ObjectName;

abstract class GenericHttpClientHandler
extends ClientHandler {
    private static final AuthInfo nullAuthInfo = new AuthInfo(){

        public void setLogin(String login) {
            throw new IllegalArgumentException("unsupported operation");
        }

        public void setPassword(String password) {
            throw new IllegalArgumentException("unsupported operation");
        }
    };
    private GenericHttpSocket sockClient = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";

    public GenericHttpClientHandler(CommunicatorServer server, int id, GenericHttpSocket s, MBeanServer mbs, ObjectName name) {
        super(server, id, mbs, name);
        this.sockClient = s;
        this.thread.start();
    }

    protected abstract AuthInfo authenticateRequest(HttpRequest var1) throws IOException;

    protected abstract HttpResponse processPostRequest(HttpRequest var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun() {
        try {
            try {
                HttpRequest request = new HttpRequest(new HttpBody());
                boolean loopAgain = true;
                while (loopAgain) {
                    HttpResponse response = null;
                    try {
                        request.readFrom(this.sockClient.doGetInputStream());
                        response = this.processRequest(request);
                    }
                    catch (MalformedHttpException x) {
                        if (this.logger.finestOn()) {
                            this.logger.finest("doRun", "Malformed HTTP request rejected");
                        }
                        response = this.makeErrorResponse(400, "Bad Request");
                    }
                    boolean noKeepAlive = Boolean.getBoolean("com.sun.jdmk.http.server.noKeepAlive");
                    if (noKeepAlive) {
                        response.setHeader(3, "close");
                    } else {
                        response.setHeader(3, request.getHeader(3));
                    }
                    response.writeTo(this.sockClient.doGetOutputStream());
                    if (noKeepAlive) {
                        loopAgain = false;
                        continue;
                    }
                    loopAgain = response.hasKeepAliveFlag() && !this.interruptCalled;
                }
                Object var6_10 = null;
                this.closeClient();
                if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "Socket is now closed");
                }
            }
            catch (InterruptedIOException x) {
                if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "Request handler interrupted");
                }
                Object var6_11 = null;
                this.closeClient();
                if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "Socket is now closed");
                }
            }
            catch (EOFException x) {
                if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "Connection closed by peer");
                }
                Object var6_12 = null;
                this.closeClient();
                if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "Socket is now closed");
                }
            }
            catch (SocketException x) {
                if (x.getMessage().equals(InterruptSysCallMsg)) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("doRun", "Request handler interrupted");
                    }
                } else if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "I/O exception " + x);
                }
                Object var6_13 = null;
                this.closeClient();
                if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "Socket is now closed");
                }
            }
            catch (IOException x) {
                if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "I/O exception " + x);
                }
                Object var6_14 = null;
                this.closeClient();
                if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "Socket is now closed");
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_15 = null;
            this.closeClient();
            if (this.logger.finestOn()) {
                this.logger.finest("doRun", "Socket is now closed");
            }
            throw throwable;
        }
    }

    protected HttpResponse processRequest(HttpRequest request) throws IOException {
        if (this.logger.finerOn()) {
            this.logger.finer("processRequest", "Process the HTTP request");
        }
        HttpResponse response = null;
        AuthInfo authInfo = this.authenticateRequest(request);
        if (authInfo == null) {
            response = this.makeErrorResponse(401, "Unauthorized");
        } else if (request.method == 2) {
            response = this.processPostRequest(request);
        } else {
            if (this.logger.finestOn()) {
                this.logger.finest("processRequest", "Bad request: Request method not supported");
            }
            response = this.makeErrorResponse(400, "Bad Request");
        }
        return response;
    }

    protected HttpResponse makeOkResponse(byte[] data) {
        return this.makeResponse(200, "OK", data);
    }

    protected HttpResponse makeExceptionResponse(Exception exception) {
        ByteArrayOutputStream bOut = null;
        try {
            bOut = this.serialize("Exception", exception);
        }
        catch (IOException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("makeExceptionResponse", "Got IOException when serializing : " + e);
            }
            return this.makeErrorResponse(400, "Bad Request");
        }
        if (this.logger.finestOn()) {
            this.logger.finest("makeExceptionResponse", "Sending back Exception : " + exception);
        }
        return this.makeResponse(400, "Bad Request", bOut.toByteArray());
    }

    protected HttpResponse makeErrorResponse(int statusCode, String reasonPhrase) {
        return this.makeResponse(statusCode, reasonPhrase, null);
    }

    protected HttpResponse makeResponse(int statusCode, String reasonPhrase, byte[] contents) {
        HttpBody body = contents == null ? new HttpBody() : new HttpBody(contents);
        HttpResponse response = new HttpResponse(body);
        response.statusCode = statusCode;
        response.reasonPhrase = reasonPhrase;
        response.setHeader(1, "application/octet-stream");
        response.setHeader(2, new Date().toString());
        response.setHeader(4, this.getChallenge());
        return response;
    }

    protected AuthInfo makeNullAuthInfo() {
        return nullAuthInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeClient() {
        block7: {
            if (this.logger.finerOn()) {
                this.logger.finer("closeClient", "Close client ...");
            }
            if (this.sockClient != null) {
                try {
                    try {
                        this.sockClient.doDisconnect();
                    }
                    catch (IOException e) {
                        Object var3_2 = null;
                        this.sockClient = null;
                        break block7;
                    }
                    catch (CommunicationException communicationException) {
                        Object var3_3 = null;
                        this.sockClient = null;
                    }
                    Object var3_1 = null;
                    this.sockClient = null;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this.sockClient = null;
                    throw throwable;
                }
            }
        }
    }

    protected ByteArrayOutputStream serialize(String resultType, Object result) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(bOut);
        objOut.writeObject(resultType);
        objOut.writeObject(result);
        return bOut;
    }

    protected abstract String getChallenge();
}

