/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.OperationContext;
import com.sun.jdmk.ThreadContext;
import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.BASE64Decoder;
import com.sun.jdmk.comm.BASE64Encoder;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.GenericHttpClientHandler;
import com.sun.jdmk.comm.GenericHttpConnectorServer;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HttpRequest;
import com.sun.jdmk.comm.HttpResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

class GenericHttpRequestHandler
extends GenericHttpClientHandler {
    private static final String[] supportedFeatures = new String[]{"OperationContext"};
    private static final String[] methodList = new String[]{"createMBean 2 ObjectInstance", "createMBeanParams 4 ObjectInstance 2", "createMBeanLoader 3 ObjectInstance", "createMBeanLoaderParams 5 ObjectInstance 3", "getAttribute 2 Object", "getAttributes 2 AttributeList", "getDefaultDomain 0 String", "isInstanceOf 2 Boolean", "getObjectInstance 1 ObjectInstance", "getMBeanCount 0 Integer", "getMBeanServerId 0 String", "getMBeanInfo 1 MBeanInfo", "invoke 4 Object 1", "isRegistered 1 Boolean", "queryNames 2 Set", "queryMBeans 2 Set", "setAttribute 2 Object 1", "setAttributes 2 AttributeList 1", "unregisterMBean 1 Object", "remoteRequest 2 Object[]", "pingHeartBeatServer 4 String", "supports 1 Boolean"};
    private static final int CREATE_MBEAN = 0;
    private static final int CREATE_MBEAN_PARAMS = 1;
    private static final int CREATE_MBEAN_LOADER = 2;
    private static final int CREATE_MBEAN_LOADER_PARAMS = 3;
    private static final int GET_ATTRIBUTE = 4;
    private static final int GET_ATTRIBUTES = 5;
    private static final int GET_DEFAULT_DOMAIN = 6;
    private static final int IS_INSTANCE_OF = 7;
    private static final int GET_OBJECT_INSTANCE = 8;
    private static final int GET_MBEAN_COUNT = 9;
    private static final int GET_MBEAN_SERVER_ID = 10;
    private static final int GET_MBEAN_INFO = 11;
    private static final int INVOKE = 12;
    private static final int IS_REGISTERED = 13;
    private static final int QUERY_NAMES = 14;
    private static final int QUERY_MBEANS = 15;
    private static final int SET_ATTRIBUTE = 16;
    private static final int SET_ATTRIBUTES = 17;
    private static final int UNREGISTER_MBEAN = 18;
    private static final int REMOTE_REQUEST = 19;
    private static final int PING_HEART_BEAT_SERVER = 20;
    private static final int SUPPORTS = 21;
    private static final Hashtable methodTable = new Hashtable();

    public GenericHttpRequestHandler(GenericHttpConnectorServer server, int id, GenericHttpSocket s, MBeanServer mbs, ObjectName name) {
        super(server, id, s, mbs, name);
        if (mbs == null) {
            throw new CommunicationException("No MBeanServer provided");
        }
    }

    protected AuthInfo authenticateRequest(HttpRequest request) throws IOException {
        GenericHttpConnectorServer server = (GenericHttpConnectorServer)this.adaptorServer;
        if (!server.isAuthenticationOn()) {
            return this.makeNullAuthInfo();
        }
        AuthInfo authInfo = null;
        String authorization = request.getHeader(5);
        if (authorization != null && authorization.startsWith("CRAM-MD5 ")) {
            String encoding = authorization.substring("CRAM-MD5 ".length());
            byte[] decoding = new BASE64Decoder().decodeBuffer(encoding);
            String response = new String(decoding);
            authInfo = server.checkChallengeResponse(response);
        }
        if (this.logger.finestOn()) {
            if (authInfo != null) {
                this.logger.finest("authenticateRequest", "Authentication succeeded");
            } else {
                this.logger.finest("authenticateRequest", "Authentication failed");
            }
        }
        return authInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HttpResponse processPostRequest(HttpRequest request) throws IOException {
        Object result;
        String resultType;
        ThreadContext oldThreadContext;
        block22: {
            HttpResponse httpResponse;
            block21: {
                if (this.logger.finerOn()) {
                    this.logger.finer("processPostRequest", "Process a POST request = " + request.getURIPath());
                }
                if (request.getContentLength() == 0) {
                    CommunicationException ce = new CommunicationException("Content is null");
                    return this.makeExceptionResponse(ce);
                }
                String remoteOp = null;
                oldThreadContext = null;
                try {
                    try {
                        Object[] args;
                        ParsedMethod pm;
                        ByteArrayInputStream bIn = new ByteArrayInputStream(request.getContentBytes());
                        ObjectInputStream objIn = new ObjectInputStream(bIn);
                        Object contextOrRemoteOp = objIn.readObject();
                        if (contextOrRemoteOp instanceof OperationContext) {
                            oldThreadContext = ThreadContext.push("OperationContext", contextOrRemoteOp);
                            contextOrRemoteOp = objIn.readObject();
                        }
                        remoteOp = (String)contextOrRemoteOp;
                        if (this.logger.finerOn()) {
                            this.logger.finer("doRun", "Remote operation: " + remoteOp);
                        }
                        if ((pm = (ParsedMethod)methodTable.get(remoteOp)) == null) {
                            if (this.logger.finerOn()) {
                                this.logger.finer("doRun", "Unknown remote operation: " + remoteOp);
                            }
                            httpResponse = this.makeErrorResponse(400, "Bad Request");
                            Object var12_13 = null;
                            if (oldThreadContext == null) return httpResponse;
                            break block21;
                        }
                        resultType = pm.resultType;
                        if (pm.magicParam > 0) {
                            args = this.readObjects(objIn, pm.magicParam);
                            switch (pm.methodNumber) {
                                case 1: {
                                    objIn = this.mbs.deserialize((String)args[0], request.getContentBytes());
                                    break;
                                }
                                case 3: {
                                    objIn = this.mbs.deserialize((String)args[0], (ObjectName)args[2], request.getContentBytes());
                                    break;
                                }
                                case 12: 
                                case 16: 
                                case 17: {
                                    objIn = this.mbs.deserialize((ObjectName)args[0], request.getContentBytes());
                                    break;
                                }
                                default: {
                                    throw new Error("method marked as magic but not in switch: " + remoteOp);
                                }
                            }
                            contextOrRemoteOp = objIn.readObject();
                            if (contextOrRemoteOp instanceof OperationContext) {
                                contextOrRemoteOp = objIn.readObject();
                            }
                            if (!((String)contextOrRemoteOp).equals(remoteOp)) {
                                throw new Error("remoteOp changed after deserialize");
                            }
                        }
                        args = this.readObjects(objIn, pm.nParams);
                        result = this.doOperation(pm.methodNumber, args);
                        break block22;
                    }
                    catch (Exception e) {
                        if (this.logger.finerOn()) {
                            this.logger.finer("doRun", remoteOp + ":" + e.getMessage());
                        }
                        HttpResponse httpResponse2 = this.makeExceptionResponse(e);
                        Object var12_15 = null;
                        if (oldThreadContext == null) return httpResponse2;
                        ThreadContext.restore(oldThreadContext);
                        return httpResponse2;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    if (oldThreadContext != null) {
                        ThreadContext.restore(oldThreadContext);
                    }
                    throw throwable;
                }
            }
            ThreadContext.restore(oldThreadContext);
            return httpResponse;
        }
        Object var12_14 = null;
        if (oldThreadContext != null) {
            ThreadContext.restore(oldThreadContext);
        }
        ByteArrayOutputStream bOut = this.serialize(resultType, result);
        return this.makeOkResponse(bOut.toByteArray());
    }

    Object doOperation(int methodNumber, Object[] args) throws Exception {
        switch (methodNumber) {
            case 0: {
                return this.createMBean((String)args[0], (ObjectName)args[1]);
            }
            case 1: {
                return this.createMBean((String)args[0], (ObjectName)args[1], (Object[])args[2], (String[])args[3]);
            }
            case 2: {
                return this.createMBean((String)args[0], (ObjectName)args[1], (ObjectName)args[2]);
            }
            case 3: {
                return this.createMBean((String)args[0], (ObjectName)args[1], (ObjectName)args[2], (Object[])args[3], (String[])args[4]);
            }
            case 4: {
                return this.getAttribute((ObjectName)args[0], (String)args[1]);
            }
            case 5: {
                return this.getAttributes((ObjectName)args[0], (String[])args[1]);
            }
            case 6: {
                return this.getDefaultDomain();
            }
            case 7: {
                return new Boolean(this.isInstanceOf((ObjectName)args[0], (String)args[1]));
            }
            case 8: {
                return this.getObjectInstance((ObjectName)args[0]);
            }
            case 9: {
                return this.getMBeanCount();
            }
            case 10: {
                return this.getMBeanServerId();
            }
            case 11: {
                return this.getMBeanInfo((ObjectName)args[0]);
            }
            case 12: {
                return this.invoke((ObjectName)args[0], (String)args[1], (Object[])args[2], (String[])args[3]);
            }
            case 13: {
                return new Boolean(this.isRegistered((ObjectName)args[0]));
            }
            case 14: {
                return this.queryNames((ObjectName)args[0], (QueryExp)args[1]);
            }
            case 15: {
                return this.queryMBeans((ObjectName)args[0], (QueryExp)args[1]);
            }
            case 16: {
                this.setAttribute((ObjectName)args[0], (Attribute)args[1]);
                return null;
            }
            case 17: {
                return this.setAttributes((ObjectName)args[0], (AttributeList)args[1]);
            }
            case 18: {
                this.unregisterMBean((ObjectName)args[0]);
                return null;
            }
            case 19: {
                int opType = (Integer)args[0];
                return this.remoteRequest(opType, (Object[])args[1]);
            }
            case 20: {
                return this.pingHeartBeatServer((String)args[0], (Integer)args[1], (Integer)args[2], (Long)args[3]);
            }
            case 21: {
                return new Boolean(this.supports((String)args[0]));
            }
        }
        throw new Error("internal error: bad method number " + methodNumber);
    }

    private Object[] readObjects(ObjectInputStream s, int nObjects) throws IOException, ClassNotFoundException {
        Object[] objects = new Object[nObjects];
        for (int i = 0; i < nObjects; ++i) {
            objects[i] = s.readObject();
        }
        return objects;
    }

    protected String getChallenge() {
        GenericHttpConnectorServer server = (GenericHttpConnectorServer)this.adaptorServer;
        if (server.isAuthenticationOn()) {
            String challenge = server.generateChallengeResponse();
            int maxBytesPerLine = 57;
            String encoded_challenge = "";
            String chunk = null;
            int quotient = challenge.length() / 57;
            int modulus = challenge.length() % 57;
            for (int i = 0; i < quotient; ++i) {
                chunk = challenge.substring(i * 57, (i + 1) * 57);
                encoded_challenge = encoded_challenge + new BASE64Encoder().encode(chunk.getBytes());
            }
            if (modulus > 0) {
                chunk = challenge.substring(quotient * 57);
                encoded_challenge = encoded_challenge + new BASE64Encoder().encode(chunk.getBytes());
            }
            return "CRAM-MD5 " + encoded_challenge;
        }
        return null;
    }

    private ObjectInstance createMBean(String className, ObjectName name) throws InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException {
        if (this.logger.finerOn()) {
            this.logger.finer("createMBean", "createMBean");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.createMBean(className, name);
    }

    private ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException {
        if (this.logger.finerOn()) {
            this.logger.finer("createMBean", "createMBean");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.createMBean(className, name, params, signature);
    }

    private ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException, InstanceNotFoundException {
        if (this.logger.finerOn()) {
            this.logger.finer("createMBean", "createMBean");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.createMBean(className, name, loaderName);
    }

    private ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException, InstanceNotFoundException {
        if (this.logger.finerOn()) {
            this.logger.finer("createMBean", "createMBean");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.createMBean(className, name, loaderName, params, signature);
    }

    private Object getAttribute(ObjectName name, String attribute) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        if (this.logger.finerOn()) {
            this.logger.finer("getAttribute", "getAttribute");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.getAttribute(name, attribute);
    }

    private AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        if (this.logger.finerOn()) {
            this.logger.finer("getAttributes", "getAttributes");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.getAttributes(name, attributes);
    }

    private String getDefaultDomain() {
        if (this.logger.finerOn()) {
            this.logger.finer("getDefaultDomain", "getDefaultDomain");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.getDefaultDomain();
    }

    private boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        if (this.logger.finerOn()) {
            this.logger.finer("isInstanceOf", "isInstanceOf");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.isInstanceOf(name, className);
    }

    private ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        if (this.logger.finerOn()) {
            this.logger.finer("getObjectInstance", "getObjectInstance");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.getObjectInstance(name);
    }

    private Integer getMBeanCount() {
        if (this.logger.finerOn()) {
            this.logger.finer("getMBeanCount", "getMBeanCount");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.getMBeanCount();
    }

    private MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (this.logger.finerOn()) {
            this.logger.finer("getMBeanInfo", "getMBeanInfo");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.getMBeanInfo(name);
    }

    private String getMBeanServerId() {
        if (this.logger.finerOn()) {
            this.logger.finer("getMBeanServerId", "getMBeanServerId");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        try {
            return (String)this.mbs.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId");
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object invoke(ObjectName name, String methodName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (this.logger.finerOn()) {
            this.logger.finer("invoke", "invoke");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.invoke(name, methodName, params, signature);
    }

    private boolean isRegistered(ObjectName name) {
        if (this.logger.finerOn()) {
            this.logger.finer("isRegistered", "isRegistered");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.isRegistered(name);
    }

    private Set queryNames(ObjectName name, QueryExp query) {
        if (this.logger.finerOn()) {
            this.logger.finer("queryNames", "queryNames");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.queryNames(name, query);
    }

    private Set queryMBeans(ObjectName name, QueryExp query) {
        if (this.logger.finerOn()) {
            this.logger.finer("queryMBeans", "queryMBeans");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.queryMBeans(name, query);
    }

    private void setAttribute(ObjectName name, Attribute attribute) throws AttributeNotFoundException, InstanceNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (this.logger.finerOn()) {
            this.logger.finer("setAttribute", "setAttribute");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        this.mbs.setAttribute(name, attribute);
    }

    private AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        if (this.logger.finerOn()) {
            this.logger.finer("setAttributes", "setAttributes");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.setAttributes(name, attributes);
    }

    private void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        if (this.logger.finerOn()) {
            this.logger.finer("unregisterMBean", "unregisterMBean");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        this.mbs.unregisterMBean(name);
    }

    private Object[] remoteRequest(int opType, Object[] params) throws Exception {
        if (this.logger.finerOn()) {
            this.logger.finer("remoteRequest", "remoteRequest");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        GenericHttpConnectorServer server = (GenericHttpConnectorServer)this.adaptorServer;
        return server.serverNotificationDispatcher.remoteRequest(opType, params);
    }

    private String pingHeartBeatServer(String sessionId, int period, int nretries, Long notifSessionId) {
        if (this.logger.finerOn()) {
            this.logger.finer("pingHeartBeatServer", "pingHeartBeatServer");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        GenericHttpConnectorServer server = (GenericHttpConnectorServer)this.adaptorServer;
        return server.heartbeatServerHandler.pingHeartBeatServer(sessionId, period, nretries, notifSessionId);
    }

    private boolean supports(String feature) {
        if (this.logger.finerOn()) {
            this.logger.finer("supports", feature);
        }
        for (int i = 0; i < supportedFeatures.length; ++i) {
            if (!supportedFeatures[i].equals(feature)) continue;
            return true;
        }
        return false;
    }

    protected String makeDebugTag() {
        return "GenericHttpRequestHandler[" + this.adaptorServer.getProtocol() + ":" + this.adaptorServer.getPort() + "][" + this.requestId + "]";
    }

    static {
        for (int i = 0; i < methodList.length; ++i) {
            String entry = methodList[i];
            StringTokenizer tok = new StringTokenizer(entry);
            ParsedMethod pm = new ParsedMethod();
            String methodName = tok.nextToken();
            pm.methodNumber = i;
            pm.nParams = Integer.parseInt(tok.nextToken());
            pm.resultType = tok.nextToken();
            pm.magicParam = tok.hasMoreTokens() ? Integer.parseInt(tok.nextToken()) : -1;
            if (tok.hasMoreTokens()) {
                throw new Error("invalid methodList entry: " + entry);
            }
            methodTable.put(methodName, pm);
        }
    }

    private static final class ParsedMethod {
        int methodNumber;
        int nParams;
        String resultType;
        int magicParam;

        private ParsedMethod() {
        }
    }
}

