/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.CommunicatorServer;
import javax.management.MBeanServer;
import javax.management.ObjectName;

abstract class ClientHandler
implements Runnable {
    protected CommunicatorServer adaptorServer = null;
    protected int requestId = -1;
    protected MBeanServer mbs = null;
    protected ObjectName objectName = null;
    protected Thread thread = null;
    protected boolean interruptCalled = false;
    protected String dbgTag = null;
    final ClassLogger logger;

    public ClientHandler(CommunicatorServer server, int id, MBeanServer f, ObjectName n) {
        this.adaptorServer = server;
        this.requestId = id;
        this.mbs = f;
        this.objectName = n;
        this.interruptCalled = false;
        this.dbgTag = this.makeDebugTag();
        this.logger = this.makeLogger(this.dbgTag);
        this.thread = this.createThread(this);
    }

    Thread createThread(Runnable r) {
        return new Thread(this);
    }

    public void interrupt() {
        if (this.logger.finerOn()) {
            this.logger.finer("interrupt", "start");
        }
        this.interruptCalled = true;
        if (this.thread != null) {
            this.thread.interrupt();
        }
        if (this.logger.finerOn()) {
            this.logger.finer("interrupt", "end");
        }
    }

    public void join() {
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.adaptorServer.notifyClientHandlerCreated(this);
            this.doRun();
            Object var2_1 = null;
            this.adaptorServer.notifyClientHandlerDeleted(this);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.adaptorServer.notifyClientHandlerDeleted(this);
            throw throwable;
        }
    }

    public abstract void doRun();

    protected String makeDebugTag() {
        return "ClientHandler[" + this.adaptorServer.getProtocol() + ":" + this.adaptorServer.getPort() + "][" + this.requestId + "]";
    }

    ClassLogger makeLogger(String dbgTag) {
        return new ClassLogger("com.sun.jdmk.html.adaptor", dbgTag);
    }
}

