/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.ThreadContext;
import com.sun.management.comm.SnmpMibTree;
import com.sun.management.comm.SnmpSubRequestHandler;
import com.sun.management.internal.snmp.SnmpIncomingRequest;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpValue;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.agent.SnmpMibAgent;
import java.util.Enumeration;

class SnmpSubBulkRequestHandler
extends SnmpSubRequestHandler {
    private SnmpMibTree root = null;
    protected int nonRepeat = 0;
    protected int maxRepeat = 0;
    protected int globalR = 0;
    protected int size = 0;

    protected SnmpSubBulkRequestHandler(SnmpEngine engine, SnmpIncomingRequest incRequest, SnmpMibAgent agent, SnmpPdu req, int nonRepeat, int maxRepeat, int R, SnmpMibTree root) {
        super(engine, incRequest, agent, req);
        this.init(req, nonRepeat, maxRepeat, R, root);
    }

    protected SnmpSubBulkRequestHandler(SnmpMibAgent agent, SnmpPdu req, int nonRepeat, int maxRepeat, int R, SnmpMibTree root) {
        super(agent, req);
        this.init(req, nonRepeat, maxRepeat, R, root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block9: {
            this.size = this.varBind.size();
            try {
                ThreadContext oldContext = ThreadContext.push("SnmpUserData", this.data);
                try {
                    if (this.logger.finerOn()) {
                        this.logger.finer("run", "[" + Thread.currentThread() + "]:getBulk operation on " + this.agent.getMibName());
                    }
                    this.agent.getBulk(this.createMibRequest(this.varBind, this.version, this.data), this.nonRepeat, this.maxRepeat);
                    Object var3_4 = null;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    ThreadContext.restore(oldContext);
                    throw throwable;
                }
                ThreadContext.restore(oldContext);
                {
                }
            }
            catch (SnmpStatusException x) {
                this.errorStatus = x.getStatus();
                this.errorIndex = x.getErrorIndex();
                if (this.logger.finestOn()) {
                    this.logger.finest("run", "[" + Thread.currentThread() + "]:an Snmp error occured during the operation");
                }
            }
            catch (Exception x) {
                this.errorStatus = 5;
                if (this.logger.finestOn()) {
                    this.logger.finest("run", "[" + Thread.currentThread() + "]: Unexpected exception: " + x);
                    this.logger.finest("run", x);
                }
                if (!this.logger.finerOn()) break block9;
                this.logger.finer("run", "[" + Thread.currentThread() + "]:a generic error occured during the operation");
            }
        }
        if (this.logger.finerOn()) {
            this.logger.finer("run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    private void init(SnmpPdu req, int nonRepeat, int maxRepeat, int R, SnmpMibTree root) {
        this.root = root;
        this.nonRepeat = nonRepeat;
        this.maxRepeat = maxRepeat;
        this.globalR = R;
        int max = this.translation.length;
        SnmpVarBind[] list = req.varBindList;
        SnmpSubRequestHandler.NonSyncVector nonSyncVarBind = (SnmpSubRequestHandler.NonSyncVector)this.varBind;
        for (int i = 0; i < max; ++i) {
            this.translation[i] = i;
            SnmpVarBind newVarBind = new SnmpVarBind(list[i].getOid(), list[i].getSnmpValue());
            nonSyncVarBind.addNonSyncElement(newVarBind);
        }
    }

    private SnmpVarBind findVarBind(SnmpVarBind element, SnmpVarBind result) {
        if (element == null) {
            return null;
        }
        if (result.getOid() == null) {
            return element;
        }
        if (element.getSnmpValue() == SnmpVarBind.endOfMibView) {
            return result;
        }
        if (result.getSnmpValue() == SnmpVarBind.endOfMibView) {
            return element;
        }
        SnmpValue val = result.getSnmpValue();
        int comp = element.getOid().compareTo(result.getOid());
        if (this.logger.finestOn()) {
            this.logger.finest("findVarBind", "Comparing OID element : " + element.getOid() + " with result : " + result.getOid());
            this.logger.finest("findVarBind", "Values element : " + element.getSnmpValue() + " result : " + result.getSnmpValue());
        }
        if (comp < 0) {
            return element;
        }
        if (comp == 0) {
            if (this.logger.finestOn()) {
                this.logger.finest("findVarBind", " oid overlapping. Oid : " + element.getOid() + "value :" + element.getSnmpValue());
                this.logger.finest("findVarBind", "Already present varBind : " + result);
            }
            SnmpOid oid = result.getOid();
            SnmpMibAgent deeperAgent = this.root.getAgentMib(oid);
            if (this.logger.finestOn()) {
                this.logger.finest("findVarBind", "Deeper agent : " + deeperAgent);
            }
            if (deeperAgent == this.agent) {
                if (this.logger.finestOn()) {
                    this.logger.finest("updateResult", "The current agent is the deeper one. Update the value with the current one");
                }
                return element;
            }
            if (this.logger.finestOn()) {
                this.logger.finest("updateResult", "Current is not the deeper, return the previous one.");
            }
            return result;
        }
        if (this.logger.finestOn()) {
            this.logger.finest("findVarBind", "The right varBind is the already present one");
        }
        return result;
    }

    protected void updateResult(SnmpVarBind[] result) {
        Enumeration e = this.varBind.elements();
        int max = result.length;
        for (int i = 0; i < this.size; ++i) {
            SnmpVarBind res;
            if (!e.hasMoreElements()) {
                return;
            }
            int pos = this.translation[i];
            if (pos >= max) {
                if (!this.logger.finestOn()) continue;
                this.logger.finest("updateResult", "Position `" + pos + "' is out of bound...");
                continue;
            }
            SnmpVarBind element = (SnmpVarBind)e.nextElement();
            if (element == null) continue;
            if (this.logger.finestOn()) {
                this.logger.finest("updateResult", "Non repeaters Current element : " + element + " from agent : " + this.agent);
            }
            if ((res = this.findVarBind(element, result[pos])) == null) continue;
            result[pos] = res;
        }
        int localR = this.size - this.nonRepeat;
        for (int i = 2; i <= this.maxRepeat; ++i) {
            for (int r = 0; r < localR; ++r) {
                SnmpVarBind res;
                int pos = (i - 1) * this.globalR + this.translation[this.nonRepeat + r];
                if (pos >= max) {
                    return;
                }
                if (!e.hasMoreElements()) {
                    return;
                }
                SnmpVarBind element = (SnmpVarBind)e.nextElement();
                if (element == null) continue;
                if (this.logger.finestOn()) {
                    this.logger.finest("updateResult", "Repeaters Current element : " + element + " from agent : " + this.agent);
                }
                if ((res = this.findVarBind(element, result[pos])) == null) continue;
                result[pos] = res;
            }
        }
    }

    protected String makeDebugTag() {
        return "SnmpSubBulkRequestHandler";
    }
}

