/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpInt;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpValue;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.agent.AcmChecker;
import com.sun.management.snmp.agent.SnmpEntryOid;
import com.sun.management.snmp.agent.SnmpMib;
import com.sun.management.snmp.agent.SnmpMibNode;
import com.sun.management.snmp.agent.SnmpMibSubRequest;
import com.sun.management.snmp.agent.SnmpRequestTree;
import com.sun.management.snmp.agent.SnmpTableEntryFactory;
import com.sun.management.snmp.agent.SnmpTableEntryNotification;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public abstract class SnmpMibTable
extends SnmpMibNode
implements NotificationBroadcaster,
Serializable {
    protected int nodeId = 1;
    protected SnmpMib theMib;
    protected boolean creationEnabled = false;
    protected SnmpTableEntryFactory factory = null;
    private int size = 0;
    private static final int Delta = 16;
    private int tablecount = 0;
    private int tablesize = 16;
    private SnmpOid[] tableoids = new SnmpOid[this.tablesize];
    private final Vector entries = new Vector();
    private final Vector entrynames = new Vector();
    private Hashtable handbackTable = new Hashtable();
    private Hashtable filterTable = new Hashtable();
    transient long sequenceNumber = 0L;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpMibTable");

    public SnmpMibTable(SnmpMib mib) {
        this.theMib = mib;
        this.setCreationEnabled(false);
    }

    public abstract void createNewEntry(SnmpMibSubRequest var1, SnmpOid var2, int var3) throws SnmpStatusException;

    public abstract boolean isRegistrationRequired();

    public boolean isCreationEnabled() {
        return this.creationEnabled;
    }

    public void setCreationEnabled(boolean remoteCreationFlag) {
        this.creationEnabled = remoteCreationFlag;
    }

    public boolean hasRowStatus() {
        return false;
    }

    public void get(SnmpMibSubRequest request, int depth) throws SnmpStatusException {
        boolean finest = logger.finestOn();
        boolean isnew = request.isNewEntry();
        SnmpMibSubRequest r = request;
        if (isnew) {
            if (finest) {
                logger.finest("get", "unknown instance: " + r.getEntryOid());
            }
            SnmpVarBind var = null;
            Enumeration e = r.getElements();
            while (e.hasMoreElements()) {
                var = (SnmpVarBind)e.nextElement();
                r.registerGetException(var, noSuchInstanceException);
            }
        }
        SnmpOid oid = r.getEntryOid();
        if (finest) {
            logger.finest("get", "getting instance: " + oid);
        }
        this.get(request, oid, depth + 1);
    }

    public void check(SnmpMibSubRequest request, int depth) throws SnmpStatusException {
        SnmpOid oid = request.getEntryOid();
        int action = this.getRowAction(request, oid, depth + 1);
        boolean dbg = logger.finestOn();
        if (dbg) {
            logger.finest("check", "Calling beginRowAction");
        }
        this.beginRowAction(request, oid, depth + 1, action);
        if (dbg) {
            logger.finest("check", "Calling check for " + request.getSize() + " varbinds.");
        }
        this.check(request, oid, depth + 1);
        if (dbg) {
            logger.finest("check", "check finished");
        }
    }

    public void set(SnmpMibSubRequest request, int depth) throws SnmpStatusException {
        boolean dbg = logger.finestOn();
        if (dbg) {
            logger.finest("set", "Entering set.");
        }
        SnmpOid oid = request.getEntryOid();
        int action = this.getRowAction(request, oid, depth + 1);
        if (dbg) {
            logger.finest("set", "Calling set for " + request.getSize() + "varbinds.");
        }
        this.set(request, oid, depth + 1);
        if (dbg) {
            logger.finest("set", "Calling endRowAction");
        }
        this.endRowAction(request, oid, depth + 1, action);
        if (dbg) {
            logger.finest("set", "RowAction finished");
        }
    }

    public void addEntry(SnmpOid rowOid, Object entry) throws SnmpStatusException {
        this.addEntry(rowOid, null, entry);
    }

    public synchronized void addEntry(SnmpOid oid, ObjectName name, Object entry) throws SnmpStatusException {
        if (this.isRegistrationRequired() && name == null) {
            throw new SnmpStatusException(3);
        }
        if (this.size == 0) {
            this.insertOid(0, oid);
            if (this.entries != null) {
                this.entries.addElement(entry);
            }
            if (this.entrynames != null) {
                this.entrynames.addElement(name);
            }
            ++this.size;
            if (this.factory != null) {
                try {
                    this.factory.addEntryCb(0, oid, name, entry, this);
                }
                catch (SnmpStatusException x) {
                    this.removeOid(0);
                    if (this.entries != null) {
                        this.entries.removeElementAt(0);
                    }
                    if (this.entrynames != null) {
                        this.entrynames.removeElementAt(0);
                    }
                    throw x;
                }
            }
            this.sendNotification(SnmpTableEntryNotification.SNMP_ENTRY_ADDED, new Date().getTime(), entry, name);
            return;
        }
        int pos = 0;
        pos = this.getInsertionPoint(oid, true);
        if (pos == this.size) {
            this.insertOid(this.tablecount, oid);
            if (this.entries != null) {
                this.entries.addElement(entry);
            }
            if (this.entrynames != null) {
                this.entrynames.addElement(name);
            }
            ++this.size;
        } else {
            try {
                this.insertOid(pos, oid);
                if (this.entries != null) {
                    this.entries.insertElementAt(entry, pos);
                }
                if (this.entrynames != null) {
                    this.entrynames.insertElementAt(name, pos);
                }
                ++this.size;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        if (this.factory != null) {
            try {
                this.factory.addEntryCb(pos, oid, name, entry, this);
            }
            catch (SnmpStatusException x) {
                this.removeOid(pos);
                if (this.entries != null) {
                    this.entries.removeElementAt(pos);
                }
                if (this.entrynames != null) {
                    this.entrynames.removeElementAt(pos);
                }
                throw x;
            }
        }
        this.sendNotification(SnmpTableEntryNotification.SNMP_ENTRY_ADDED, new Date().getTime(), entry, name);
    }

    public synchronized void removeEntry(SnmpOid rowOid, Object entry) throws SnmpStatusException {
        int pos = this.findObject(rowOid);
        if (pos == -1) {
            return;
        }
        this.removeEntry(pos, entry);
    }

    public void removeEntry(SnmpOid rowOid) throws SnmpStatusException {
        int pos = this.findObject(rowOid);
        if (pos == -1) {
            return;
        }
        this.removeEntry(pos, null);
    }

    public synchronized void removeEntry(int pos, Object entry) throws SnmpStatusException {
        if (pos == -1) {
            return;
        }
        if (pos >= this.size) {
            return;
        }
        Object obj = entry;
        if (this.entries != null && this.entries.size() > pos) {
            obj = this.entries.elementAt(pos);
            this.entries.removeElementAt(pos);
        }
        ObjectName name = null;
        if (this.entrynames != null && this.entrynames.size() > pos) {
            name = (ObjectName)this.entrynames.elementAt(pos);
            this.entrynames.removeElementAt(pos);
        }
        SnmpOid rowOid = this.tableoids[pos];
        this.removeOid(pos);
        --this.size;
        if (obj == null) {
            obj = entry;
        }
        if (this.factory != null) {
            this.factory.removeEntryCb(pos, rowOid, name, obj, this);
        }
        this.sendNotification(SnmpTableEntryNotification.SNMP_ENTRY_REMOVED, new Date().getTime(), obj, name);
    }

    public synchronized Object getEntry(SnmpOid rowOid) throws SnmpStatusException {
        int pos = this.findObject(rowOid);
        if (pos == -1) {
            throw new SnmpStatusException(224);
        }
        return this.entries.elementAt(pos);
    }

    public synchronized ObjectName getEntryName(SnmpOid rowOid) throws SnmpStatusException {
        int pos = this.findObject(rowOid);
        if (this.entrynames == null) {
            return null;
        }
        if (pos == -1 || pos >= this.entrynames.size()) {
            throw new SnmpStatusException(224);
        }
        return (ObjectName)this.entrynames.elementAt(pos);
    }

    public Object[] getBasicEntries() {
        Object[] array = new Object[this.size];
        this.entries.copyInto(array);
        return array;
    }

    public int getSize() {
        return this.size;
    }

    public synchronized void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        Vector<Object> handbackList = (Vector<Object>)this.handbackTable.get(listener);
        Vector<NotificationFilter> filterList = (Vector<NotificationFilter>)this.filterTable.get(listener);
        if (handbackList == null) {
            handbackList = new Vector<Object>();
            filterList = new Vector<NotificationFilter>();
            this.handbackTable.put(listener, handbackList);
            this.filterTable.put(listener, filterList);
        }
        handbackList.addElement(handback);
        filterList.addElement(filter);
    }

    public synchronized void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        Vector handbackList = (Vector)this.handbackTable.get(listener);
        Vector filterList = (Vector)this.filterTable.get(listener);
        if (handbackList == null) {
            throw new ListenerNotFoundException("listener");
        }
        this.handbackTable.remove(listener);
        this.filterTable.remove(listener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{SnmpTableEntryNotification.SNMP_ENTRY_ADDED, SnmpTableEntryNotification.SNMP_ENTRY_REMOVED};
        MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "com.sun.management.snmp.agent.SnmpTableEntryNotification", "Notifications sent by the SnmpMibTable")};
        return notifsInfo;
    }

    public void registerEntryFactory(SnmpTableEntryFactory factory) {
        this.factory = factory;
    }

    protected boolean isRowStatus(SnmpOid rowOid, long var, Object userData) {
        return false;
    }

    protected int getRowAction(SnmpMibSubRequest request, SnmpOid rowOid, int depth) throws SnmpStatusException {
        boolean isnew = request.isNewEntry();
        SnmpVarBind vb = request.getRowStatusVarBind();
        if (vb == null) {
            if (isnew && !this.hasRowStatus()) {
                return 4;
            }
            return 0;
        }
        try {
            return this.mapRowStatus(rowOid, vb, request.getUserData());
        }
        catch (SnmpStatusException x) {
            SnmpMibTable.checkRowStatusFail(request, x.getStatus());
            return 0;
        }
    }

    protected int mapRowStatus(SnmpOid rowOid, SnmpVarBind vbstatus, Object userData) throws SnmpStatusException {
        SnmpValue rsvalue = vbstatus.getSnmpValue();
        if (rsvalue instanceof SnmpInt) {
            return ((SnmpInt)rsvalue).intValue();
        }
        throw new SnmpStatusException(12);
    }

    protected SnmpValue setRowStatus(SnmpOid rowOid, int newStatus, Object userData) throws SnmpStatusException {
        return null;
    }

    protected boolean isRowReady(SnmpOid rowOid, Object userData) throws SnmpStatusException {
        return true;
    }

    protected void checkRowStatusChange(SnmpMibSubRequest request, SnmpOid rowOid, int depth, int newStatus) throws SnmpStatusException {
    }

    protected void checkRemoveTableRow(SnmpMibSubRequest request, SnmpOid rowOid, int depth) throws SnmpStatusException {
    }

    protected void removeTableRow(SnmpMibSubRequest request, SnmpOid rowOid, int depth) throws SnmpStatusException {
        this.removeEntry(rowOid);
    }

    protected synchronized void beginRowAction(SnmpMibSubRequest request, SnmpOid rowOid, int depth, int rowAction) throws SnmpStatusException {
        boolean isnew = request.isNewEntry();
        SnmpOid oid = rowOid;
        int action = rowAction;
        switch (action) {
            case 0: {
                if (!isnew) break;
                if (logger.finestOn()) {
                    logger.finest("beginRowAction", "Failed to create row[" + rowOid + "] : RowStatus = unspecified");
                }
                SnmpMibTable.checkRowStatusFail(request, 6);
                break;
            }
            case 4: 
            case 5: {
                if (isnew) {
                    if (this.isCreationEnabled()) {
                        if (logger.finestOn()) {
                            logger.finest("beginRowAction", "Creating row[" + rowOid + "] : RowStatus = createAndGo | createAndWait");
                        }
                        this.createNewEntry(request, oid, depth);
                        break;
                    }
                    if (logger.finestOn()) {
                        logger.finest("beginRowAction", "Can't create row[" + rowOid + "] : RowStatus = " + "createAndGo | createAndWait" + " but creation is disabled");
                    }
                    SnmpMibTable.checkRowStatusFail(request, 6);
                    break;
                }
                if (logger.finestOn()) {
                    logger.finest("beginRowAction", "Can't create row[" + rowOid + "] : RowStatus = createAndGo | createAndWait" + " but row already exists");
                }
                SnmpMibTable.checkRowStatusFail(request, 12);
                break;
            }
            case 6: {
                if (isnew) {
                    if (logger.finestOn()) {
                        logger.finest("beginRowAction", "Warning: can't destroy row[" + rowOid + "] : RowStatus = destroy" + " but row does not exist");
                    }
                } else if (!this.isCreationEnabled()) {
                    if (logger.finestOn()) {
                        logger.finest("beginRowAction", "Can't destroy row[" + rowOid + "] : RowStatus = destroy " + " but creation is disabled");
                    }
                    SnmpMibTable.checkRowStatusFail(request, 6);
                }
                this.checkRemoveTableRow(request, rowOid, depth);
                break;
            }
            case 1: 
            case 2: {
                if (isnew) {
                    if (logger.finestOn()) {
                        logger.finest("beginRowAction", "Can't switch state of row[" + rowOid + "] : specified RowStatus = " + "active | notInService" + " but row does not exist");
                    }
                    SnmpMibTable.checkRowStatusFail(request, 12);
                }
                this.checkRowStatusChange(request, rowOid, depth, action);
                break;
            }
            default: {
                if (logger.finestOn()) {
                    logger.finest("beginRowAction", "Invalid RowStatus value for row[" + rowOid + "] : specified RowStatus = " + action);
                }
                SnmpMibTable.checkRowStatusFail(request, 12);
            }
        }
    }

    protected void endRowAction(SnmpMibSubRequest request, SnmpOid rowOid, int depth, int rowAction) throws SnmpStatusException {
        SnmpVarBind vb;
        boolean isnew = request.isNewEntry();
        SnmpOid oid = rowOid;
        int action = rowAction;
        Object data = request.getUserData();
        SnmpValue value = null;
        switch (action) {
            case 0: {
                break;
            }
            case 4: {
                if (logger.finestOn()) {
                    logger.finest("endRowAction", "Setting RowStatus to `active' for row[" + rowOid + "] : requested RowStatus = " + "createAndGo");
                }
                value = this.setRowStatus(oid, 1, data);
                break;
            }
            case 5: {
                if (this.isRowReady(oid, data)) {
                    if (logger.finestOn()) {
                        logger.finest("endRowAction", "Setting RowStatus to `notInService' for row[" + rowOid + "] : requested RowStatus = " + "createAndWait");
                    }
                    value = this.setRowStatus(oid, 2, data);
                    break;
                }
                if (logger.finestOn()) {
                    logger.finest("endRowAction", "Setting RowStatus to `notReady' for row[" + rowOid + "] : requested RowStatus = " + "createAndWait");
                }
                value = this.setRowStatus(oid, 3, data);
                break;
            }
            case 6: {
                if (isnew) {
                    if (logger.finestOn()) {
                        logger.finest("endRowAction", "Warning:  requested RowStatus = destroy,but row[" + rowOid + "] does not exist.");
                    }
                } else if (logger.finestOn()) {
                    logger.finest("endRowAction", "destroying row[" + rowOid + "] : requested RowStatus = destroy");
                }
                this.removeTableRow(request, oid, depth);
                break;
            }
            case 1: {
                if (logger.finestOn()) {
                    logger.finest("endRowAction", "Setting RowStatus to `active' for row[" + rowOid + "] : requested RowStatus = " + "active");
                }
                value = this.setRowStatus(oid, 1, data);
                break;
            }
            case 2: {
                if (logger.finestOn()) {
                    logger.finest("endRowAction", "Setting RowStatus to `notInService' for row[" + rowOid + "] : requested RowStatus = " + "notInService");
                }
                value = this.setRowStatus(oid, 2, data);
                break;
            }
            default: {
                if (logger.finestOn()) {
                    logger.finest("endRowAction", "Invalid RowStatus value for row[" + rowOid + "] : specified RowStatus = " + action);
                }
                SnmpMibTable.setRowStatusFail(request, 12);
            }
        }
        if (value != null && (vb = request.getRowStatusVarBind()) != null) {
            vb.setSnmpValue(value);
        }
    }

    protected long getNextVarEntryId(SnmpOid rowOid, long var, Object userData, int pduVersion) throws SnmpStatusException {
        long varid = var;
        while (this.skipEntryVariable(rowOid, varid = this.getNextVarEntryId(rowOid, varid, userData), userData, pduVersion)) {
        }
        return varid;
    }

    protected boolean skipEntryVariable(SnmpOid rowOid, long var, Object userData, int pduVersion) {
        return false;
    }

    protected SnmpOid getNextOid(SnmpOid oid, Object userData) throws SnmpStatusException {
        if (this.size == 0) {
            throw noSuchInstanceException;
        }
        SnmpOid last = this.tableoids[this.tablecount - 1];
        SnmpOid resOid = oid;
        if (last.equals(resOid)) {
            throw noSuchInstanceException;
        }
        int newPos = this.getInsertionPoint(resOid, false);
        if (newPos > -1 && newPos < this.size) {
            try {
                last = this.tableoids[newPos];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw noSuchInstanceException;
            }
        } else {
            throw noSuchInstanceException;
        }
        return last;
    }

    protected SnmpOid getNextOid(Object userData) throws SnmpStatusException {
        if (this.size == 0) {
            throw noSuchInstanceException;
        }
        return this.tableoids[0];
    }

    protected abstract long getNextVarEntryId(SnmpOid var1, long var2, Object var4) throws SnmpStatusException;

    protected abstract void validateVarEntryId(SnmpOid var1, long var2, Object var4) throws SnmpStatusException;

    protected abstract boolean isReadableEntryId(SnmpOid var1, long var2, Object var4) throws SnmpStatusException;

    protected abstract void get(SnmpMibSubRequest var1, SnmpOid var2, int var3) throws SnmpStatusException;

    protected abstract void check(SnmpMibSubRequest var1, SnmpOid var2, int var3) throws SnmpStatusException;

    protected abstract void set(SnmpMibSubRequest var1, SnmpOid var2, int var3) throws SnmpStatusException;

    SnmpOid getNextOid(long[] oid, int pos, Object userData) throws SnmpStatusException {
        SnmpEntryOid resOid = new SnmpEntryOid(oid, pos);
        return this.getNextOid(resOid, userData);
    }

    static final void checkRowStatusFail(SnmpMibSubRequest request, int errorStatus) throws SnmpStatusException {
        SnmpVarBind statusvb = request.getRowStatusVarBind();
        SnmpStatusException x = new SnmpStatusException(errorStatus);
        request.registerCheckException(statusvb, x);
    }

    static final void setRowStatusFail(SnmpMibSubRequest request, int errorStatus) throws SnmpStatusException {
        SnmpVarBind statusvb = request.getRowStatusVarBind();
        SnmpStatusException x = new SnmpStatusException(errorStatus);
        request.registerSetException(statusvb, x);
    }

    final synchronized void findHandlingNode(SnmpVarBind varbind, long[] oid, int depth, SnmpRequestTree handlers) throws SnmpStatusException {
        int length = oid.length;
        if (handlers == null) {
            throw new SnmpStatusException(5);
        }
        if (depth >= length) {
            throw new SnmpStatusException(6);
        }
        if (oid[depth] != (long)this.nodeId) {
            throw new SnmpStatusException(6);
        }
        if (depth + 2 >= length) {
            throw new SnmpStatusException(6);
        }
        SnmpEntryOid entryoid = new SnmpEntryOid(oid, depth + 2);
        Object data = handlers.getUserData();
        boolean hasEntry = this.contains(entryoid, data);
        if (!hasEntry) {
            if (!handlers.isCreationAllowed()) {
                throw noSuchInstanceException;
            }
            if (!this.isCreationEnabled()) {
                throw new SnmpStatusException(6);
            }
        }
        long var = oid[depth + 1];
        if (hasEntry) {
            this.validateVarEntryId(entryoid, var, data);
        }
        if (handlers.isSetRequest() && this.isRowStatus(entryoid, var, data)) {
            handlers.add(this, depth, entryoid, varbind, !hasEntry, varbind);
        } else {
            handlers.add(this, depth, entryoid, varbind, !hasEntry);
        }
    }

    final synchronized long[] findNextHandlingNode(SnmpVarBind varbind, long[] oid, int pos, int depth, SnmpRequestTree handlers, AcmChecker checker) throws SnmpStatusException {
        int length = oid.length;
        if (handlers == null) {
            throw noSuchObjectException;
        }
        Object data = handlers.getUserData();
        int pduVersion = handlers.getRequestPduVersion();
        long var = -1L;
        if (pos >= length) {
            oid = new long[]{this.nodeId};
            pos = 0;
            length = 1;
        } else {
            if (oid[pos] > (long)this.nodeId) {
                throw noSuchObjectException;
            }
            if (oid[pos] < (long)this.nodeId) {
                oid = new long[]{this.nodeId};
                pos = 0;
                length = 0;
            } else if (pos + 1 < length) {
                var = oid[pos + 1];
            }
        }
        SnmpOid entryoid = null;
        if (pos == length - 1) {
            entryoid = this.getNextOid(data);
            var = this.getNextVarEntryId(entryoid, var, data, pduVersion);
        } else if (pos == length - 2) {
            entryoid = this.getNextOid(data);
            if (this.skipEntryVariable(entryoid, var, data, pduVersion)) {
                var = this.getNextVarEntryId(entryoid, var, data, pduVersion);
            }
        } else {
            try {
                entryoid = this.getNextOid(oid, pos + 2, data);
                if (this.skipEntryVariable(entryoid, var, data, pduVersion)) {
                    throw noSuchObjectException;
                }
            }
            catch (SnmpStatusException se) {
                entryoid = this.getNextOid(data);
                var = this.getNextVarEntryId(entryoid, var, data, pduVersion);
            }
        }
        return this.findNextAccessibleOid(entryoid, varbind, oid, depth, handlers, checker, data, var);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] findNextAccessibleOid(SnmpOid entryoid, SnmpVarBind varbind, long[] oid, int depth, SnmpRequestTree handlers, AcmChecker checker, Object data, long var) throws SnmpStatusException {
        int pduVersion = handlers.getRequestPduVersion();
        do {
            Object var16_16;
            if (entryoid == null || var == -1L) {
                throw noSuchObjectException;
            }
            if (!this.isReadableEntryId(entryoid, var, data)) {
                throw noSuchObjectException;
            }
            long[] etable = entryoid.longValue(false);
            int elength = etable.length;
            long[] result = new long[depth + 2 + elength];
            result[0] = -1L;
            System.arraycopy(etable, 0, result, depth + 2, elength);
            result[depth] = this.nodeId;
            result[depth + 1] = var;
            checker.add(depth, result, depth, elength + 2);
            try {
                checker.checkCurrentOid();
                handlers.add(this, depth, entryoid, varbind, false);
                long[] lArray = result;
                {
                    var16_16 = null;
                    checker.remove(depth, elength + 2);
                }
                return lArray;
            }
            catch (SnmpStatusException e) {
                try {
                    try {
                        entryoid = this.getNextOid(entryoid, data);
                        var16_16 = null;
                        checker.remove(depth, elength + 2);
                    }
                    catch (Throwable throwable) {
                        var16_16 = null;
                        checker.remove(depth, elength + 2);
                        throw throwable;
                    }
                }
                catch (SnmpStatusException e2) {
                    entryoid = this.getNextOid(data);
                    var = this.getNextVarEntryId(entryoid, var, data, pduVersion);
                }
            }
        } while (entryoid != null && var != -1L);
        throw noSuchObjectException;
    }

    final void validateOid(long[] oid, int pos) throws SnmpStatusException {
        int length = oid.length;
        if (pos + 2 >= length) {
            throw noSuchInstanceException;
        }
        if (oid[pos] != (long)this.nodeId) {
            throw noSuchObjectException;
        }
    }

    private synchronized void sendNotification(Notification notification) {
        Enumeration k = this.handbackTable.keys();
        while (k.hasMoreElements()) {
            NotificationListener listener = (NotificationListener)k.nextElement();
            Vector handbackList = (Vector)this.handbackTable.get(listener);
            Vector filterList = (Vector)this.filterTable.get(listener);
            Enumeration f = filterList.elements();
            Enumeration h = handbackList.elements();
            while (h.hasMoreElements()) {
                Object handback = h.nextElement();
                NotificationFilter filter = (NotificationFilter)f.nextElement();
                if (filter != null && (filter == null || !filter.isNotificationEnabled(notification))) continue;
                listener.handleNotification(notification, handback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotification(String type, long timeStamp, Object entry, ObjectName name) {
        SnmpMibTable snmpMibTable = this;
        synchronized (snmpMibTable) {
            ++this.sequenceNumber;
        }
        SnmpTableEntryNotification notif = new SnmpTableEntryNotification(type, this, this.sequenceNumber, timeStamp, entry, name);
        this.sendNotification(notif);
    }

    protected boolean contains(SnmpOid oid, Object userData) {
        return this.findObject(oid) > -1;
    }

    private final int findObject(SnmpOid oid) {
        int low = 0;
        int max = this.size - 1;
        int curr = low + (max - low) / 2;
        while (low <= max) {
            SnmpOid pos = this.tableoids[curr];
            int comp = oid.compareTo(pos);
            if (comp == 0) {
                return curr;
            }
            if (oid.equals(pos)) {
                return curr;
            }
            if (comp > 0) {
                low = curr + 1;
            } else {
                max = curr - 1;
            }
            curr = low + (max - low) / 2;
        }
        return -1;
    }

    private final int getInsertionPoint(SnmpOid oid) throws SnmpStatusException {
        return this.getInsertionPoint(oid, true);
    }

    private final int getInsertionPoint(SnmpOid oid, boolean fail) throws SnmpStatusException {
        int failStatus = 17;
        int low = 0;
        int max = this.size - 1;
        int curr = low + (max - low) / 2;
        while (low <= max) {
            SnmpOid pos = this.tableoids[curr];
            int comp = oid.compareTo(pos);
            if (comp == 0) {
                if (fail) {
                    throw new SnmpStatusException(17, curr);
                }
                return curr + 1;
            }
            if (comp > 0) {
                low = curr + 1;
            } else {
                max = curr - 1;
            }
            curr = low + (max - low) / 2;
        }
        return curr;
    }

    private final void removeOid(int pos) {
        if (pos >= this.tablecount) {
            return;
        }
        if (pos < 0) {
            return;
        }
        int l1 = --this.tablecount - pos;
        this.tableoids[pos] = null;
        if (l1 > 0) {
            System.arraycopy(this.tableoids, pos + 1, this.tableoids, pos, l1);
        }
        this.tableoids[this.tablecount] = null;
    }

    private final void insertOid(int pos, SnmpOid oid) {
        if (pos >= this.tablesize || this.tablecount == this.tablesize) {
            SnmpOid[] olde = this.tableoids;
            this.tablesize += 16;
            this.tableoids = new SnmpOid[this.tablesize];
            if (pos > this.tablecount) {
                pos = this.tablecount;
            }
            if (pos < 0) {
                pos = 0;
            }
            int l1 = pos;
            int l2 = this.tablecount - pos;
            if (l1 > 0) {
                System.arraycopy(olde, 0, this.tableoids, 0, l1);
            }
            if (l2 > 0) {
                System.arraycopy(olde, l1, this.tableoids, l1 + 1, l2);
            }
        } else if (pos < this.tablecount) {
            System.arraycopy(this.tableoids, pos, this.tableoids, pos + 1, this.tablecount - pos);
        }
        this.tableoids[pos] = oid;
        ++this.tablecount;
    }
}

