/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.SnmpV3AdaptorServer;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.agent.SnmpTarget;
import com.sun.management.snmp.agent.SnmpTrap;
import com.sun.management.snmp.agent.SnmpTrapForwarderMBean;
import com.sun.management.snmp.agent.SnmpTrapReceiver;
import com.sun.management.snmp.agent.SnmpV1V2Target;
import com.sun.management.snmp.agent.SnmpV3Target;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;

public class SnmpTrapForwarder
extends SnmpTrapReceiver
implements SnmpTrapForwarderMBean {
    private SnmpV3AdaptorServer server = null;
    private boolean forwardV1 = false;
    private boolean forwardV2 = false;
    private boolean forwardV3 = false;
    private Vector v1targets = null;
    private Vector v2targets = null;
    private Vector v3targets = null;
    private boolean originator = true;
    private InetAddress addr = null;
    private String communityString = null;
    private String principal = null;
    private int msgFlags = 0;
    private String contextName = null;
    private boolean usm = false;
    private boolean useAcl = true;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.proxy", "SnmpTrapForwarder");
    String dbgTag = "SnmpTrapForwarder";

    public SnmpTrapForwarder(SnmpV3AdaptorServer server, int port) {
        super(server.getEngine(), port, null);
        this.server = server;
        this.receiveAsGeneric(true);
    }

    public SnmpTrapForwarder(SnmpV3AdaptorServer server, int port, InetAddress address) {
        super(server.getEngine(), port, address);
        this.server = server;
        this.receiveAsGeneric(true);
    }

    public void setCommunityString(String cs) {
        this.communityString = cs;
    }

    public void setV3Parameters(String principal, String contextName, int securityLevel) {
        this.usm = true;
        this.principal = principal;
        this.contextName = contextName;
        this.msgFlags = securityLevel;
    }

    public void setInetAddressAclUsed(boolean use) {
        this.useAcl = use;
    }

    public boolean isInetAddressAclUsed() {
        return this.useAcl;
    }

    public synchronized boolean isV1Activated() {
        return this.forwardV1;
    }

    public synchronized boolean isV2Activated() {
        return this.forwardV2;
    }

    public synchronized boolean isV3Activated() {
        return this.forwardV3;
    }

    public synchronized void snmpV1forwarding(boolean status) {
        this.forwardV1 = status;
    }

    public synchronized void snmpV2forwarding(boolean status) {
        this.forwardV2 = status;
    }

    public synchronized void snmpV3forwarding(boolean status) {
        this.forwardV3 = status;
    }

    public boolean removeV1Target(String address) {
        return this.removeV1Target(address, -1);
    }

    public boolean removeV2Target(String address) {
        return this.removeV2Target(address, -1);
    }

    public boolean removeV3Target(String address) {
        return this.removeV3Target(address, -1);
    }

    public boolean removeV1Target(String address, int port) {
        SnmpTarget t = new SnmpTarget(address, port);
        if (this.v1targets != null) {
            return this.v1targets.remove(t);
        }
        return false;
    }

    public boolean removeV2Target(String address, int port) {
        SnmpTarget t = new SnmpTarget(address, port);
        if (this.v2targets != null) {
            return this.v2targets.remove(t);
        }
        return false;
    }

    public boolean removeV3Target(String address, int port) {
        SnmpTarget t = new SnmpTarget(address, port);
        if (this.v3targets != null) {
            return this.v3targets.remove(t);
        }
        return false;
    }

    public synchronized void addV1Target(String address, int port, String communityString) {
        if (address == null) {
            return;
        }
        if (this.v1targets == null) {
            this.v1targets = new Vector();
        }
        this.snmpV1forwarding(true);
        SnmpV1V2Target t = new SnmpV1V2Target(address, port, communityString);
        this.v1targets.add(t);
    }

    public synchronized void addV2Target(String address, int port, String communityString) {
        if (address == null) {
            return;
        }
        if (this.v2targets == null) {
            this.v2targets = new Vector();
        }
        this.snmpV2forwarding(true);
        SnmpV1V2Target t = new SnmpV1V2Target(address, port, communityString);
        this.v2targets.add(t);
    }

    public synchronized void addV3Target(String address, int port, String principal, String contextName, int securityLevel) {
        if (address == null) {
            return;
        }
        if (this.v3targets == null) {
            this.v3targets = new Vector();
        }
        this.snmpV3forwarding(true);
        SnmpV3Target t = new SnmpV3Target(address, port, principal, contextName, securityLevel);
        this.v3targets.add(t);
    }

    public synchronized void addV1Target(String address, String communityString) {
        this.addV1Target(address, -1, communityString);
    }

    public synchronized void addV2Target(String address, String communityString) {
        this.addV2Target(address, -1, communityString);
    }

    public void forwardAsNotificationOriginator() {
        this.originator = true;
    }

    public void forwardAsProxy() {
        this.originator = false;
    }

    public boolean isOriginatorWay() {
        return this.originator;
    }

    public boolean isProxyWay() {
        return !this.isOriginatorWay();
    }

    public void setSourceIpAddress(InetAddress addr) {
        this.addr = addr;
    }

    public synchronized void addV3Target(String address, String principal, String contextName, int securityLevel) {
        this.addV3Target(address, -1, principal, contextName, securityLevel);
    }

    protected synchronized void receivedTrap(SnmpTrap trap) {
        block36: {
            try {
                SnmpTarget t;
                Enumeration e;
                if (this.isOriginatorWay()) {
                    trap.setPduSourceAddress(this.addr);
                    trap.sendAsNotificationOriginator();
                } else {
                    trap.sendAsProxy();
                }
                if (this.isV1Activated()) {
                    block35: {
                        if (this.isInetAddressAclUsed()) {
                            if (logger.finestOn()) {
                                logger.finest("receivedTrap", " Sending SNMP V1 trap using InetAddressAcl conf");
                            }
                            try {
                                trap.sendV1(this.server);
                            }
                            catch (Exception e2) {
                                if (!logger.finestOn()) break block35;
                                logger.finest("receivedTrap", "Fail sending trap using acl");
                            }
                        }
                    }
                    trap.setDestinationAddress(null);
                    if (this.v1targets != null) {
                        e = this.v1targets.elements();
                        while (e.hasMoreElements()) {
                            t = null;
                            try {
                                t = (SnmpV1V2Target)e.nextElement();
                                trap.setCommunityString(t.community);
                                trap.setDestinationAddress(t.address);
                                if (logger.finestOn()) {
                                    logger.finest("receivedTrap", "Sending SNMP V1 trap to : " + t.address + " on port : " + t.port);
                                }
                                if (t.port != -1) {
                                    trap.setDestinationPort(t.port);
                                }
                                trap.sendV1(this.server);
                            }
                            catch (Exception ex) {
                                if (!logger.finestOn()) continue;
                                logger.finest("receivedTrap", "Fail sending trap to target : " + t.address + "/" + t.port);
                            }
                        }
                    }
                }
                if (this.isV2Activated()) {
                    if (this.isInetAddressAclUsed()) {
                        if (logger.finestOn()) {
                            logger.finest("receivedTrap", "Sending SNMP V2 trap using InetAddressAcl conf");
                        }
                        trap.sendV2(this.server);
                    }
                    trap.setDestinationAddress(null);
                    if (this.v2targets != null) {
                        e = this.v2targets.elements();
                        while (e.hasMoreElements()) {
                            t = null;
                            try {
                                t = (SnmpV1V2Target)e.nextElement();
                                trap.setCommunityString(t.community);
                                trap.setDestinationAddress(t.address);
                                if (logger.finestOn()) {
                                    logger.finest("receivedTrap", "Sending SNMP V2 trap to : " + t.address + " on port : " + t.port);
                                }
                                if (t.port != -1) {
                                    trap.setDestinationPort(t.port);
                                }
                                trap.sendV2(this.server);
                            }
                            catch (Exception ex) {
                                if (!logger.finestOn()) continue;
                                logger.finest("receivedTrap", "Fail sending trap to target : " + t.address + "/" + t.port);
                            }
                        }
                    }
                }
                if (this.isV3Activated()) {
                    if (this.isInetAddressAclUsed() && this.principal != null) {
                        if (logger.finestOn()) {
                            logger.finest("receivedTrap", "Sending SNMP V3 trap using InetAddressAcl conf");
                        }
                        trap.sendV3Usm(this.server, this.principal, (byte)this.msgFlags, this.contextName);
                    }
                    trap.setDestinationAddress(null);
                    if (this.v3targets != null) {
                        e = this.v3targets.elements();
                        while (e.hasMoreElements()) {
                            t = null;
                            try {
                                t = (SnmpV3Target)e.nextElement();
                                trap.setDestinationAddress(((SnmpV3Target)t).address);
                                if (logger.finestOn()) {
                                    logger.finest("receivedTrap", "Sending SNMP V3 trap to : " + ((SnmpV3Target)t).address + " on port : " + ((SnmpV3Target)t).port);
                                }
                                if (((SnmpV3Target)t).port != -1) {
                                    trap.setDestinationPort(((SnmpV3Target)t).port);
                                }
                                trap.sendV3Usm(this.server, ((SnmpV3Target)t).principal, (byte)((SnmpV3Target)t).msgFlags, ((SnmpV3Target)t).contextName);
                            }
                            catch (Exception ex) {
                                if (!logger.finestOn()) continue;
                                logger.finest("receivedTrap", "Fail sending trap to target : " + ((SnmpV3Target)t).address + "/" + ((SnmpV3Target)t).port);
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                if (logger.finerOn()) {
                    logger.finer("receivedTrap", e.toString());
                }
            }
            catch (SnmpStatusException e) {
                if (!logger.finerOn()) break block36;
                logger.finer("receivedTrap", e.toString());
            }
        }
    }
}

