/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.manager.MultiplexRequest;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpQManager;
import com.sun.management.snmp.manager.SnmpRequest;
import com.sun.management.snmp.manager.SnmpSession;
import java.util.Enumeration;
import java.util.Vector;

final class SnmpSendServer
extends Thread
implements Runnable {
    SnmpQManager snmpq = null;
    String dbgTag = "SnmpSendServer";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpSendServer");
    private boolean tryMultiplexing = false;
    private int intervalRange = 5000;
    private Vector readyPool;
    private Vector assortedReqList = new Vector();
    boolean isBeingDestroyed = false;

    public SnmpSendServer(ThreadGroup grp, SnmpQManager q) {
        super(grp, "SnmpSendServer");
        this.snmpq = q;
        this.start();
    }

    public final synchronized void activateMultiplex(boolean flag) {
        this.tryMultiplexing = flag;
    }

    public final synchronized boolean multiplex() {
        return this.tryMultiplexing;
    }

    public synchronized void stopSendServer() {
        if (this.isAlive()) {
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void run() {
        Thread.currentThread().setPriority(5);
        if (logger.finerOn()) {
            logger.finer("run", "Thread Started");
        }
        while (true) {
            try {
                do {
                    this.prepareAndSendRequest();
                } while (!this.isBeingDestroyed);
            }
            catch (Exception anye) {
                if (!logger.finestOn()) continue;
                logger.finest("run", "Exception in send server");
                logger.finest("run", anye);
                continue;
            }
            catch (ThreadDeath td) {
                if (logger.finestOn()) {
                    logger.finest("run", "Exiting... Fatal error");
                }
                throw td;
            }
            catch (OutOfMemoryError ome) {
                if (!logger.finestOn()) continue;
                logger.finest("run", "Out of memory");
                continue;
            }
            catch (Error err) {
                if (logger.finestOn()) {
                    logger.finest("run", err);
                }
                throw err;
            }
            break;
        }
    }

    void fireRequest(SnmpRequest req) {
        if (req != null && req.inProgress()) {
            if (logger.finerOn()) {
                logger.finer("fireRequest", "Firing request directly. -> " + req.getRequestId());
            }
            req.action();
        }
    }

    void fireRequestList(Vector reqList) {
        while (!reqList.isEmpty()) {
            SnmpRequest req = (SnmpRequest)reqList.lastElement();
            if (req != null && req.inProgress()) {
                this.fireRequest(req);
            }
            reqList.removeElementAt(reqList.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAndSendRequest() {
        if (this.readyPool == null || this.readyPool.isEmpty()) {
            if (logger.finerOn()) {
                logger.finer("prepareAndSendRequest", "Blocking for requests");
            }
            this.readyPool = this.snmpq.getAllOutstandingRequest(this.intervalRange);
            if (this.isBeingDestroyed) {
                return;
            }
        } else if (logger.finestOn()) {
            logger.finest("prepareAndSendRequest", "Requests from a previous block left unprocessed. Will try again");
        }
        if (logger.finerOn()) {
            logger.finer("prepareAndSendRequest", "List of requests to send : " + this.reqListToString(this.readyPool));
        }
        SnmpSendServer snmpSendServer = this;
        synchronized (snmpSendServer) {
            if (!this.multiplex() || this.readyPool.size() < 2) {
                this.fireRequestList(this.readyPool);
                return;
            }
            while (!this.readyPool.isEmpty()) {
                SnmpRequest req = (SnmpRequest)this.readyPool.lastElement();
                if (req != null && req.inProgress()) {
                    if (req.allowMultiplex()) {
                        this.addToAssortedList(req);
                    } else {
                        this.fireRequest(req);
                    }
                }
                this.readyPool.removeElementAt(this.readyPool.size() - 1);
            }
            this.fireAssortedRequests();
            this.readyPool.removeAllElements();
        }
    }

    void fireAssortedRequests() {
        if (logger.finerOn()) {
            logger.finer("fireAssortedRequests", "Firing Assorted requests");
        }
        while (!this.assortedReqList.isEmpty()) {
            SimilarRequestList slist = (SimilarRequestList)this.assortedReqList.lastElement();
            slist.action();
            this.assortedReqList.removeElementAt(this.assortedReqList.size() - 1);
        }
    }

    void addToAssortedList(SnmpRequest req) {
        if (this.assortedReqList.isEmpty()) {
            SimilarRequestList simreq = new SimilarRequestList(req);
            this.assortedReqList.addElement(simreq);
            return;
        }
        Enumeration e = this.assortedReqList.elements();
        while (e.hasMoreElements()) {
            SimilarRequestList simreql = (SimilarRequestList)e.nextElement();
            if (!simreql.belongsHere(req)) continue;
            simreql.addElement(req);
            return;
        }
        SimilarRequestList simreq = new SimilarRequestList(req);
        this.assortedReqList.addElement(simreq);
    }

    final String reqListToString(Vector vec) {
        StringBuffer s = new StringBuffer(vec.size() * 100);
        Enumeration dbge = vec.elements();
        s.append("RequestId/Options -> ");
        while (dbge.hasMoreElements()) {
            SnmpRequest reqc = (SnmpRequest)dbge.nextElement();
            s.append(reqc.getRequestId() + "/" + reqc.getOptions() + " ");
        }
        String str = s.toString();
        s = null;
        return str;
    }

    private void takeAnap(long time) {
        try {
            this.wait(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    final class SimilarRequestList
    extends Vector {
        private static final long serialVersionUID = 7868956577078005552L;
        SnmpPeer _peer;
        SnmpSession _session;
        int _cmd;
        MultiplexRequest _currentMuxReq;

        SimilarRequestList(SnmpRequest inreq) {
            this._peer = inreq.getPeer();
            this._session = inreq.getSnmpSession();
            this._cmd = inreq.getCommand();
            this.addElement(inreq);
        }

        public SnmpPeer getPeer() {
            return this._peer;
        }

        public SnmpSession getSession() {
            return this._session;
        }

        public int getCommand() {
            return this._cmd;
        }

        public boolean belongsHere(SnmpRequest inreq) {
            if (this._cmd != inreq.getCommand()) {
                return false;
            }
            return this._peer.equals(inreq.getPeer()) && this._session.isEquivalent(inreq.getSnmpSession());
        }

        public String describe() {
            StringBuffer sb = new StringBuffer(100);
            sb.append(this._peer.toString() + " -> ");
            int max = this.size();
            for (int i = 0; i < max; ++i) {
                sb.append(((SnmpRequest)this.elementData[i]).getRequestId() + " ");
            }
            return sb.toString();
        }

        void fireRequestDirect(SnmpRequest req) {
            if (req != null && req.inProgress()) {
                if (logger.finerOn()) {
                    logger.finer("fireRequestDirect", "Firing request directly. -> " + req.getRequestId());
                }
                req.action();
            }
        }

        public void action() {
            if (logger.finerOn()) {
                logger.finer("action", "List of requests directed to peer : " + this.describe());
            }
            while (!this.isEmpty()) {
                SnmpRequest req;
                if (this._currentMuxReq == null) {
                    if (this.size() < 2) {
                        this.fireRequestDirect((SnmpRequest)this.firstElement());
                        this.removeAllElements();
                        break;
                    }
                    this._currentMuxReq = new MultiplexRequest(this.getPeer(), this.getSession(), this.getCommand());
                }
                if (this._currentMuxReq.addRequest(req = (SnmpRequest)this.lastElement())) {
                    --this.elementCount;
                    continue;
                }
                this._currentMuxReq.action();
                this._currentMuxReq = null;
            }
            if (this._currentMuxReq != null) {
                this._currentMuxReq.action();
                this._currentMuxReq = null;
            }
        }
    }
}

