/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager;

import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.manager.SnmpQManager;
import com.sun.management.snmp.manager.SnmpRequest;
import java.net.InetAddress;
import java.util.Vector;

class WaitQ
extends Vector {
    private static final long serialVersionUID = 5810932757067437680L;
    boolean isBeingDestroyed = false;

    WaitQ(int initialCapacity, int capacityIncr) {
        super(initialCapacity, capacityIncr);
    }

    public synchronized String printAllRequest(long time) {
        if (this.isEmpty()) {
            return "------- WaitQ empty.......";
        }
        StringBuffer str = new StringBuffer("\n------------------------ Requests in WaitQ -> " + this.size());
        int max = this.size();
        for (int i = 0; i < max; ++i) {
            SnmpRequest req = this.getRequestAt(i);
            str.append("\n" + i + ". (" + req.toString() + " RemainingTimeToSend = " + req.timeRemainingForAction(time) + "  ) ................................\n");
        }
        return str.toString();
    }

    public synchronized void addWaiting(SnmpRequest req) {
        int i;
        long waitTime = req.getAbsMaxTimeToWait();
        for (i = this.size(); i > 0 && waitTime >= this.getRequestAt(i - 1).getAbsMaxTimeToWait(); --i) {
        }
        if (i == this.size()) {
            this.addElement(req);
            this.notifyClients();
        } else {
            this.insertElementAt(req, i);
        }
    }

    public synchronized boolean waitUntilReady() {
        while (!this.isBeingDestroyed) {
            long tmp = 0L;
            if (!this.isEmpty()) {
                long currTime = System.currentTimeMillis();
                SnmpRequest req = (SnmpRequest)this.lastElement();
                tmp = req.getAbsMaxTimeToWait() - currTime;
                if (tmp <= 0L) {
                    return true;
                }
            }
            this.waitOnThisQueue(tmp);
        }
        return false;
    }

    public synchronized SnmpRequest getTimeoutRequests() {
        if (this.waitUntilReady()) {
            SnmpRequest req = (SnmpRequest)this.lastElement();
            --this.elementCount;
            return req;
        }
        return null;
    }

    private synchronized void notifyClients() {
        this.notifyAll();
    }

    public synchronized void waitOnThisQueue(long time) {
        if (time == 0L && !this.isEmpty() && SnmpQManager.logger.finestOn()) {
            SnmpQManager.logger.finest("waitOnThisQueue", "[" + Thread.currentThread().toString() + "]:" + "Fatal BUG :: Blocking on waitq permenantly. But size = " + this.size());
        }
        try {
            this.wait(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public SnmpRequest getRequestAt(int idx) {
        return (SnmpRequest)this.elementAt(idx);
    }

    public synchronized SnmpRequest removeRequest(long reqid) {
        int max = this.size();
        for (int i = 0; i < max; ++i) {
            SnmpRequest reqc = this.getRequestAt(i);
            if (reqid != (long)reqc.getRequestId()) continue;
            this.removeElementAt(i);
            return reqc;
        }
        return null;
    }

    public synchronized SnmpPduFactory findPduFactory(InetAddress address, int port) {
        SnmpPduFactory result = null;
        int max = this.size();
        for (int i = 0; i < max && result == null; ++i) {
            SnmpRequest reqc = this.getRequestAt(i);
            result = reqc.getSnmpSession().getPduFactory();
        }
        return result;
    }
}

