/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.internal.snmp.SnmpTools;
import com.sun.management.snmp.SnmpSecurityException;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTooBigException;
import com.sun.management.snmp.SnmpUnknownMsgProcModelException;
import com.sun.management.snmp.usm.SnmpUserSecurityModel;
import com.sun.management.snmp.usm.SnmpUsmAuthAlgorithmException;
import com.sun.management.snmp.usm.SnmpUsmAuthException;
import com.sun.management.snmp.usm.SnmpUsmAuthPair;
import com.sun.management.snmp.usm.SnmpUsmEngineIdException;
import com.sun.management.snmp.usm.SnmpUsmException;
import com.sun.management.snmp.usm.SnmpUsmExceptionGenerator;
import com.sun.management.snmp.usm.SnmpUsmLcd;
import com.sun.management.snmp.usm.SnmpUsmSecurityCache;
import com.sun.management.snmp.usm.SnmpUsmSecurityParameters;
import com.sun.management.snmp.usm.SnmpUsmSecurityParametersImpl;
import com.sun.management.snmp.usm.SnmpUsmUserNameException;

class SnmpUsmAuthModule {
    SnmpUserSecurityModel model = null;
    SnmpUsmLcd lcd = null;
    SnmpUsmExceptionGenerator genExp = null;
    byte[] zeroedArray = new byte[12];
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpUsmAuthModule");
    String dbgTag = "SnmpUsmAuthModule";

    SnmpUsmAuthModule(SnmpUserSecurityModel model, SnmpUsmLcd lcd, SnmpUsmExceptionGenerator genExp) {
        this.model = model;
        this.lcd = lcd;
        this.genExp = genExp;
    }

    void authMsg(SnmpMsgProcessingSubSystem sys, SnmpUsmSecurityParameters params, SnmpUsmSecurityCache usmcache, int version, int msgId, int msgMaxSize, byte msgFlags, int msgSecurityModel, byte[] encryptedPdu) throws SnmpStatusException, SnmpSecurityException {
        if (logger.finestOn()) {
            logger.finest("authMsg", "Will authenticate a new message");
        }
        byte[] receivedHMAC = params.getAuthParameters();
        if (logger.finestOn()) {
            logger.finest("authMsg", "Received HMAC : " + params.getAuthParameters());
        }
        try {
            byte[] calculatedHMAC = this.signMsg(sys, params, usmcache, version, msgId, msgMaxSize, msgFlags, msgSecurityModel, encryptedPdu);
            if (logger.finerOn()) {
                logger.finer("authMsg", " userName : " + params.getUserName() + " /\n Received HMAC : [" + SnmpTools.binary2ascii(receivedHMAC) + "]");
                logger.finer("authMsg", "Calculated HMAC : [" + SnmpTools.binary2ascii(calculatedHMAC) + "]");
            }
            this.checkHMAC(params, receivedHMAC, calculatedHMAC);
        }
        catch (SnmpUsmAuthException x) {
            this.genExp.genAuthenticationException(null, null, msgFlags, params);
        }
        catch (SnmpUsmUserNameException ex) {
            this.genExp.genUserNameException(null, null, msgFlags, params);
        }
        catch (SnmpUsmEngineIdException e) {
            this.genExp.genEngineIdException(null, null, msgFlags, params);
        }
        catch (SnmpUsmAuthAlgorithmException ea) {
            this.genExp.genSecurityLevelException(null, null, msgFlags, params);
        }
        catch (Exception e) {
            throw new SnmpSecurityException("unknown Security Exception");
        }
    }

    void authMsg(SnmpMsgProcessingSubSystem sys, SnmpUsmSecurityParameters params, SnmpUsmSecurityCache usmcache, int version, int msgId, int msgMaxSize, byte msgFlags, int msgSecurityModel, byte[] contextEngineId, byte[] contextName, byte[] data) throws SnmpStatusException, SnmpSecurityException {
        if (logger.finestOn()) {
            logger.finest("authMsg", "Will authenticate a new message");
        }
        byte[] receivedHMAC = params.getAuthParameters();
        if (logger.finestOn()) {
            logger.finest("authMsg", "Received HMAC : " + SnmpTools.binary2ascii(params.getAuthParameters()) + " data : " + data);
        }
        try {
            byte[] calculatedHMAC = this.signMsg(sys, params, usmcache, version, msgId, msgMaxSize, msgFlags, msgSecurityModel, contextEngineId, contextName, data, data == null ? 0 : data.length);
            if (logger.finerOn()) {
                logger.finer("authMsg", " userName : " + params.getUserName() + " /\n Received HMAC : [" + SnmpTools.binary2ascii(receivedHMAC) + "]");
                logger.finer("authMsg", "Calculated HMAC : [" + SnmpTools.binary2ascii(calculatedHMAC) + "]");
            }
            this.checkHMAC(params, receivedHMAC, calculatedHMAC);
        }
        catch (SnmpUsmAuthException x) {
            this.genExp.genAuthenticationException(contextEngineId, contextName, msgFlags, params);
        }
        catch (SnmpUsmUserNameException ex) {
            this.genExp.genUserNameException(contextEngineId, contextName, msgFlags, params);
        }
        catch (SnmpUsmEngineIdException e) {
            this.genExp.genEngineIdException(contextEngineId, contextName, msgFlags, params);
        }
        catch (SnmpUsmAuthAlgorithmException ea) {
            this.genExp.genSecurityLevelException(contextEngineId, contextName, msgFlags, params);
        }
        catch (Exception e) {
            throw new SnmpSecurityException("unknown Security Exception");
        }
    }

    byte[] signMsg(SnmpMsgProcessingSubSystem sys, SnmpUsmSecurityParameters params, SnmpUsmSecurityCache usmcache, int version, int msgId, int msgMaxSize, byte msgFlags, int msgSecurityModel, byte[] contextEngineId, byte[] contextName, byte[] data, int dataLength) throws SnmpUsmException, SnmpStatusException, SnmpTooBigException, SnmpUnknownMsgProcModelException {
        byte[] workingBuff = new byte[msgMaxSize];
        int workingBuffLen = 0;
        if (logger.finerOn()) {
            logger.finer("signMsg", " Will encode.");
        }
        workingBuffLen = sys.encode(version, msgId, msgMaxSize, msgFlags, msgSecurityModel, this.createAuthPrivNullParams(params), contextEngineId, contextName, data, dataLength, workingBuff);
        return this.sign(usmcache, params, workingBuff, workingBuffLen);
    }

    private SnmpUsmSecurityParameters createAuthPrivNullParams(SnmpUsmSecurityParameters params) {
        SnmpUsmSecurityParametersImpl nullParams = new SnmpUsmSecurityParametersImpl(params);
        nullParams.setAuthParameters(this.zeroedArray);
        if (logger.finestOn()) {
            logger.finer("createAuthPrivNullParams", "parameters : " + nullParams);
        }
        return nullParams;
    }

    private SnmpUsmSecurityParameters createAuthNullParams(SnmpUsmSecurityParameters params) {
        SnmpUsmSecurityParametersImpl nullParams = new SnmpUsmSecurityParametersImpl(params);
        nullParams.setAuthParameters(this.zeroedArray);
        nullParams.setPrivParameters(params.getPrivParameters());
        if (logger.finestOn()) {
            logger.finer("createAuthNullParams", "parameters : " + nullParams);
        }
        return nullParams;
    }

    byte[] signMsg(SnmpMsgProcessingSubSystem sys, SnmpUsmSecurityParameters params, SnmpUsmSecurityCache usmcache, int version, int msgId, int msgMaxSize, byte msgFlags, int msgSecurityModel, byte[] encryptedPdu) throws SnmpUsmException, SnmpStatusException, SnmpTooBigException, SnmpUnknownMsgProcModelException {
        byte[] workingBuff = new byte[msgMaxSize];
        int workingBuffLen = 0;
        if (logger.finerOn()) {
            logger.finer("signMsg", " Will encode.");
        }
        workingBuffLen = sys.encodePriv(version, msgId, msgMaxSize, msgFlags, msgSecurityModel, this.createAuthNullParams(params), encryptedPdu, workingBuff);
        return this.sign(usmcache, params, workingBuff, workingBuffLen);
    }

    private byte[] sign(SnmpUsmSecurityCache usmcache, SnmpUsmSecurityParameters p, byte[] data, int length) throws SnmpUsmException {
        SnmpUsmAuthPair authPair = null;
        if (logger.finerOn()) {
            logger.finer("sign", "Data :" + data + " length :" + length + " userName : " + p.getUserName());
        }
        authPair = usmcache != null ? (usmcache.auth == null ? this.lcd.getUserAuthPair(p.getAuthoritativeEngineId(), p.getUserName()) : usmcache.auth) : this.lcd.getUserAuthPair(p.getAuthoritativeEngineId(), p.getUserName());
        byte[] hmac = authPair.algo.sign(authPair.key, data, length);
        if (logger.finerOn()) {
            logger.finer("sign", " userName : " + p.getUserName() + " /\n HMAC : [" + SnmpTools.binary2ascii(hmac) + "]");
        }
        return hmac;
    }

    private void checkHMAC(SnmpUsmSecurityParameters p, byte[] receivedHMAC, byte[] calculatedHMAC) throws SnmpUsmAuthException {
        int recLen = receivedHMAC.length;
        int calLen = calculatedHMAC.length;
        if (recLen != calLen) {
            throw new SnmpUsmAuthException("User " + p.getUserName() + " not authenticated");
        }
        for (int i = 0; i < calLen; ++i) {
            if (receivedHMAC[i] == calculatedHMAC[i]) continue;
            throw new SnmpUsmAuthException("User " + p.getUserName() + " not authenticated");
        }
        if (logger.finerOn()) {
            logger.finer("checkHMAC", "HMAC [" + SnmpTools.binary2ascii(receivedHMAC) + "] is VALID.");
        }
    }
}

