/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm;

import com.sun.jdmk.defaults.DefaultPaths;
import com.sun.jdmk.internal.BackupFileHandler;
import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpLcd;
import com.sun.management.internal.snmp.SnmpPersistRowFile;
import com.sun.management.internal.snmp.SnmpPersistRowFileConsumer;
import com.sun.management.internal.snmp.SnmpSubSystem;
import com.sun.management.internal.snmp.SnmpTools;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.usm.LcdEngine;
import com.sun.management.snmp.usm.SecurityConfException;
import com.sun.management.snmp.usm.SnmpUsmAlgorithmManager;
import com.sun.management.snmp.usm.SnmpUsmAuthAlgorithm;
import com.sun.management.snmp.usm.SnmpUsmAuthAlgorithmException;
import com.sun.management.snmp.usm.SnmpUsmAuthPair;
import com.sun.management.snmp.usm.SnmpUsmEngineIdException;
import com.sun.management.snmp.usm.SnmpUsmException;
import com.sun.management.snmp.usm.SnmpUsmLcd;
import com.sun.management.snmp.usm.SnmpUsmMibTable;
import com.sun.management.snmp.usm.SnmpUsmPrivAlgorithm;
import com.sun.management.snmp.usm.SnmpUsmPrivAlgorithmException;
import com.sun.management.snmp.usm.SnmpUsmPrivPair;
import com.sun.management.snmp.usm.SnmpUsmSecureUser;
import com.sun.management.snmp.usm.SnmpUsmSecureUserImpl;
import com.sun.management.snmp.usm.SnmpUsmUserNameException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SnmpUsmPasswordLcd
implements SnmpUsmLcd {
    static final int USER_ENGINEID = 0;
    static final int USER_NAME = 1;
    static final int USER_SECURITY_NAME = 2;
    static final int USER_AUTH_PROTOCOL = 3;
    static final int USER_AUTH_PASSWORD = 4;
    static final int USER_PRIV_PROTOCOL = 5;
    static final int USER_PRIV_PASSWORD = 6;
    static final int USER_STORAGE_TYPE = 7;
    static final int USER_TEMPLATE = 8;
    UsmConsumer consumer;
    SnmpPersistRowFile file;
    boolean strictParsing;
    Hashtable engines;
    SnmpUsmAlgorithmManager algos;
    LcdEngine localEngine;
    SnmpEngine engine;
    SnmpUsmMibTable table;
    boolean sync;
    boolean syncDone;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpUsmPasswordLcd");
    String dbgTag;

    public SnmpUsmPasswordLcd(SnmpEngine engine, SnmpSubSystem subsys, SnmpLcd snmplcd, String file) throws IllegalArgumentException {
        block6: {
            this.consumer = null;
            this.file = null;
            this.strictParsing = true;
            this.engines = new Hashtable();
            this.algos = null;
            this.localEngine = null;
            this.engine = null;
            this.table = null;
            this.sync = false;
            this.syncDone = false;
            this.dbgTag = "SnmpUsmPasswordLcd";
            this.engine = engine;
            snmplcd.addModelLcd(subsys, 3, this);
            this.consumer = new UsmConsumer(this);
            String testedFile = this.handleSecurityFileLocation(file);
            if (testedFile != null) {
                try {
                    this.file = new SnmpPersistRowFile(testedFile, "userEntry", ",", this.consumer);
                    if (this.strictParsing) {
                        this.file.enableException(true);
                    }
                    break block6;
                }
                catch (IllegalArgumentException e) {
                    if (logger.finestOn()) {
                        logger.finest("SnmpUsmPasswordLcd", "Exception :" + e);
                    }
                    break block6;
                }
            }
            if (logger.finestOn()) {
                logger.finest("SnmpUsmPasswordLcd", "No configuration file provided.");
            }
        }
        this.localEngine = new LcdEngine(engine.getEngineId());
        this.engines.put(engine.getEngineId().toString(), this.localEngine);
    }

    public void enableStrictParsing(boolean b) {
        this.strictParsing = b;
    }

    public void setUserAuthKeyChange(SnmpUsmSecureUser u, byte[] keyChange) {
        SnmpUsmSecureUserImpl user = (SnmpUsmSecureUserImpl)u;
        user.setAuthKeyChange(keyChange);
    }

    public void setUserPrivKeyChange(SnmpUsmSecureUser u, byte[] keyChange) {
        SnmpUsmSecureUserImpl user = (SnmpUsmSecureUserImpl)u;
        user.setPrivKeyChange(keyChange);
    }

    public void addUser(SnmpUsmSecureUser user, boolean notifyMIB) {
        this.insertUser(user.getEngineId(), user, notifyMIB);
    }

    public SnmpUsmSecureUser createNewUser(byte[] engineId, String name) {
        SnmpUsmSecureUserImpl user = new SnmpUsmSecureUserImpl(this, SnmpEngineId.createEngineId(engineId), name);
        return user;
    }

    public int getStorageType() {
        if (this.file != null) {
            return 3;
        }
        return 2;
    }

    public void setMibTable(SnmpUsmMibTable table) {
        this.table = table;
    }

    public synchronized void addEngine(SnmpEngineId engineId) {
    }

    public void setAlgorithmManager(SnmpUsmAlgorithmManager algos) {
        this.algos = algos;
    }

    public SnmpUsmSecureUser getUser(SnmpEngineId engineId, String userName) throws SnmpUsmEngineIdException, SnmpUsmUserNameException {
        return this.findUser(engineId, userName);
    }

    public synchronized void syncDataSource() throws IllegalArgumentException {
        if (this.syncDone) {
            return;
        }
        this.sync = true;
        if (this.getStorageType() == 3) {
            this.readFile();
        }
        this.sync = false;
        this.syncDone = true;
    }

    public SnmpUsmAlgorithmManager getAlgorithmManager() {
        return this.algos;
    }

    public synchronized SnmpUsmPrivPair getUserPrivPair(SnmpEngineId engineId, String userName) throws SnmpUsmPrivAlgorithmException, SnmpUsmEngineIdException, SnmpUsmUserNameException {
        SnmpUsmSecureUserImpl user = null;
        user = (SnmpUsmSecureUserImpl)this.findUser(engineId, userName);
        SnmpUsmPrivAlgorithm userAlgo = user.getPrivPair().algo;
        if (userAlgo == null) {
            throw new SnmpUsmPrivAlgorithmException("User: " + user.getName() + " No Priv algorithm");
        }
        return user.getPrivPair();
    }

    public synchronized SnmpUsmAuthPair getUserAuthPair(SnmpEngineId engineId, String userName) throws SnmpUsmAuthAlgorithmException, SnmpUsmEngineIdException, SnmpUsmUserNameException {
        SnmpUsmSecureUserImpl user = null;
        user = (SnmpUsmSecureUserImpl)this.findUser(engineId, userName);
        SnmpUsmAuthAlgorithm userAlgo = user.getAuthPair().algo;
        if (userAlgo == null) {
            throw new SnmpUsmAuthAlgorithmException("User: " + user.getName() + " No Auth algorithm");
        }
        return user.getAuthPair();
    }

    public synchronized void addUser(SnmpEngineId engineId, String userName, String securityName, String authProtocol, String authPassword, String privProtocol, String privPassword, int storage, boolean template) throws SnmpUsmException {
        try {
            this.translateAndInsert(engineId, engineId.getReadableId() == null ? engineId.toString() : engineId.getReadableId(), userName, securityName, authProtocol, authPassword, privProtocol, privPassword, storage, template);
        }
        catch (SecurityConfException e) {
            throw new SnmpUsmException("Security configuration: " + e);
        }
    }

    public synchronized Enumeration getAllUsers() {
        Vector<SnmpUsmSecureUser> res = new Vector<SnmpUsmSecureUser>();
        Enumeration e = this.engines.elements();
        while (e.hasMoreElements()) {
            LcdEngine eng = (LcdEngine)e.nextElement();
            Enumeration u = eng.users.elements();
            while (u.hasMoreElements()) {
                SnmpUsmSecureUser user = (SnmpUsmSecureUser)u.nextElement();
                res.add(user);
            }
        }
        return res.elements();
    }

    private String handleSecurityFileLocation(String securityFile) throws IllegalArgumentException {
        String lcdFile = null;
        File file = null;
        if (securityFile == null) {
            lcdFile = System.getProperty("jdmk.security.file");
            if (lcdFile == null) {
                if (logger.finestOn()) {
                    logger.finest("handleSecurityFileLocation", "Security file not found. Use default one.");
                }
                if (!(file = new File(lcdFile = DefaultPaths.getEtcDir("conf" + File.separator + "jdmk.security"))).exists()) {
                    file = null;
                    if (logger.finerOn()) {
                        logger.finer("handleSecurityFileLocation", "The default file [" + lcdFile + "] doesn't exist.");
                    }
                    return null;
                }
                return lcdFile;
            }
            file = new File(lcdFile);
            if (!file.exists()) {
                if (logger.finerOn()) {
                    logger.finer("handleSecurityFileLocation", "The specified file [" + file + "] doesn't exist, " + "no configuration loaded");
                }
                throw new IllegalArgumentException("The specified file [" + file + "] doesn't exist, no configuration loaded");
            }
            return lcdFile;
        }
        file = new File(securityFile);
        if (!file.exists()) {
            if (logger.finerOn()) {
                logger.finer("handleSecurityFileLocation", "The specified file [" + file + "] doesn't exist, no configuration loaded");
            }
            throw new IllegalArgumentException("The specified file [" + file + "] doesn't exist, no configuration loaded");
        }
        return securityFile;
    }

    private void sendNewUserEvent(SnmpUsmSecureUser user, boolean flag) {
        if (!flag) {
            return;
        }
        if (this.table != null) {
            this.table.userAdded(user);
        }
    }

    private void sendUpdateUserEvent(SnmpUsmSecureUser user, boolean flag) {
        if (!flag) {
            return;
        }
        if (this.table != null) {
            this.table.userUpdated(user);
        }
    }

    private void sendRemoveUserEvent(SnmpUsmSecureUser user, boolean flag) {
        if (!flag) {
            return;
        }
        if (this.table != null) {
            this.table.userRemoved(user);
        }
    }

    public synchronized void removeUser(SnmpEngineId engineId, String userName, boolean notifyMIB) {
        LcdEngine engine = (LcdEngine)this.engines.get(engineId.toString());
        if (engine == null) {
            return;
        }
        SnmpUsmSecureUser user = engine.removeSecureUser(userName);
        if (user != null) {
            if (this.getStorageType() == 3) {
                this.flushFile();
            }
            this.sendRemoveUserEvent(user, notifyMIB);
        }
    }

    private synchronized void insertUser(SnmpEngineId engineId, SnmpUsmSecureUser user, boolean flag) {
        SnmpUsmSecureUser old;
        LcdEngine engine = (LcdEngine)this.engines.get(engineId.toString());
        if (engine == null) {
            if (logger.finestOn()) {
                logger.finest("insertUser", " New engine Id");
            }
            engine = new LcdEngine(engineId);
            this.engines.put(engineId.toString(), engine);
        }
        if (logger.finestOn()) {
            logger.finest("insertUser", " engine id : " + engine.engineId);
        }
        if (logger.finestOn()) {
            logger.finest("insertUser", " Inserting a new User [" + user.getName() + "]" + ", engineId [" + engineId + "], notif flag : " + flag);
        }
        if ((old = engine.addSecureUser(user)) != null) {
            if (logger.finestOn()) {
                logger.finest("insertUser", " It is an update");
            }
            this.sendUpdateUserEvent(user, flag);
        } else {
            if (logger.finestOn()) {
                logger.finest("insertUser", " It is a new user");
            }
            this.sendNewUserEvent(user, flag);
        }
        if (!this.sync && this.getStorageType() == 3) {
            this.flushFile();
        }
    }

    private synchronized SnmpUsmSecureUser findUser(SnmpEngineId engineId, String userName) throws SnmpUsmEngineIdException, SnmpUsmUserNameException {
        if (logger.finerOn()) {
            logger.finer("findUser", "Engine Id : " + engineId + "/" + engineId.hashCode() + "     user Name : " + userName);
        }
        LcdEngine engine = (LcdEngine)this.engines.get(engineId.toString());
        SnmpUsmSecureUser user = null;
        if (userName == null) {
            if (logger.finestOn()) {
                logger.finest("findUser", "Username : [" + userName + "] NULL.");
            }
            throw new SnmpUsmUserNameException("User " + userName + " unknown.");
        }
        if (engine == null) {
            if (logger.finestOn()) {
                logger.finest("findUser", "Engine Id [" + engineId.toString() + "] unknown.");
            }
            throw new SnmpUsmEngineIdException("Unknown engine Id : " + engineId.toString());
        }
        if (logger.finerOn()) {
            logger.finer("findUser", "EXISTS. Engine Id : " + engine.engineId.toString());
        }
        if ((user = engine.getSecureUser(userName)) == null) {
            if (logger.finestOn()) {
                logger.finest("findUser", "Username : [" + userName + "] unknown.");
            }
            throw new SnmpUsmUserNameException("User " + userName + " unknown.");
        }
        if (logger.finerOn()) {
            logger.finer("findUser", "Known engine Id [" + engine.engineId.toString() + " ] and user Name [" + user.getName() + "]");
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    synchronized void flushFile() {
        block16: {
            File backupFile;
            FileWriter writer;
            block15: {
                writer = null;
                backupFile = BackupFileHandler.createBackupFile(this.file.getFile(), null);
                if (backupFile == null) {
                    if (logger.finestOn()) {
                        logger.finest("flushFile", "Backup file not created, changes are not flushed");
                    }
                    return;
                }
                if (logger.finestOn()) {
                    logger.finest("flushFile", "Flushing file, backup file : " + backupFile);
                }
                writer = this.file.createWriter();
                SnmpEngineId id = this.engine.getEngineId();
                this.file.write(writer, "localEngineID", (id.getReadableId() == null ? id.toString() : id.getReadableId()) + "\n");
                this.file.write(writer, "localEngineBoots", this.engine.getEngineBoots() + 1 + "\n\n");
                Enumeration e = this.engines.elements();
                while (e.hasMoreElements()) {
                    LcdEngine eng = (LcdEngine)e.nextElement();
                    eng.storeUsers(this.engine.getEngineId(), writer, this.file);
                }
                Object var7_7 = null;
                if (writer == null) break block15;
                try {
                    this.file.releaseWriter(writer);
                }
                catch (Exception e2) {
                    if (!logger.finestOn()) break block15;
                    logger.finest("flushFile", "Exception : " + e2);
                }
            }
            BackupFileHandler.deleteBackupFile(backupFile);
            {
                break block16;
                catch (Exception ex) {
                    block17: {
                        if (logger.finestOn()) {
                            logger.finest("flushFile", "Exception : " + ex);
                        }
                        Object var7_8 = null;
                        if (writer != null) {
                            try {
                                this.file.releaseWriter(writer);
                            }
                            catch (Exception e2) {
                                if (!logger.finestOn()) break block17;
                                logger.finest("flushFile", "Exception : " + e2);
                            }
                        }
                    }
                    BackupFileHandler.deleteBackupFile(backupFile);
                }
            }
            catch (Throwable throwable) {
                block18: {
                    Object var7_9 = null;
                    if (writer != null) {
                        try {
                            this.file.releaseWriter(writer);
                        }
                        catch (Exception e2) {
                            if (!logger.finestOn()) break block18;
                            logger.finest("flushFile", "Exception : " + e2);
                        }
                    }
                }
                BackupFileHandler.deleteBackupFile(backupFile);
                throw throwable;
            }
        }
    }

    private synchronized void readFile() {
        block4: {
            try {
                this.file.read();
            }
            catch (FileNotFoundException e) {
                if (logger.finestOn()) {
                    logger.finest("readFile", "No configuration file. Will not read or persist data");
                }
            }
            catch (IOException e) {
                if (!logger.finestOn()) break block4;
                logger.finest("readFile", "IO error :" + e);
            }
        }
    }

    private String strContext(int context) {
        switch (context) {
            case 1: {
                return "user name";
            }
            case 0: {
                return "user engine id";
            }
            case 3: {
                return "user auth protocol";
            }
            case 2: {
                return "user security name";
            }
            case 4: {
                return "user auth password";
            }
            case 6: {
                return "user priv key";
            }
            case 5: {
                return "user priv protocol";
            }
            case 7: {
                return "user storage type";
            }
        }
        return "unknown parameter";
    }

    private synchronized void translateAndInsert(SnmpEngineId engineId, String strEngineId, String userName, String securityName, String authProtocol, String authPassword, String privProtocol, String privPassword, int storageType, boolean template) throws SecurityConfException {
        byte[] authKey = null;
        byte[] privKey = null;
        SnmpUsmAuthAlgorithm auth = null;
        SnmpUsmPrivAlgorithm priv = null;
        if (userName == null) {
            throw new IllegalArgumentException("Missing user.");
        }
        if (authProtocol != null && !authProtocol.equals("usmNoAuthProtocol") && (auth = (SnmpUsmAuthAlgorithm)this.algos.getAlgorithm(authProtocol)) == null) {
            String msg = "Unknown authentication algorithm : [" + authProtocol + "]";
            throw new IllegalArgumentException(msg);
        }
        if (authPassword != null && authPassword.startsWith("0x")) {
            try {
                authKey = SnmpTools.ascii2binary(authPassword);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Unexpected exception: " + e);
            }
        }
        if (privProtocol != null && !privProtocol.equals("usmNoPrivProtocol") && (priv = (SnmpUsmPrivAlgorithm)this.algos.getAlgorithm(privProtocol)) == null) {
            String msg = "Unknown privacy algorithm : [" + privProtocol + "]";
            throw new IllegalArgumentException(msg);
        }
        if (privPassword != null && privPassword.startsWith("0x")) {
            try {
                privKey = SnmpTools.ascii2binary(privPassword);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Unexpected exception: " + e);
            }
        }
        if (authPassword != null && authKey == null && auth != null) {
            authKey = auth.password_to_key(authPassword);
        }
        if (authKey != null && auth != null && !authPassword.startsWith("0x")) {
            authKey = auth.localizeAuthKey(authKey, engineId);
        }
        if (privPassword != null && privKey == null && priv != null) {
            if (auth == null) {
                throw new IllegalArgumentException("Translating priv password to priv key but auth algo is null");
            }
            privKey = auth.password_to_key(privPassword);
        }
        if (privKey != null && priv != null && !privPassword.startsWith("0x")) {
            if (auth == null) {
                throw new IllegalArgumentException("Localizing priv key but auth algo is null");
            }
            privKey = auth.localizePrivKey(privKey, engineId, priv.getKeySize());
        }
        SnmpUsmSecureUserImpl user = new SnmpUsmSecureUserImpl(this, engineId, strEngineId, userName, securityName, auth, authProtocol, authKey, authPassword, priv, privProtocol, privKey, privPassword, storageType, template);
        this.insertUser(engineId, user, true);
    }

    private synchronized SnmpEngineId translateEngineId(String strEngineId) throws SecurityConfException {
        SnmpEngineId engineId = null;
        int index = strEngineId.indexOf("0x");
        if (index == -1 && !strEngineId.equals("localEngineID")) {
            try {
                engineId = SnmpEngineId.createEngineId(strEngineId);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Unknown host : " + e.getMessage());
            }
            if (logger.finerOn()) {
                logger.finer("translateEngineId", "Caculate engine Id from : " + strEngineId + "\tResulting Id : " + engineId);
            }
        } else if (!strEngineId.equals("localEngineID") && !strEngineId.equals(this.engine.getEngineId().toString())) {
            try {
                engineId = SnmpEngineId.createEngineId(strEngineId);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Unknown host : " + e.getMessage());
            }
        } else {
            engineId = this.engine.getEngineId();
        }
        return engineId;
    }

    void endRow(DataUser d, String row, int line) throws Exception {
        int storage;
        block7: {
            storage = 0;
            if (d.storageType != null) {
                try {
                    storage = Integer.parseInt(d.storageType);
                    if (storage != 3) {
                        throw new IllegalArgumentException("Illegal storage type : " + storage);
                    }
                    break block7;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Unexpected exception: " + e);
                }
            }
            storage = 3;
        }
        SnmpEngineId engineId = this.translateEngineId(d.strEngineId);
        try {
            this.findUser(engineId, d.name);
            throw new IllegalArgumentException("Already defined user");
        }
        catch (SnmpUsmException e) {
            boolean template = false;
            if (d.template != null && d.template.equals("true")) {
                template = true;
            }
            this.translateAndInsert(engineId, d.strEngineId, d.name, d.securityName, d.authProtocol, d.authPassword, d.privProtocol, d.privPassword, storage, template);
            return;
        }
    }

    class UsmConsumer
    implements SnmpPersistRowFileConsumer {
        DataUser user;
        SnmpUsmPasswordLcd usmlcd;

        UsmConsumer(SnmpUsmPasswordLcd usmlcd) {
            this.user = new DataUser();
            this.usmlcd = null;
            this.usmlcd = usmlcd;
        }

        public Object rowBegin(String row, int line) {
            this.user.reset();
            return this.user;
        }

        public void rowEnd(Object rowContext, String row, int line) throws Exception {
            DataUser data = (DataUser)rowContext;
            this.usmlcd.endRow(data, row, line);
        }

        public void treatToken(String row, int lineNumber, String token, int context, Object rowContext, boolean err) throws Exception {
            DataUser data = (DataUser)rowContext;
            switch (context) {
                case 0: {
                    if (err || token == null) {
                        throw new IllegalArgumentException("Missing engine Id.");
                    }
                    if (logger.finerOn()) {
                        logger.finer("treatToken", "context = " + SnmpUsmPasswordLcd.this.strContext(context) + " value : " + token);
                    }
                    data.strEngineId = token;
                    break;
                }
                case 1: {
                    if (err || token == null) {
                        throw new IllegalArgumentException("Missing user.");
                    }
                    if (logger.finerOn()) {
                        logger.finer("treatToken", "context = " + SnmpUsmPasswordLcd.this.strContext(context) + " value : " + token);
                    }
                    data.name = token;
                    break;
                }
                case 2: {
                    if (err) {
                        return;
                    }
                    data.securityName = token;
                    break;
                }
                case 3: {
                    if (err) {
                        return;
                    }
                    data.authProtocol = token;
                    break;
                }
                case 4: {
                    if (err) {
                        return;
                    }
                    data.authPassword = token;
                    break;
                }
                case 5: {
                    if (err) {
                        return;
                    }
                    data.privProtocol = token;
                    break;
                }
                case 6: {
                    if (err) {
                        return;
                    }
                    data.privPassword = token;
                    break;
                }
                case 7: {
                    if (err) {
                        return;
                    }
                    data.storageType = token;
                    break;
                }
                case 8: {
                    if (err) {
                        return;
                    }
                    data.template = token;
                    break;
                }
                default: {
                    if (logger.finestOn()) {
                        logger.finest("TreatToken", "Unknown context.");
                    }
                    throw new IllegalArgumentException("Unknown parameter");
                }
            }
        }
    }

    class DataUser {
        String strEngineId = null;
        String name = null;
        String authPassword = null;
        String privPassword = null;
        String securityName = null;
        String authProtocol = null;
        String privProtocol = null;
        String storageType = null;
        String template = null;

        DataUser() {
        }

        void reset() {
            this.strEngineId = null;
            this.name = null;
            this.authPassword = null;
            this.privPassword = null;
            this.securityName = null;
            this.authProtocol = null;
            this.privProtocol = null;
            this.storageType = null;
            this.template = null;
        }
    }
}

