/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemos.wp35.cdaclient;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMWriter;
import org.xtreemos.wp35.cdaclient.PeerChecker;
import org.xtreemos.wp35.util.CertificateProcessor;
import org.xtreemos.wp35.util.Utils;

public class CdaClient {
    private static SSLSocket clientSocket = null;
    OutputStream os = null;
    InputStream is = null;
    InputStreamReader isr = null;
    BufferedReader br = null;
    Writer wr = null;
    static PublicKey rootCaPublicKey = null;
    static String cipher = "RSA";
    private static TrustManager[] trustManagers = null;

    private KeyStore createTrustStore(X509Certificate trustedServerCertificate, String alias) {
        KeyStore trustStore = null;
        try {
            trustStore = KeyStore.getInstance("JKS");
            trustStore.load(null);
            trustStore.setCertificateEntry(alias, trustedServerCertificate);
        }
        catch (KeyStoreException ex) {
            System.err.println(ex);
            ex.printStackTrace();
            System.exit(-1);
        }
        catch (IOException ex) {
        }
        catch (NoSuchAlgorithmException ex) {
        }
        catch (CertificateException ex) {
            // empty catch block
        }
        return trustStore;
    }

    private TrustManager[] createTrustManagers(KeyStore trustStore) {
        TrustManagerFactory trustManagerFactory = null;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(trustStore);
        }
        catch (NoSuchAlgorithmException ex) {
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return trustManagerFactory.getTrustManagers();
    }

    private SSLContext createSSLContext(X509Certificate trustedCert) {
        SSLContext sslContext = null;
        String ALIAS = "server";
        try {
            KeyStore trustStore = this.createTrustStore(trustedCert, "server");
            trustManagers = this.createTrustManagers(trustStore);
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagers, null);
        }
        catch (NoSuchAlgorithmException ex) {
            System.err.println(ex);
            System.exit(-1);
        }
        catch (KeyManagementException ex) {
            System.err.println(ex);
            System.exit(-1);
        }
        return sslContext;
    }

    public CdaClient(String host, int port, X509Certificate trustedCert) {
        try {
            SSLContext sslContext = this.createSSLContext(trustedCert);
            SSLSocketFactory sockFact = sslContext.getSocketFactory();
            clientSocket = (SSLSocket)sockFact.createSocket(host, port);
            this.os = clientSocket.getOutputStream();
            this.wr = new BufferedWriter(new OutputStreamWriter(this.os));
            this.is = clientSocket.getInputStream();
            this.isr = new InputStreamReader(this.is);
            this.br = new BufferedReader(this.isr);
        }
        catch (UnknownHostException ex) {
            System.err.println(ex);
            System.exit(-1);
        }
        catch (IOException ex) {
            System.err.println(ex);
            System.exit(-1);
        }
    }

    private boolean authenticate(String voUsername, char[] voPassword) throws IOException {
        boolean result = false;
        try {
            this.wr.write("AUTHENTICATE\n");
            this.wr.flush();
            this.wr.write(voUsername + "," + new String(voPassword) + "\n");
            this.wr.flush();
        }
        catch (IOException ex) {
            if (ex instanceof SSLException) {
                System.err.printf(ex.getMessage(), new Object[0]);
            }
            throw new IOException("Couldn't send AUTHENTICATE request");
        }
        String authResult = this.br.readLine();
        if ("OK".equalsIgnoreCase(authResult)) {
            result = true;
        }
        return result;
    }

    private void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        clientSocket.addHandshakeCompletedListener(listener);
    }

    private void startHandshake() throws IOException {
        clientSocket.startHandshake();
    }

    protected X509Certificate sendCertificateRequest(String voName, PKCS10CertificationRequest userRequest) throws IllegalArgumentException, IOException {
        X509Certificate cert = null;
        try {
            this.wr.write("CERTREQUEST\n");
            this.wr.flush();
            this.wr.write("dummy\n");
            this.wr.flush();
            PEMWriter pwriter = new PEMWriter(this.wr);
            pwriter.writeObject((Object)userRequest);
            pwriter.flush();
            cert = Utils.readCertificate(this.isr);
            this.os.close();
            X509Certificate x509Certificate = cert;
            return x509Certificate;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            clientSocket.close();
            throw new IOException("Can't send certificate signing request to server or reading certificate failed (likely to be server side problem).");
        }
        catch (IllegalArgumentException ex) {
            clientSocket.close();
            throw ex;
        }
        finally {
            if (clientSocket != null) {
                clientSocket.close();
            }
        }
    }

    public static void main(String[] args) {
        File rootCaCertFile;
        String rootCACertFilename;
        File confDirFile;
        String[] hostAndPort;
        String usage = "Usage: CdaClient host:port [privatekeyoutputfile certificatetoutputfile]";
        if (args.length < 1) {
            System.err.println(usage);
            System.exit(-1);
        }
        if ((hostAndPort = args[0].split(":")).length != 2) {
            System.err.printf("Error - please supply location of CDA server in format hostname:port. Exiting.\n", new Object[0]);
            System.exit(-1);
        }
        String host = hostAndPort[0];
        String port = hostAndPort[1];
        String confDir = null;
        String confDirPropName = "cdaclient.confDir";
        confDir = System.getProperty(confDirPropName);
        if (!(confDir != null && new File(confDir).exists() || (confDirFile = new File(confDir = "/etc/xtreemos/cdaclient/")).exists())) {
            System.err.printf("Cannot find CDA client configuration from propery %s or default directory %s.\n", confDirPropName, confDir);
            System.err.println("Exiting.\n");
            System.exit(-1);
        }
        if (null == (rootCACertFilename = System.getProperty("XtreemOS.rootCertificate"))) {
            String gridName = System.getProperty("XtreemOS.gridName", "XtreemOS");
            String rootCertDirName = System.getProperty("XtreemOS.rootCertDir", "/etc/pki/tls/rootcerts/");
            rootCACertFilename = rootCertDirName + "/" + gridName + ".pem";
        }
        if (!(rootCaCertFile = new File(rootCACertFilename)).exists()) {
            System.err.printf("Cannot find XtreemOS Root CA certificate in %s - exiting.\n", rootCACertFilename);
            System.exit(-1);
        }
        String userKeyFilename = null;
        String certFilename = null;
        if (args.length >= 3) {
            userKeyFilename = args[1];
            certFilename = args[2];
        } else {
            String homeDir = System.getProperty("user.home");
            String trustStorePath = homeDir + "/" + System.getProperty("XtreemOS.trustStore", ".xos/truststore/");
            String userKeyFilePath = System.getProperty("XtreemOS.userKeyPath", trustStorePath + "/private/");
            String userCertFilePath = System.getProperty("XtreemOS.userCertPath", trustStorePath + "/certs/");
            userKeyFilename = userKeyFilePath + "/" + "cda.pem";
            certFilename = userCertFilePath + "/" + "cda.pem";
            if (userKeyFilename.indexOf(126) >= 0 || certFilename.indexOf(126) >= 0) {
                System.err.printf("You've included a tilde character '~' in a filename - either\n", new Object[0]);
                System.err.printf("%s\nor\n%s\nor both - Java cannot interpret this. Exiting.\n", userKeyFilename, certFilename);
                System.exit(0);
            }
        }
        String voUsername = null;
        char[] voPassword = null;
        char[] keyPassphrase = null;
        boolean hardwired = false;
        if (args.length >= 4 && "test".equals(args[3])) {
            hardwired = true;
            voUsername = "xtreemos-vouser";
            voPassword = "xtreemos".toCharArray();
            keyPassphrase = "xtreemos".toCharArray();
        }
        boolean verbose = false;
        try {
            boolean verified;
            Security.addProvider((Provider)new BouncyCastleProvider());
            int portnum = Integer.valueOf(port);
            if (!hardwired) {
                Console console = System.console();
                if (null == console) {
                    System.err.println("Can't open system console to read passwords securely, exiting...\n");
                    System.exit(-1);
                }
                voUsername = console.readLine("Enter your username: ", new Object[0]);
                voPassword = console.readPassword("Enter password: ", new Object[0]);
                console.printf("\n", new Object[0]);
                keyPassphrase = Utils.getPassphrase(console, 8);
            }
            KeyPair keyPair = Utils.generateKeyPair(cipher, 1024);
            PrivateKey priv = keyPair.getPrivate();
            X509Certificate rootCaCert = Utils.readX509Certificate(rootCACertFilename, new char[0]);
            rootCaPublicKey = rootCaCert.getPublicKey();
            CdaClient client = new CdaClient(host, portnum, rootCaCert);
            boolean carryOnRegardless = Boolean.getBoolean("cdaclient.ignoreWrongCDACertificate");
            PeerChecker peerChecker = new PeerChecker(host, rootCaPublicKey, trustManagers, carryOnRegardless);
            client.addHandshakeCompletedListener(peerChecker);
            long t1 = System.currentTimeMillis();
            client.startHandshake();
            while (!peerChecker.isReady()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {}
            }
            boolean authOK = client.authenticate(voUsername, voPassword);
            if (!authOK) {
                throw new IllegalArgumentException("Could not authenticate user " + voUsername);
            }
            X509Certificate userCert = null;
            PKCS10CertificationRequest certRequest = new PKCS10CertificationRequest("SHA256withRSA", new X500Principal(""), keyPair.getPublic(), null, keyPair.getPrivate());
            if (!certRequest.verify()) {
                throw new IllegalArgumentException("Cannot verify certificate signing request");
            }
            if (verbose) {
                System.err.print("Requesting certficate from server...");
            }
            userCert = client.sendCertificateRequest("noVO", certRequest);
            long t2 = System.currentTimeMillis();
            if (verbose) {
                System.err.printf("Request took %dms.\n", t2 - t1);
            }
            if (verbose) {
                System.err.println(" done.");
                System.err.print("Verifying issued XOS certificate... ");
            }
            if (verified = CertificateProcessor.verifyCertificate(userCert, verbose, peerChecker.getPeerKey())) {
                if (verbose) {
                    System.out.printf("Certificate verified OK, saving in %s.\n", certFilename);
                }
                if (verbose) {
                    System.err.print(" saving... ");
                }
                Utils.writeKey(new FileOutputStream(userKeyFilename), priv, "DESEDE", keyPassphrase);
                Arrays.fill(keyPassphrase, ' ');
                OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(certFilename));
                Utils.writeCertificate(osw, userCert);
                osw.close();
            } else {
                System.err.println("Error: issued certificate cannot be verified. ");
                System.exit(-1);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
            System.err.println(usage);
            e.printStackTrace();
            System.exit(-1);
        }
        catch (IOException e) {
            if (e instanceof SocketException) {
                System.exit(-1);
            }
            e.printStackTrace();
            System.err.println(e);
            System.err.println(usage);
            System.exit(-1);
        }
        catch (NumberFormatException ex) {
            System.err.println("Can't convert '" + port + "' to a TCP port number");
            System.err.println(usage);
            System.exit(-1);
        }
        catch (NoSuchAlgorithmException ex) {
            System.err.printf("Can't find %s algorithm.", cipher);
            System.exit(-1);
        }
        catch (IllegalArgumentException ex) {
            System.err.println(ex.getMessage());
            System.exit(-1);
        }
        catch (NoSuchProviderException ex) {
            System.err.println(ex.getMessage());
            System.exit(-1);
        }
        catch (InvalidKeyException ex) {
            System.err.println(ex.getMessage());
            System.exit(-1);
        }
        catch (SignatureException ex) {
            // empty catch block
        }
    }
}

