/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemos.wp35.cdaclient;

import java.io.IOException;
import java.net.Socket;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.xtreemos.wp35.util.Utils;

public class PeerChecker
implements HandshakeCompletedListener {
    private String host = null;
    private PublicKey rootCAPublicKey = null;
    private TrustManager[] trustManagers = null;
    private Socket clientSocket = null;
    private PublicKey peerKey;
    boolean carryOnRegardless = true;
    private boolean ready = false;

    public PeerChecker(String host, PublicKey rootCAPublicKey, TrustManager[] trustManagers, boolean carryOnRegardless) {
        this.host = host;
        this.rootCAPublicKey = rootCAPublicKey;
        this.trustManagers = trustManagers;
        this.carryOnRegardless = carryOnRegardless;
    }

    public boolean isReady() {
        return this.ready;
    }

    public PublicKey getPeerKey() {
        return this.peerKey;
    }

    @Override
    public void handshakeCompleted(HandshakeCompletedEvent ev) {
        try {
            String peerDNSName;
            X509TrustManager x509TrustManager = (X509TrustManager)this.trustManagers[0];
            X509Certificate[] peerCerts = (X509Certificate[])ev.getPeerCertificates();
            assert (peerCerts != null) : "peerCerts[] is NULL";
            x509TrustManager.checkServerTrusted(peerCerts, "RSA");
            X509Certificate peerCert = peerCerts[0];
            this.peerKey = peerCert.getPublicKey();
            Collection<List<?>> subjectAltNames = peerCert.getSubjectAlternativeNames();
            if (null != subjectAltNames && !this.host.equals(peerDNSName = Utils.findSubjectAltName(subjectAltNames, 2))) {
                System.err.printf("Warning: certificate presented by remote host %s belongs to %s", this.host, peerDNSName);
                if (!this.carryOnRegardless) {
                    System.err.printf(" - exiting.\n", new Object[0]);
                    try {
                        this.clientSocket.close();
                        System.exit(0);
                    }
                    catch (IOException ex) {
                        System.exit(-1);
                    }
                } else {
                    System.err.printf(" - \ncarrying on as you requested to ignore CDA host certificates which don't belong to the CDA server you connected to.\nYou should only use any credentials issued for testing purposes.\n", new Object[0]);
                }
            }
            peerCert.checkValidity();
            try {
                peerCert.verify(this.rootCAPublicKey);
            }
            catch (SignatureException ex) {
                System.err.printf("Bad signature detected.\n", new Object[0]);
            }
            X509Principal issuer = PrincipalUtil.getSubjectX509Principal((X509Certificate)peerCert);
            peerCert.checkValidity();
            this.ready = true;
        }
        catch (CertificateParsingException ex) {
            System.err.println(ex);
        }
        catch (CertificateExpiredException ex) {
            System.err.println(ex);
            System.err.println("Closing socket");
            try {
                ev.getSocket().close();
            }
            catch (IOException ex1) {
                // empty catch block
            }
            System.exit(-1);
        }
        catch (CertificateNotYetValidException ex) {
            System.err.println(ex);
        }
        catch (SSLPeerUnverifiedException ex) {
            System.err.println("server unverified: " + ex.getMessage());
            try {
                ev.getSocket().close();
            }
            catch (IOException iOException) {}
        }
        catch (CertificateException ex) {
            System.err.printf("%s.\n", ex.getMessage());
            System.exit(-1);
        }
        catch (NoSuchAlgorithmException ex) {
            System.err.printf("%s.\n", ex.getMessage());
            System.exit(-1);
        }
        catch (InvalidKeyException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchProviderException ex) {
            ex.printStackTrace();
        }
    }
}

