/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemos.wp35.examples;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;

public class SignAndVerify {
    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PasswordFinder myPass = new PasswordFinder(){

            public char[] getPassword() {
                return "xtreemos".toCharArray();
            }
        };
        PEMReader reader = null;
        KeyPair keyPair = null;
        try {
            reader = new PEMReader((Reader)new InputStreamReader(new FileInputStream(args[0])), myPass);
            keyPair = (KeyPair)reader.readObject();
            reader.close();
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex);
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        byte[] data = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74};
        byte[] digitalSignature = SignAndVerify.signData(data, keyPair.getPrivate());
        boolean verified = SignAndVerify.verifySig(data, keyPair.getPublic(), digitalSignature);
        System.out.println(verified);
        keyPair = SignAndVerify.generateKeyPair(888L);
        verified = SignAndVerify.verifySig(data, keyPair.getPublic(), digitalSignature);
        System.out.println(verified);
    }

    public static byte[] signData(byte[] data, PrivateKey key) throws Exception {
        Signature signer = Signature.getInstance("SHA256WithRSAEncryption");
        signer.initSign(key);
        signer.update(data);
        return signer.sign();
    }

    public static boolean verifySig(byte[] data, PublicKey key, byte[] sig) throws Exception {
        Signature signer = Signature.getInstance("SHA256WithRSAEncryption");
        signer.initVerify(key);
        signer.update(data);
        return signer.verify(sig);
    }

    public static KeyPair generateKeyPair(long seed) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance("RSA");
        SecureRandom rng = SecureRandom.getInstance("SHA1PRNG", "SUN");
        rng.setSeed(seed);
        keyGenerator.initialize(1024, rng);
        return keyGenerator.generateKeyPair();
    }
}

