/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemos.wp35.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.xtreemos.wp35.VO;
import org.xtreemos.wp35.util.Utils;

public class CertificateProcessor {
    public static boolean verifyCertificate(X509Certificate cert, boolean verbose, PublicKey issuerPublicKey) {
        boolean verified = true;
        try {
            block11: {
                cert.checkValidity();
                try {
                    cert.verify(issuerPublicKey);
                }
                catch (Exception ex) {
                    verified = false;
                    if (!verbose) break block11;
                    System.err.println(ex.getMessage());
                }
            }
            String[] issuer = cert.getIssuerDN().getName().split(",");
            Properties p = new Properties();
            for (String s : issuer) {
                String[] kv = s.split("=");
                p.setProperty(kv[0], kv[1]);
            }
        }
        catch (CertificateExpiredException e) {
            if (verbose) {
                System.err.println(e.getMessage());
            }
            verified = false;
        }
        catch (CertificateNotYetValidException e) {
            if (verbose) {
                System.err.println(e.getMessage());
            }
            verified = false;
        }
        catch (CertificateException e) {
            if (verbose) {
                System.err.println(e.getMessage());
            }
            verified = false;
        }
        if (verified && verbose) {
            System.err.println("Certificate was signed with the private key corresponding to the received public key");
        }
        return verified;
    }

    public String getXosGlobalId(X509Certificate cert) {
        return cert.getSubjectDN().getName();
    }

    public static String getExtensionValue(byte[] value) {
        String retval = null;
        ASN1InputStream aIn = new ASN1InputStream(value);
        ASN1OctetString extnValue = null;
        try {
            extnValue = (ASN1OctetString)aIn.readObject();
            aIn = new ASN1InputStream(extnValue.getOctets());
            DERObject extensionType = aIn.readObject();
            DEROctetString derOS = null;
            DERBitString derB = null;
            DERSequence derSeq = null;
            if (extensionType instanceof DERBitString) {
                derB = (DERBitString)extensionType;
                byte[] b = derB.getBytes();
                System.err.printf("Length = %d\n", b.length);
                for (byte bb : b) {
                    System.err.printf("bb = %x\n", bb);
                }
                retval = new String(derB.getBytes());
            } else if (extensionType instanceof DERSequence) {
                derSeq = (DERSequence)extensionType;
            } else {
                derOS = (DEROctetString)extensionType;
                retval = new String(derOS.getOctets());
            }
        }
        catch (ClassCastException ex) {
            System.err.println(ex);
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        return retval;
    }

    public String getVOAttributeValue(X509Certificate cert, VO.Attribute attr) {
        byte[] extensionBytes = cert.getExtensionValue(attr.getOID());
        return CertificateProcessor.getExtensionValue(extensionBytes);
    }

    public void printCertificate(X509Certificate cert) throws IOException {
        int version = cert.getVersion();
        System.out.println("Version = " + version);
        try {
            cert.checkValidity();
        }
        catch (CertificateNotYetValidException e) {
            System.err.println("Certificate isn't valid yet");
        }
        catch (CertificateExpiredException e) {
            System.err.println("Certificate has expired");
        }
        BigInteger serial = cert.getSerialNumber();
        System.out.println("Serial = " + serial);
        Principal issuerDN = cert.getIssuerDN();
        System.out.println("issuerDN  = " + issuerDN);
        Principal subjectDN = cert.getSubjectDN();
        System.out.println("subjectDN = " + subjectDN);
        PublicKey publicKey = cert.getPublicKey();
        System.out.println(publicKey);
        Date notBefore = cert.getNotBefore();
        Date notAfter = cert.getNotAfter();
        System.out.println("Certificate is valid from " + notBefore + " to " + notAfter);
        Set<String> criticalOIDs = cert.getCriticalExtensionOIDs();
        for (String oid : criticalOIDs) {
            byte[] value = cert.getExtensionValue(oid);
            String derS = CertificateProcessor.getExtensionValue(value);
            System.err.printf("OID = %s, value(%d bytes) = %s.\n", oid, value.length, derS);
        }
        byte[] puExtn = cert.getExtensionValue(VO.Attribute.GlobalUserID.getOID());
        String puVal = CertificateProcessor.getExtensionValue(puExtn);
        System.err.printf("PrimaryUserName = %s.\n", puVal);
        System.err.printf("Attribute Name = %s, OID = %s.\n", new Object[]{VO.Attribute.GlobalPrimaryGroupName, VO.Attribute.GlobalPrimaryGroupName.getOID()});
        System.err.printf("Value of GlobalPrimaryVOName = %s.\n", new Object[]{VO.Attribute.valueOf("GlobalPrimaryVOName")});
        System.err.printf("OID of GlobalPrimaryVOName = %s.\n", VO.Attribute.valueOf("GlobalPrimaryVOName").getOID());
        String secondaryVONames = this.getVOAttributeValue(cert, VO.Attribute.GlobalSecondaryVONames);
        System.err.printf("Secondary VO Names are %s.\n", secondaryVONames);
        for (VO.Attribute a : VO.Attribute.values()) {
            String attrValue = this.getVOAttributeValue(cert, a);
            System.err.printf("Attr %s = %s.\n\n", new Object[]{a, attrValue});
        }
    }

    public void printPrivateKey(PrivateKey key) {
        System.out.println("Algorithm is " + key.getAlgorithm());
        System.out.println("Format is " + key.getFormat());
        RSAKey rsaKey = null;
        try {
            rsaKey = (RSAKey)((Object)key);
            System.out.println(rsaKey.getModulus());
        }
        catch (ClassCastException e) {
            System.err.println("Can't cast to RSA Private Key");
        }
        byte[] encoded = key.getEncoded();
        if (encoded != null) {
            System.out.println(encoded.toString());
        }
    }

    public static void main(String[] args) {
        CertificateProcessor cp = new CertificateProcessor();
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            InputStreamReader isr = new InputStreamReader(new FileInputStream(args[0]));
            X509Certificate cert = Utils.readCertificate(isr);
            cp.printCertificate(cert);
        }
        catch (Exception ex) {
            System.err.println(ex);
            ex.printStackTrace();
        }
    }
}

