/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemos.wp35.util;

import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.PasswordFinder;

public class Utils {
    protected static final String COMMA = ",";

    public static KeyPair generateKeyPair(String algorithm, int keylen) throws NoSuchAlgorithmException {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance(algorithm);
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        kpGen.initialize(keylen, random);
        return kpGen.generateKeyPair();
    }

    public static String buildValue(String[] values, String prefix) {
        String retval = null;
        StringBuilder sb = new StringBuilder();
        if (null != values) {
            if (values.length == 0) {
                retval = null;
            } else if (values.length == 1) {
                retval = values[0];
            } else {
                boolean first = true;
                for (String each : values) {
                    if (!first) {
                        sb.append(COMMA);
                    }
                    if (null == prefix) {
                        sb.append(each);
                    } else {
                        sb.append(prefix + each);
                    }
                    first = false;
                }
                retval = sb.toString();
            }
        }
        return retval;
    }

    public static char[] getPassphrase(Console console, int minLength) throws IllegalArgumentException {
        char[] password = null;
        char[] inpass = null;
        inpass = console.readPassword("Passphrase to protect private key (at least %d characters long): ", minLength);
        if (inpass == null || inpass.length < minLength) {
            throw new IllegalArgumentException("Passphrase is too short");
        }
        password = inpass;
        inpass = console.readPassword("%s", "Type passphrase again to confirm: ");
        if (inpass == null || inpass.length < minLength) {
            throw new IllegalArgumentException("Confirmation passphrase is too short");
        }
        if (!Arrays.equals(inpass, password)) {
            throw new IllegalArgumentException("Passphrases do not match");
        }
        return password;
    }

    public static String findSubjectAltName(Collection subjectAltNames, int nameType) {
        String subjectAltName;
        block0: {
            List item;
            Integer type;
            subjectAltName = null;
            Iterator i = subjectAltNames.iterator();
            if (!i.hasNext() || (type = (Integer)(item = (List)subjectAltNames.iterator().next()).get(0)) != nameType) break block0;
            subjectAltName = (String)item.get(1);
        }
        return subjectAltName;
    }

    public static X509Certificate readX509Certificate(String keyFilename, char[] password) throws FileNotFoundException, IOException {
        return (X509Certificate)Utils.readPEM(keyFilename, password, "X509Certificate");
    }

    public static KeyPair readKeyPair(String keyFilename, char[] password) throws FileNotFoundException, IOException {
        return (KeyPair)Utils.readPEM(keyFilename, password, "KeyPair");
    }

    public static Object readPEM(String keyFilename, char[] password, String type) throws FileNotFoundException, IOException {
        PEMReader reader = null;
        Object o = null;
        MyPassword myPass = new MyPassword(password);
        Arrays.fill(password, ' ');
        reader = new PEMReader((Reader)new InputStreamReader(new FileInputStream(keyFilename)), (PasswordFinder)myPass);
        o = reader.readObject();
        reader.close();
        return o;
    }

    public static X509Certificate readCertificate(InputStreamReader isr) throws IOException {
        return (X509Certificate)Utils.readPEM(isr);
    }

    public static Object readPEM(InputStreamReader isr) throws IOException {
        PEMReader preader = null;
        Object o = null;
        preader = new PEMReader((Reader)isr);
        o = preader.readObject();
        if (o == null) {
            throw new IOException("Read a NULL PEM Object");
        }
        return o;
    }

    public static void writeKey(OutputStream os, PrivateKey key, String alg, char[] password) {
        PEMWriter keyWriter = null;
        try {
            keyWriter = new PEMWriter((Writer)new OutputStreamWriter(os));
            keyWriter.writeObject((Object)key, alg, password, new SecureRandom());
            keyWriter.flush();
            keyWriter.close();
        }
        catch (IOException e) {
            System.err.println("writeKey" + e);
        }
    }

    public static void writeKey(OutputStream os, PrivateKey key) {
        PEMWriter keyWriter = null;
        try {
            keyWriter = new PEMWriter((Writer)new OutputStreamWriter(os));
            keyWriter.writeObject((Object)key);
            keyWriter.flush();
        }
        catch (IOException e) {
            System.err.println("writeKey" + e);
        }
    }

    public static void writeCertificate(OutputStreamWriter osw, X509Certificate cert) throws IOException {
        PEMWriter pemWriter = null;
        try {
            pemWriter = new PEMWriter((Writer)osw);
            pemWriter.writeObject((Object)cert);
            pemWriter.flush();
            pemWriter.close();
        }
        catch (IOException e) {
            System.err.println("writeCertificate" + e);
        }
    }

    public static KeyPair readPrivateKey(String keyFilename, final char[] keyPassphrase) throws IOException {
        PasswordFinder myPass = new PasswordFinder(){

            public char[] getPassword() {
                return keyPassphrase;
            }
        };
        KeyPair kp = null;
        try {
            File keyFile = new File(keyFilename);
            FileInputStream fin = new FileInputStream(keyFile);
            PEMReader reader = new PEMReader((Reader)new InputStreamReader(fin), myPass);
            kp = (KeyPair)reader.readObject();
            reader.close();
        }
        catch (FileNotFoundException ex) {
            System.err.printf("Can't open %s in Utils.readPrivateKey.\n", keyFilename);
            ex.printStackTrace();
        }
        return kp;
    }

    public static class MyPassword
    implements PasswordFinder {
        private char[] password;

        public MyPassword(char[] password) {
            this.password = password;
        }

        public char[] getPassword() {
            return this.password;
        }
    }
}

