/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;

public abstract class ASN1Sequence
extends ASN1Object {
    private Vector seq = new Vector();

    public static ASN1Sequence getInstance(Object object) {
        if (object == null || object instanceof ASN1Sequence) {
            return (ASN1Sequence)object;
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    public static ASN1Sequence getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        if (bl) {
            if (!aSN1TaggedObject.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return (ASN1Sequence)aSN1TaggedObject.getObject();
        }
        if (aSN1TaggedObject.isExplicit()) {
            if (aSN1TaggedObject instanceof BERTaggedObject) {
                return new BERSequence(aSN1TaggedObject.getObject());
            }
            return new DERSequence(aSN1TaggedObject.getObject());
        }
        if (aSN1TaggedObject.getObject() instanceof ASN1Sequence) {
            return (ASN1Sequence)aSN1TaggedObject.getObject();
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + aSN1TaggedObject.getClass().getName());
    }

    public Enumeration getObjects() {
        return this.seq.elements();
    }

    public ASN1SequenceParser parser() {
        final ASN1Sequence aSN1Sequence = this;
        return new ASN1SequenceParser(){
            private final int max;
            private int index;
            {
                this.max = ASN1Sequence.this.size();
            }

            @Override
            public DEREncodable readObject() throws IOException {
                DEREncodable dEREncodable;
                if (this.index == this.max) {
                    return null;
                }
                if ((dEREncodable = ASN1Sequence.this.getObjectAt(this.index++)) instanceof ASN1Sequence) {
                    return ((ASN1Sequence)dEREncodable).parser();
                }
                if (dEREncodable instanceof ASN1Set) {
                    return ((ASN1Set)dEREncodable).parser();
                }
                return dEREncodable;
            }

            @Override
            public DERObject getDERObject() {
                return aSN1Sequence;
            }
        };
    }

    public DEREncodable getObjectAt(int n) {
        return (DEREncodable)this.seq.elementAt(n);
    }

    public int size() {
        return this.seq.size();
    }

    @Override
    public int hashCode() {
        Enumeration enumeration = this.getObjects();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e == null) continue;
            n ^= e.hashCode();
        }
        return n;
    }

    @Override
    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof ASN1Sequence)) {
            return false;
        }
        ASN1Sequence aSN1Sequence = (ASN1Sequence)dERObject;
        if (this.size() != aSN1Sequence.size()) {
            return false;
        }
        Enumeration enumeration = this.getObjects();
        Enumeration enumeration2 = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            DERObject dERObject2;
            DERObject dERObject3 = ((DEREncodable)enumeration.nextElement()).getDERObject();
            if (dERObject3 == (dERObject2 = ((DEREncodable)enumeration2.nextElement()).getDERObject()) || dERObject3 != null && dERObject3.equals(dERObject2)) continue;
            return false;
        }
        return true;
    }

    protected void addObject(DEREncodable dEREncodable) {
        this.seq.addElement(dEREncodable);
    }

    @Override
    abstract void encode(DEROutputStream var1) throws IOException;

    public String toString() {
        return this.seq.toString();
    }
}

