/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb;

import java.io.IOException;
import org.xtreemfs.babudb.BabuDBImpl;
import org.xtreemfs.babudb.api.BabuDB;
import org.xtreemfs.babudb.api.StaticInitialization;
import org.xtreemfs.babudb.api.dev.BabuDBInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.config.BabuDBConfig;
import org.xtreemfs.babudb.conversion.AutoConverter;
import org.xtreemfs.babudb.plugin.PluginLoader;
import org.xtreemfs.foundation.logging.Logging;

public final class BabuDBFactory {
    public static final String BABUDB_VERSION = "0.5.6";
    public static final int BABUDB_DB_FORMAT_VERSION = 4;

    public static final BabuDB createBabuDB(BabuDBConfig configuration) throws BabuDBException {
        return BabuDBFactory.createBabuDB(configuration, null);
    }

    public static final BabuDB createBabuDB(BabuDBConfig configuration, StaticInitialization staticInit) throws BabuDBException {
        Logging.start((int)configuration.getDebugLevel(), (Logging.Category[])new Logging.Category[0]);
        BabuDBInternal babuDB = new BabuDBImpl(configuration);
        Logging.logMessage((int)6, (Object)babuDB, (String)"BabuDB %s", (Object[])new Object[]{BABUDB_VERSION});
        Logging.logMessage((int)6, (Object)babuDB, (String)"\n%s", (Object[])new Object[]{configuration.toString()});
        if (babuDB.getDBConfigFile().isConversionRequired()) {
            Logging.logMessage((int)4, (Logging.Category)Logging.Category.storage, (Object)babuDB, (String)"The database version is outdated. The database will be automatically converted to the latest version if possible. This may take some time, depending on the size.", (Object[])new Object[0]);
            AutoConverter.initiateConversion(babuDB.getDBConfigFile().getDBFormatVersion(), configuration);
        }
        try {
            babuDB = PluginLoader.init(babuDB);
        }
        catch (IOException e) {
            if (e.getMessage() == null) {
                Logging.logError((int)3, (Object)babuDB, (Throwable)e);
            }
            throw new BabuDBException(BabuDBException.ErrorCode.BROKEN_PLUGIN, e.getMessage(), e.getCause());
        }
        babuDB.init(staticInit);
        return babuDB;
    }
}

