/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xtreemfs.babudb.ResponseManagerImpl;
import org.xtreemfs.babudb.TransactionManagerImpl;
import org.xtreemfs.babudb.api.StaticInitialization;
import org.xtreemfs.babudb.api.dev.BabuDBInternal;
import org.xtreemfs.babudb.api.dev.CheckpointerInternal;
import org.xtreemfs.babudb.api.dev.DatabaseInternal;
import org.xtreemfs.babudb.api.dev.DatabaseManagerInternal;
import org.xtreemfs.babudb.api.dev.ResponseManagerInternal;
import org.xtreemfs.babudb.api.dev.SnapshotManagerInternal;
import org.xtreemfs.babudb.api.dev.transaction.InMemoryProcessing;
import org.xtreemfs.babudb.api.dev.transaction.OperationInternal;
import org.xtreemfs.babudb.api.dev.transaction.TransactionManagerInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.config.BabuDBConfig;
import org.xtreemfs.babudb.conversion.AutoConverter;
import org.xtreemfs.babudb.log.DiskLogIterator;
import org.xtreemfs.babudb.log.DiskLogger;
import org.xtreemfs.babudb.log.LogEntry;
import org.xtreemfs.babudb.lsmdb.CheckpointerImpl;
import org.xtreemfs.babudb.lsmdb.DBConfig;
import org.xtreemfs.babudb.lsmdb.DatabaseManagerImpl;
import org.xtreemfs.babudb.lsmdb.LSMDBWorker;
import org.xtreemfs.babudb.lsmdb.LSMDatabase;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.snapshots.SnapshotManagerImpl;
import org.xtreemfs.foundation.LifeCycleListener;
import org.xtreemfs.foundation.LifeCycleThread;
import org.xtreemfs.foundation.VersionManagement;
import org.xtreemfs.foundation.logging.Logging;

public class BabuDBImpl
implements BabuDBInternal {
    private LSMDBWorker[] worker;
    private DiskLogger logger;
    private TransactionManagerInternal txnMan;
    private final CheckpointerInternal dbCheckptr;
    private final SnapshotManagerInternal snapshotManager;
    private final DatabaseManagerInternal databaseManager;
    private final ResponseManagerImpl responseManager;
    private final BabuDBConfig configuration;
    private final DBConfig dbConfigFile;
    private final AtomicBoolean stopped = new AtomicBoolean(true);
    private final List<LifeCycleThread> plugins = new Vector<LifeCycleThread>();

    BabuDBImpl(BabuDBConfig configuration) throws BabuDBException {
        this.configuration = configuration;
        this.responseManager = new ResponseManagerImpl(configuration.getMaxQueueLength());
        this.txnMan = new TransactionManagerImpl(configuration.getSyncMode().equals((Object)DiskLogger.SyncMode.ASYNC));
        this.databaseManager = new DatabaseManagerImpl(this);
        this.dbConfigFile = new DBConfig(this);
        this.snapshotManager = new SnapshotManagerImpl(this);
        this.dbCheckptr = new CheckpointerImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(StaticInitialization staticInit) throws BabuDBException {
        AtomicBoolean atomicBoolean = this.stopped;
        synchronized (atomicBoolean) {
            this.responseManager.setLifeCycleListener(this);
            this.responseManager.start();
            this.snapshotManager.init();
            LSN dbLsn = null;
            for (DatabaseInternal db : this.databaseManager.getDatabaseList()) {
                LSN onDiskLSN = db.getLSMDB().getOndiskLSN();
                if (LSMDatabase.NO_DB_LSN.equals(onDiskLSN) || dbLsn != null && dbLsn.compareTo(onDiskLSN) <= 0) continue;
                dbLsn = onDiskLSN;
            }
            dbLsn = dbLsn == null ? LSMDatabase.NO_DB_LSN : new LSN(dbLsn.getViewId() == 0 ? 1 : dbLsn.getViewId(), dbLsn.getSequenceNo() + 1L);
            Logging.logMessage((int)6, (Object)this, (String)"starting log replay at LSN %s", (Object[])new Object[]{dbLsn});
            LSN nextLSN = this.replayLogs(dbLsn);
            if (dbLsn.compareTo(nextLSN) > 0) {
                nextLSN = dbLsn;
            }
            Logging.logMessage((int)6, (Object)this, (String)("log replay done, using LSN: " + nextLSN), (Object[])new Object[0]);
            try {
                this.logger = new DiskLogger(this.configuration.getDbLogDir(), nextLSN, this.configuration.getSyncMode(), this.configuration.getPseudoSyncWait(), this.configuration.getMaxQueueLength() * Math.max(1, this.configuration.getNumThreads()));
                this.logger.setLifeCycleListener(this);
                this.logger.start();
                this.logger.waitForStartup();
            }
            catch (Exception ex) {
                throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "cannot start database operations logger", ex);
            }
            this.txnMan.init(new LSN(nextLSN.getViewId(), nextLSN.getSequenceNo() - 1L));
            this.txnMan.setLogger(this.logger);
            if (this.configuration.getNumThreads() > 0) {
                this.worker = new LSMDBWorker[this.configuration.getNumThreads()];
                for (int i = 0; i < this.configuration.getNumThreads(); ++i) {
                    this.worker[i] = new LSMDBWorker(this, i, this.configuration.getMaxQueueLength());
                    this.worker[i].start();
                }
            } else {
                assert (this.configuration.getNumThreads() == 0);
                this.worker = null;
            }
            if (this.dbConfigFile.isConversionRequired()) {
                AutoConverter.completeConversion(this);
            }
            this.dbCheckptr.init(this.logger, this.configuration.getCheckInterval(), this.configuration.getMaxLogfileSize());
            LSN firstLSN = new LSN(1, 1L);
            if (staticInit != null && nextLSN.equals(firstLSN)) {
                Logging.logMessage((int)7, (Object)this, (String)"Running initialization script...", (Object[])new Object[0]);
                staticInit.initialize(this.databaseManager, this.snapshotManager);
                Logging.logMessage((int)7, (Object)this, (String)"... initialization script finished successfully.", (Object[])new Object[0]);
            } else if (staticInit != null) {
                Logging.logMessage((int)6, (Object)this, (String)"Static initialization was ignored, because database is not empty.", (Object[])new Object[0]);
            }
            this.stopped.set(false);
            Logging.logMessage((int)6, (Object)this, (String)"BabuDB for Java is running (version 0.5.6)", (Object[])new Object[0]);
        }
    }

    @Override
    public void addPluginThread(LifeCycleThread plugin) {
        plugin.setLifeCycleListener((LifeCycleListener)this);
        this.plugins.add(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        AtomicBoolean atomicBoolean = this.stopped;
        synchronized (atomicBoolean) {
            if (this.stopped.get()) {
                return;
            }
            if (this.worker != null) {
                for (LSMDBWorker w : this.worker) {
                    w.shutdown();
                }
            }
            try {
                this.dbCheckptr.suspendCheckpointing();
                this.logger.shutdown();
                this.logger.waitForShutdown();
                this.txnMan.setLogger(null);
                if (this.worker != null) {
                    for (LSMDBWorker w : this.worker) {
                        w.waitForShutdown();
                    }
                }
            }
            catch (Exception ex) {
                Logging.logMessage((int)3, (Object)this, (String)"BabuDB could not be stopped, because '%s'.", (Object[])new Object[]{ex.getMessage()});
                Logging.logError((int)3, (Object)this, (Throwable)ex);
            }
            this.stopped.set(true);
            Logging.logMessage((int)6, (Object)this, (String)"BabuDB has been stopped.", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LSN restart() throws BabuDBException {
        AtomicBoolean atomicBoolean = this.stopped;
        synchronized (atomicBoolean) {
            if (!this.stopped.get()) {
                throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "BabuDB has to be stopped before!");
            }
            this.databaseManager.reset();
            LSN dbLsn = null;
            for (DatabaseInternal db : this.databaseManager.getDatabaseList()) {
                if (dbLsn == null) {
                    dbLsn = db.getLSMDB().getOndiskLSN();
                    continue;
                }
                LSN onDiskLSN = db.getLSMDB().getOndiskLSN();
                if (LSMDatabase.NO_DB_LSN.equals(dbLsn) || LSMDatabase.NO_DB_LSN.equals(onDiskLSN)) continue;
                dbLsn = dbLsn.compareTo(onDiskLSN) < 0 ? dbLsn : onDiskLSN;
            }
            dbLsn = dbLsn == null ? new LSN(0, 0L) : new LSN(dbLsn.getViewId(), dbLsn.getSequenceNo() + 1L);
            Logging.logMessage((int)6, (Object)this, (String)"starting log replay", (Object[])new Object[0]);
            LSN nextLSN = this.replayLogs(dbLsn);
            if (dbLsn.compareTo(nextLSN) > 0) {
                nextLSN = dbLsn;
            }
            Logging.logMessage((int)6, (Object)this, (String)("log replay done, using LSN: " + nextLSN), (Object[])new Object[0]);
            try {
                this.logger = new DiskLogger(this.configuration.getDbLogDir(), nextLSN, this.configuration.getSyncMode(), this.configuration.getPseudoSyncWait(), this.configuration.getMaxQueueLength() * this.configuration.getNumThreads());
                this.logger.setLifeCycleListener(this);
                this.logger.start();
                this.logger.waitForStartup();
            }
            catch (Exception ex) {
                throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "Cannot start database operations logger!", ex);
            }
            this.txnMan.init(new LSN(nextLSN.getViewId(), nextLSN.getSequenceNo() - 1L));
            this.txnMan.setLogger(this.logger);
            if (this.configuration.getNumThreads() > 0) {
                this.worker = new LSMDBWorker[this.configuration.getNumThreads()];
                for (int i = 0; i < this.configuration.getNumThreads(); ++i) {
                    this.worker[i] = new LSMDBWorker(this, i, this.configuration.getMaxQueueLength());
                    this.worker[i].start();
                }
            } else {
                assert (this.configuration.getNumThreads() == 0);
                this.worker = null;
            }
            this.dbCheckptr.init(this.logger, this.configuration.getCheckInterval(), this.configuration.getMaxLogfileSize());
            Logging.logMessage((int)6, (Object)this, (String)"BabuDB for Java is running (version 0.5.6)", (Object[])new Object[0]);
            this.stopped.set(false);
            return new LSN(nextLSN.getViewId(), nextLSN.getSequenceNo() - 1L);
        }
    }

    @Override
    public void shutdown() throws BabuDBException {
        this.shutdown(true);
    }

    @Override
    public void shutdown(boolean graceful) throws BabuDBException {
        Logging.logMessage((int)6, (Object)this, (String)"shutting down ...", (Object[])new Object[0]);
        if (this.worker != null) {
            for (LSMDBWorker w : this.worker) {
                w.shutdown(graceful);
            }
        }
        BabuDBException exc = null;
        for (LifeCycleThread p : this.plugins) {
            try {
                p.shutdown();
                p.waitForShutdown();
            }
            catch (Exception e) {
                if (exc != null) continue;
                exc = new BabuDBException(BabuDBException.ErrorCode.BROKEN_PLUGIN, e.getMessage(), e.getCause());
            }
        }
        try {
            this.logger.shutdown(graceful);
        }
        catch (Exception e) {
            Logging.logError((int)7, (Object)this, (Throwable)e);
        }
        try {
            this.dbCheckptr.shutdown();
            this.dbCheckptr.waitForShutdown();
        }
        catch (Exception e) {
            Logging.logError((int)7, (Object)this, (Throwable)e);
        }
        try {
            this.databaseManager.shutdown();
            this.snapshotManager.shutdown();
        }
        catch (Exception e) {
            Logging.logError((int)7, (Object)this, (Throwable)e);
        }
        if (this.worker != null) {
            for (LSMDBWorker w : this.worker) {
                try {
                    w.waitForShutdown();
                }
                catch (Exception e) {
                    Logging.logError((int)7, (Object)this, (Throwable)e);
                }
            }
            Logging.logMessage((int)7, (Object)this, (String)"%d worker threads shut down successfully", (Object[])new Object[]{this.worker.length});
        }
        try {
            this.responseManager.shutdown();
        }
        catch (Exception e) {
            throw new BabuDBException(BabuDBException.ErrorCode.INTERRUPTED, e.getMessage(), e);
        }
        if (exc != null) {
            throw exc;
        }
        Logging.logMessage((int)6, (Object)this, (String)"BabuDB shutdown complete.", (Object[])new Object[0]);
    }

    public void __test_killDB_dangerous() {
        try {
            this.logger.destroy();
            if (this.worker != null) {
                for (LSMDBWorker w : this.worker) {
                    w.stop();
                }
            }
            this.dbCheckptr.shutdown();
            this.databaseManager.shutdown();
            this.snapshotManager.shutdown();
            this.responseManager.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public CheckpointerInternal getCheckpointer() {
        return this.dbCheckptr;
    }

    @Override
    public void replaceTransactionManager(TransactionManagerInternal txnMan) {
        this.txnMan = txnMan;
    }

    @Override
    public TransactionManagerInternal getTransactionManager() {
        return this.txnMan;
    }

    @Override
    public DatabaseManagerInternal getDatabaseManager() {
        return this.databaseManager;
    }

    @Override
    public BabuDBConfig getConfig() {
        return this.configuration;
    }

    @Override
    public Object getRuntimeState(String property) {
        if (property.startsWith("checkpointer")) {
            return this.dbCheckptr.getRuntimeState(property);
        }
        if (property.startsWith("databaseManager")) {
            return this.databaseManager.getRuntimeState(property);
        }
        if (property.startsWith("diskLogger")) {
            return this.logger.getRuntimeState(property);
        }
        return null;
    }

    @Override
    public Map<String, Object> getRuntimeState() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.putAll(this.dbCheckptr.getRuntimeState());
        info.putAll(this.databaseManager.getRuntimeState());
        info.putAll(this.logger.getRuntimeState());
        return info;
    }

    @Override
    public SnapshotManagerInternal getSnapshotManager() {
        return this.snapshotManager;
    }

    @Override
    public ResponseManagerInternal getResponseManager() {
        return this.responseManager;
    }

    @Override
    public DBConfig getDBConfigFile() {
        return this.dbConfigFile;
    }

    @Override
    public int getWorkerCount() {
        if (this.worker == null) {
            return 0;
        }
        return this.worker.length;
    }

    @Override
    public LSMDBWorker getWorker(int dbId) {
        if (this.worker == null) {
            return null;
        }
        return this.worker[dbId % this.worker.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LSN replayLogs(LSN from) throws BabuDBException {
        try {
            File f = new File(this.configuration.getDbLogDir());
            File[] logFiles = f.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".dbl");
                }
            });
            DiskLogIterator it = new DiskLogIterator(logFiles, from);
            LSN nextLSN = null;
            while (it.hasNext()) {
                LogEntry le = null;
                try {
                    block13: {
                        le = it.next();
                        byte type = le.getPayloadType();
                        Logging.logMessage((int)7, (Object)this, (String)"Reading entry LSN(%s) of type (%d) with %d bytes payload from log.", (Object[])new Object[]{le.getLSN().toString(), (int)type, le.getPayload().remaining()});
                        if (type == 6) {
                            this.txnMan.replayTransaction(le);
                        } else if (type != 2 && type != 3 && type != 4) {
                            InMemoryProcessing processingLogic = this.txnMan.getProcessingLogic().get(type);
                            OperationInternal operation = processingLogic.convertToOperation(processingLogic.deserializeRequest(le.getPayload()));
                            try {
                                processingLogic.process(operation);
                            }
                            catch (BabuDBException be) {
                                if (type == 1 && (be.getErrorCode() == BabuDBException.ErrorCode.SNAP_EXISTS || be.getErrorCode() == BabuDBException.ErrorCode.NO_SUCH_DB) || type == 5 && be.getErrorCode() == BabuDBException.ErrorCode.NO_SUCH_SNAPSHOT || type == 0 && be.getErrorCode().equals((Object)BabuDBException.ErrorCode.NO_SUCH_DB)) break block13;
                                throw be;
                            }
                        }
                    }
                    nextLSN = new LSN(le.getViewId(), le.getLogSequenceNo() + 1L);
                }
                finally {
                    if (le == null) continue;
                    le.free();
                }
            }
            it.destroy();
            if (nextLSN != null) {
                return nextLSN;
            }
            return new LSN(1, 1L);
        }
        catch (IOException ex) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "cannot load database operations log, file might be corrupted", ex);
        }
        catch (Exception ex) {
            Logging.logError((int)3, (Object)this, (Throwable)ex);
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "corrupted/incomplete log entry in database operations log", ex);
        }
    }

    public void startupPerformed() {
        Logging.logMessage((int)6, (Object)this, (String)"has been successfully started.", (Object[])new Object[0]);
    }

    public void shutdownPerformed() {
        Logging.logMessage((int)6, (Object)this, (String)"has been successfully stopped.", (Object[])new Object[0]);
    }

    public void crashPerformed(Throwable cause) {
        Logging.logError((int)3, (Object)this, (Throwable)cause);
        try {
            this.shutdown();
        }
        catch (BabuDBException e) {
            Logging.logMessage((int)4, (Object)this, (String)"BabuDB could not have been terminated gracefully after plugin crash. Because: %s", (Object[])new Object[]{e.getMessage()});
            e.printStackTrace();
        }
    }

    static {
        int requiredFoundationVersion = 2;
        if (VersionManagement.getFoundationVersion() != 2L) {
            throw new Error("Foundation.jar in classpath is required in version 2; present version is " + VersionManagement.getFoundationVersion());
        }
    }
}

