/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb;

import java.util.concurrent.atomic.AtomicBoolean;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.database.DatabaseRequestResult;
import org.xtreemfs.babudb.api.dev.ResponseManagerInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.foundation.logging.Logging;

public class BabuDBRequestResultImpl<T>
implements DatabaseRequestResult<T> {
    private final ResponseManagerInternal respMan;
    private DatabaseRequestListener<T> listener;
    private T result;
    private BabuDBException error;
    private final AtomicBoolean finished = new AtomicBoolean(false);
    protected final Object context;
    private LSN assignedLSN = null;

    public BabuDBRequestResultImpl(ResponseManagerInternal respMan) {
        this(null, respMan);
    }

    public BabuDBRequestResultImpl(Object context, ResponseManagerInternal respMan) {
        assert (respMan != null);
        this.context = context;
        this.respMan = respMan;
    }

    public LSN getAssignedLSN() {
        return this.assignedLSN;
    }

    public void finished(LSN lsn) {
        this.finished(null, null, lsn);
    }

    public void finished(T result) {
        this.finished(result, null, null);
    }

    public void finished(T result, LSN lsn) {
        this.finished(result, null, lsn);
    }

    public void failed(BabuDBException error) {
        this.finished(null, error, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finished(T result, BabuDBException error, LSN lsn) {
        assert (result == null || error == null) : "Results are not permitted on error!";
        this.error = error;
        this.result = result;
        this.assignedLSN = lsn;
        AtomicBoolean atomicBoolean = this.finished;
        synchronized (atomicBoolean) {
            boolean check = this.finished.compareAndSet(false, true);
            assert (check) : "The request was already finished!";
            this.finished.notifyAll();
        }
        if (this.listener != null) {
            try {
                this.respMan.enqueueResponse(this.listener, error, result, this.context);
            }
            catch (InterruptedException e) {
                Logging.logError((int)3, (Object)this, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(DatabaseRequestListener<T> listener) {
        AtomicBoolean atomicBoolean = this.finished;
        synchronized (atomicBoolean) {
            assert (this.listener == null) : "There is already a listener registered!";
            if (this.finished.get()) {
                if (this.error == null) {
                    listener.finished(this.result, this.context);
                } else {
                    listener.failed(this.error, this.context);
                }
            } else {
                this.listener = listener;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws BabuDBException {
        try {
            AtomicBoolean atomicBoolean = this.finished;
            synchronized (atomicBoolean) {
                if (!this.finished.get()) {
                    this.finished.wait();
                }
            }
        }
        catch (InterruptedException e) {
            throw new BabuDBException(BabuDBException.ErrorCode.INTERRUPTED, "Thread was interrupted while waiting for the response.");
        }
        if (this.error != null) {
            throw this.error;
        }
        return this.result;
    }
}

