/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.dev.ResponseManagerInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;

public class ResponseManagerImpl
extends ResponseManagerInternal {
    private final BlockingQueue<ResponseRecord<?>> queue;
    private boolean quit = true;

    public ResponseManagerImpl(int max_Q) {
        this.queue = max_Q > 0 ? new LinkedBlockingQueue(max_Q) : new LinkedBlockingQueue();
    }

    @Override
    public <T> void enqueueResponse(DatabaseRequestListener<T> listener, BabuDBException error, T result, Object context) throws InterruptedException {
        assert (result == null || error == null && result != error);
        this.queue.put(new ResponseRecord(listener, error, result, context));
    }

    public synchronized void start() {
        this.quit = false;
        super.start();
    }

    public synchronized void shutdown() throws Exception {
        this.quit = true;
        this.interrupt();
    }

    public void run() {
        ResponseRecord<?> respRec = null;
        this.notifyStarted();
        while (!this.quit) {
            try {
                respRec = this.queue.take();
                if (((ResponseRecord)respRec).error == null) {
                    ((ResponseRecord)respRec).listener.finished(((ResponseRecord)respRec).result, ((ResponseRecord)respRec).context);
                    continue;
                }
                ((ResponseRecord)respRec).listener.failed(((ResponseRecord)respRec).error, ((ResponseRecord)respRec).context);
            }
            catch (InterruptedException e) {
                if (this.quit) continue;
                this.notifyCrashed(e);
            }
        }
        this.notifyStopped();
    }

    private static final class ResponseRecord<T> {
        private final DatabaseRequestListener<T> listener;
        private final BabuDBException error;
        private final Object context;
        private final T result;

        private ResponseRecord(DatabaseRequestListener<T> listener, BabuDBException error, T result, Object context) {
            this.listener = listener;
            this.error = error;
            this.result = result;
            this.context = context;
        }
    }
}

