/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.xtreemfs.babudb.BabuDBRequestResultImpl;
import org.xtreemfs.babudb.api.dev.transaction.InMemoryProcessing;
import org.xtreemfs.babudb.api.dev.transaction.OperationInternal;
import org.xtreemfs.babudb.api.dev.transaction.TransactionInternal;
import org.xtreemfs.babudb.api.dev.transaction.TransactionManagerInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.api.transaction.TransactionListener;
import org.xtreemfs.babudb.log.DiskLogger;
import org.xtreemfs.babudb.log.LogEntry;
import org.xtreemfs.babudb.log.SyncListener;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;

class TransactionManagerImpl
extends TransactionManagerInternal {
    private final AtomicReference<DiskLogger> diskLogger = new AtomicReference<Object>(null);
    private final List<TransactionListener> listeners = new LinkedList<TransactionListener>();
    private volatile LSN latestOnDisk;
    private final boolean isAsync;

    public TransactionManagerImpl(boolean isAsync) {
        this.isAsync = isAsync;
    }

    @Override
    public void init(LSN initial) {
        this.latestOnDisk = initial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLogger(DiskLogger logger) {
        AtomicReference<DiskLogger> atomicReference = this.diskLogger;
        synchronized (atomicReference) {
            DiskLogger old = this.diskLogger.getAndSet(logger);
            if (logger == null) {
                this.latestOnDisk = old.getLatestLSN();
            } else {
                this.diskLogger.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makePersistent(TransactionInternal txn, ReusableBuffer payload, BabuDBRequestResultImpl<Object> future) throws BabuDBException {
        Logging.logMessage((int)7, (Object)this, (String)"Trying to perform transaction %s ...", (Object[])new Object[]{txn.toString()});
        try {
            Object[] result = this.inMemory(txn, payload);
            LogEntry entry = this.generateLogEntry(txn, payload, future, result);
            this.onDisk(txn, entry);
            if (this.isAsync) {
                future.finished(result, null);
                for (TransactionListener l : this.listeners) {
                    l.transactionPerformed(txn);
                }
            }
        }
        finally {
            txn.unlockWorkers();
        }
    }

    private final LogEntry generateLogEntry(final TransactionInternal txn, ReusableBuffer payload, final BabuDBRequestResultImpl<Object> listener, final Object[] results) {
        LogEntry result = new LogEntry(payload, new SyncListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void synced(LSN lsn) {
                block12: {
                    try {
                        if (TransactionManagerImpl.this.isAsync) break block12;
                        BabuDBException irregs = txn.getIrregularities();
                        if (irregs == null) {
                            listener.finished(results, lsn);
                            break block12;
                        }
                        throw new BabuDBException(irregs.getErrorCode(), "Transaction failed at the execution of the " + (txn.size() + 1) + "th operation, because: " + irregs.getMessage(), irregs);
                    }
                    catch (BabuDBException error) {
                        block13: {
                            try {
                                if (!TransactionManagerImpl.this.isAsync) {
                                    listener.failed(error);
                                    break block13;
                                }
                                Logging.logError((int)4, (Object)this, (Throwable)error);
                            }
                            catch (Throwable throwable) {
                                Logging.logMessage((int)7, (Object)this, (String)"... transaction %s finished.", (Object[])new Object[]{txn.toString()});
                                if (!TransactionManagerImpl.this.isAsync) {
                                    for (TransactionListener l : TransactionManagerImpl.this.listeners) {
                                        l.transactionPerformed(txn);
                                    }
                                }
                                throw throwable;
                            }
                        }
                        Logging.logMessage((int)7, (Object)this, (String)"... transaction %s finished.", (Object[])new Object[]{txn.toString()});
                        if (!TransactionManagerImpl.this.isAsync) {
                            for (TransactionListener l : TransactionManagerImpl.this.listeners) {
                                l.transactionPerformed(txn);
                            }
                        }
                    }
                }
                Logging.logMessage((int)7, (Object)this, (String)"... transaction %s finished.", (Object[])new Object[]{txn.toString()});
                if (!TransactionManagerImpl.this.isAsync) {
                    for (TransactionListener l : TransactionManagerImpl.this.listeners) {
                        l.transactionPerformed(txn);
                    }
                }
            }

            @Override
            public void failed(Exception ex) {
                if (!TransactionManagerImpl.this.isAsync) {
                    listener.failed(ex != null && ex instanceof BabuDBException ? (BabuDBException)ex : new BabuDBException(BabuDBException.ErrorCode.INTERNAL_ERROR, ex.getMessage()));
                }
            }
        }, 6);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onDisk(TransactionInternal txn, LogEntry entry) throws BabuDBException {
        try {
            AtomicReference<DiskLogger> atomicReference = this.diskLogger;
            synchronized (atomicReference) {
                while (this.diskLogger.get() == null) {
                    this.diskLogger.wait();
                }
                this.diskLogger.get().append(entry);
            }
        }
        catch (InterruptedException ie) {
            if (entry != null) {
                entry.free();
            }
            throw new BabuDBException(BabuDBException.ErrorCode.INTERRUPTED, "Operation could not have been stored persistent to disk and will therefore be discarded.", ie.getCause());
        }
    }

    private final Object[] inMemory(TransactionInternal txn, ReusableBuffer payload) throws BabuDBException {
        ArrayList<Object> operationResults = new ArrayList<Object>();
        for (int i = 0; i < txn.size(); ++i) {
            try {
                OperationInternal operation = (OperationInternal)txn.get(i);
                txn.lockResponsibleWorker(operation.getDatabaseName());
                operationResults.add(((InMemoryProcessing)this.inMemoryProcessing.get(operation.getType())).process(operation));
                continue;
            }
            catch (BabuDBException be) {
                if (i > 0) {
                    txn.cutOfAt(i, be);
                    try {
                        payload.shrink(txn.getSize());
                        break;
                    }
                    catch (IOException ioe) {
                        BufferPool.free((ReusableBuffer)payload);
                        throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, ioe.getMessage(), ioe);
                    }
                }
                BufferPool.free((ReusableBuffer)payload);
                throw be;
            }
        }
        return operationResults.toArray();
    }

    @Override
    public void replayTransaction(TransactionInternal txn) throws BabuDBException {
        for (OperationInternal operation : txn) {
            byte type = operation.getType();
            if (type == 3 || type == 2 || type == 4) continue;
            InMemoryProcessing processing = (InMemoryProcessing)this.inMemoryProcessing.get(type);
            try {
                processing.process(operation);
            }
            catch (BabuDBException be) {
                if (type == 1 && (be.getErrorCode() == BabuDBException.ErrorCode.SNAP_EXISTS || be.getErrorCode() == BabuDBException.ErrorCode.NO_SUCH_DB) || type == 5 && be.getErrorCode() == BabuDBException.ErrorCode.NO_SUCH_SNAPSHOT || type == 0 && be.getErrorCode().equals((Object)BabuDBException.ErrorCode.NO_SUCH_DB)) continue;
                throw be;
            }
        }
    }

    @Override
    public void lockService() throws InterruptedException {
        DiskLogger logger = this.diskLogger.get();
        if (logger != null) {
            logger.lock();
        }
    }

    @Override
    public void unlockService() {
        DiskLogger logger = this.diskLogger.get();
        if (logger != null && logger.hasLock()) {
            logger.unlock();
        }
    }

    @Override
    public LSN getLatestOnDiskLSN() {
        DiskLogger logger = this.diskLogger.get();
        if (logger != null) {
            return logger.getLatestLSN();
        }
        return this.latestOnDisk;
    }

    @Override
    public void addTransactionListener(TransactionListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeTransactionListener(TransactionListener listener) {
        this.listeners.remove(listener);
    }
}

