/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.api.dev.plugin;

import java.io.IOException;
import org.xtreemfs.babudb.api.dev.BabuDBInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;

public abstract class PluginMain {
    private static final char VERSION_PART_DELIMITER = '.';
    private static final char VERSION_RANGE_DELIMITER = '-';

    public abstract String compatibleBabuDBVersion();

    public abstract BabuDBInternal start(BabuDBInternal var1, String var2) throws BabuDBException;

    public abstract String[] getDependencies(String var1) throws IOException;

    public final BabuDBInternal execute(BabuDBInternal babuDB, String configPath) throws BabuDBException {
        String[] comp = this.compatibleBabuDBVersion().split("\\-");
        String[] f = comp[0].split("\\.");
        int[] from = new int[]{Integer.parseInt(f[0]), Integer.parseInt(f[1]), Integer.parseInt(f[2])};
        String[] t = comp[1].split("\\.");
        int[] to = new int[]{Integer.parseInt(t[0]), Integer.parseInt(t[1]), Integer.parseInt(t[2])};
        String[] b = "0.5.6".split("\\.");
        int[] babu = new int[]{Integer.parseInt(b[0]), Integer.parseInt(b[1]), Integer.parseInt(b[2])};
        for (int i = 0; i < 3; ++i) {
            if (babu[i] <= to[i] && babu[i] >= from[i]) continue;
            throw new BabuDBException(BabuDBException.ErrorCode.BROKEN_PLUGIN, "This BabuDB (0.5.6) is not compatible with this plugin (" + this.getClass().getName() + "), which requires " + "BabuDB to meet " + this.compatibleBabuDBVersion());
        }
        return this.start(babuDB, configPath);
    }

    public static String buildCompatibleVersionString(int from0, int from1, int from2, int to0, int to1, int to2) {
        return "" + from0 + '.' + from1 + '.' + from2 + '-' + to0 + '.' + to1 + '.' + to2;
    }
}

