/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.api.dev.transaction;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xtreemfs.babudb.api.database.DatabaseRequestResult;
import org.xtreemfs.babudb.api.dev.transaction.OperationInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.api.index.ByteRangeComparator;
import org.xtreemfs.babudb.api.transaction.Operation;
import org.xtreemfs.babudb.api.transaction.Transaction;
import org.xtreemfs.babudb.lsmdb.BabuDBTransaction;
import org.xtreemfs.babudb.lsmdb.InsertRecordGroup;
import org.xtreemfs.babudb.lsmdb.LSMDatabase;
import org.xtreemfs.babudb.snapshots.SnapshotConfig;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;

public abstract class TransactionInternal
extends LinkedList<OperationInternal>
implements Transaction,
Iterable<OperationInternal> {
    private static final long serialVersionUID = 1383031301195486005L;
    private Map<String, DatabaseRequestResult<AtomicBoolean>> databaseLockFutureMap = null;

    @Override
    public abstract TransactionInternal createSnapshot(String var1, SnapshotConfig var2);

    @Override
    public abstract TransactionInternal deleteSnapshot(String var1, String var2);

    @Override
    public abstract TransactionInternal createDatabase(String var1, int var2);

    @Override
    public abstract TransactionInternal createDatabase(String var1, int var2, ByteRangeComparator[] var3);

    @Override
    public abstract TransactionInternal copyDatabase(String var1, String var2);

    @Override
    public abstract TransactionInternal deleteDatabase(String var1);

    @Override
    public abstract TransactionInternal insertRecord(String var1, int var2, byte[] var3, byte[] var4);

    @Override
    public abstract TransactionInternal deleteRecord(String var1, int var2, byte[] var3);

    @Override
    public abstract String toString();

    public final byte aggregateOperationTypes() {
        byte result = 0;
        for (Operation op : this) {
            result = (byte)(result | 1 << op.getType());
        }
        return result;
    }

    public final Set<String> databasesAffected() {
        HashSet<String> result = new HashSet<String>();
        for (Operation op : this) {
            result.add(op.getDatabaseName());
        }
        return result;
    }

    public final synchronized void updateWorkerLocks(Map<String, DatabaseRequestResult<AtomicBoolean>> databaseLockFutureMap) {
        this.databaseLockFutureMap = databaseLockFutureMap;
    }

    public final synchronized void lockResponsibleWorker(String databaseName) throws BabuDBException {
        DatabaseRequestResult<AtomicBoolean> lockFuture;
        if (this.databaseLockFutureMap != null && (lockFuture = this.databaseLockFutureMap.get(databaseName)) != null) {
            lockFuture.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void unlockWorkers() {
        if (this.databaseLockFutureMap != null) {
            HashSet<DatabaseRequestResult<AtomicBoolean>> lockFutures = new HashSet<DatabaseRequestResult<AtomicBoolean>>(this.databaseLockFutureMap.values());
            for (DatabaseRequestResult databaseRequestResult : lockFutures) {
                try {
                    AtomicBoolean workerLock;
                    AtomicBoolean atomicBoolean = workerLock = (AtomicBoolean)databaseRequestResult.get();
                    synchronized (atomicBoolean) {
                        workerLock.set(false);
                        workerLock.notify();
                    }
                }
                catch (BabuDBException be) {
                    Logging.logMessage((int)7, (Object)this, (String)"The worker lock could not have been acquired for unlock.", (Object[])new Object[0]);
                }
            }
        }
    }

    public static final boolean containsOperationType(byte aggregate, byte type) {
        return (aggregate >>> type & 1) == 1;
    }

    public abstract TransactionInternal insertRecordGroup(String var1, InsertRecordGroup var2);

    public abstract TransactionInternal insertRecordGroup(String var1, InsertRecordGroup var2, LSMDatabase var3);

    public abstract TransactionInternal addOperation(OperationInternal var1);

    public abstract int getSize() throws IOException;

    public abstract ReusableBuffer serialize(ReusableBuffer var1) throws IOException;

    public abstract void cutOfAt(int var1, BabuDBException var2);

    public abstract BabuDBException getIrregularities();

    public static final TransactionInternal deserialize(ReusableBuffer buffer) throws IOException {
        BabuDBTransaction txn = new BabuDBTransaction();
        if (buffer.remaining() > 0 || buffer.limit() > 0) {
            int i;
            assert (buffer.remaining() > 0);
            int length = buffer.getInt();
            String[] dbNames = new String[length];
            for (i = 0; i < length; ++i) {
                byte[] bytes = new byte[buffer.getInt()];
                buffer.get(bytes);
                dbNames[i] = new String(bytes);
            }
            length = buffer.getInt();
            for (i = 0; i < length; ++i) {
                txn.addOperation(OperationInternal.deserialize(dbNames, buffer));
            }
        }
        return txn;
    }
}

