/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.api.dev.transaction;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xtreemfs.babudb.BabuDBRequestResultImpl;
import org.xtreemfs.babudb.api.dev.transaction.InMemoryProcessing;
import org.xtreemfs.babudb.api.dev.transaction.TransactionInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.api.transaction.TransactionListener;
import org.xtreemfs.babudb.log.DiskLogger;
import org.xtreemfs.babudb.log.LogEntry;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;

public abstract class TransactionManagerInternal {
    protected final Map<Byte, InMemoryProcessing> inMemoryProcessing = new HashMap<Byte, InMemoryProcessing>();

    public abstract LSN getLatestOnDiskLSN();

    public abstract void init(LSN var1);

    public abstract void setLogger(DiskLogger var1);

    public final void registerInMemoryProcessing(byte type, InMemoryProcessing processing) {
        this.inMemoryProcessing.put(type, processing);
    }

    public final Map<Byte, InMemoryProcessing> getProcessingLogic() {
        return this.inMemoryProcessing;
    }

    public final void makePersistent(TransactionInternal transaction, BabuDBRequestResultImpl<Object> requestFuture) throws BabuDBException {
        ReusableBuffer buffer = null;
        try {
            buffer = transaction.serialize(BufferPool.allocate((int)transaction.getSize()));
            buffer.flip();
            this.makePersistent(transaction, buffer, requestFuture);
        }
        catch (IOException e) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, e.getMessage(), e);
        }
    }

    public final void makePersistent(ReusableBuffer serialized, BabuDBRequestResultImpl<Object> requestFuture) throws BabuDBException {
        try {
            TransactionInternal txn = TransactionInternal.deserialize(serialized);
            serialized.flip();
            this.makePersistent(txn, serialized, requestFuture);
        }
        catch (IOException e) {
            if (serialized != null) {
                BufferPool.free((ReusableBuffer)serialized);
            }
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, e.getMessage(), e);
        }
    }

    public abstract void makePersistent(TransactionInternal var1, ReusableBuffer var2, BabuDBRequestResultImpl<Object> var3) throws BabuDBException;

    public abstract void replayTransaction(TransactionInternal var1) throws BabuDBException;

    public final void replayTransaction(LogEntry serializedTxn) throws IOException, BabuDBException {
        this.replayTransaction(TransactionInternal.deserialize(serializedTxn.getPayload()));
    }

    public abstract void lockService() throws InterruptedException;

    public abstract void unlockService();

    public abstract void addTransactionListener(TransactionListener var1);

    public abstract void removeTransactionListener(TransactionListener var1);
}

