/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.xtreemfs.babudb.config.Config;
import org.xtreemfs.babudb.log.DiskLogger;

public class BabuDBConfig
extends Config {
    protected int debugLevel;
    protected String debugCategory;
    protected String dbCfgFile;
    protected String baseDir;
    protected String dbLogDir;
    protected DiskLogger.SyncMode syncMode;
    protected int maxQueueLength;
    protected int numThreads;
    protected long maxLogfileSize;
    protected int checkInterval;
    protected int pseudoSyncWait;
    protected boolean compression;
    protected int maxNumRecordsPerBlock;
    protected int maxBlockFileSize;
    protected boolean disableMMap;
    protected int mmapLimit;
    protected List<String> plugins = new ArrayList<String>();

    public BabuDBConfig(String dbDir, String dbLogDir, int numThreads, long maxLogFileSize, int checkInterval, DiskLogger.SyncMode syncMode, int pseudoSyncWait, int maxQ, boolean compression, int maxNumRecordsPerBlock, int maxBlockFileSize, boolean disableMMap, int mmapLimit, int debugLevel) {
        BabuDBConfig.checkArgs(dbDir, dbLogDir, numThreads, maxLogFileSize, checkInterval, syncMode, pseudoSyncWait, maxQ, compression, maxNumRecordsPerBlock, maxBlockFileSize, mmapLimit);
        this.debugLevel = debugLevel;
        this.debugCategory = "all";
        this.baseDir = dbDir.endsWith("/") || dbDir.endsWith("\\") ? dbDir : (dbDir.contains("/") ? dbDir + "/" : (dbDir.contains("\\") ? dbDir + "\\" : dbDir + File.separator));
        this.dbLogDir = dbLogDir.endsWith("/") || dbLogDir.endsWith("\\") ? dbLogDir : (dbLogDir.contains("/") ? dbLogDir + "/" : (dbLogDir.contains("\\") ? dbLogDir + "\\" : dbLogDir + File.separator));
        this.dbCfgFile = "config.db";
        this.syncMode = syncMode;
        this.maxQueueLength = maxQ;
        this.numThreads = numThreads;
        this.checkInterval = checkInterval;
        this.pseudoSyncWait = pseudoSyncWait;
        this.maxLogfileSize = maxLogFileSize;
        this.compression = compression;
        this.maxNumRecordsPerBlock = maxNumRecordsPerBlock;
        this.maxBlockFileSize = maxBlockFileSize;
        this.disableMMap = disableMMap;
        this.mmapLimit = mmapLimit;
    }

    public BabuDBConfig(String dbDir, String dbLogDir, int numThreads, long maxLogFileSize, int checkInterval, DiskLogger.SyncMode syncMode, int pseudoSyncWait, int maxQ, boolean compression, int maxNumRecordsPerBlock, int maxBlockFileSize) {
        this(dbDir, dbLogDir, numThreads, maxLogFileSize, checkInterval, syncMode, pseudoSyncWait, maxQ, compression, maxNumRecordsPerBlock, maxBlockFileSize, !"x86_64".equals(System.getProperty("os.arch")), -1, 4);
    }

    public BabuDBConfig(Properties prop) throws IOException {
        super(prop);
        this.read();
    }

    public BabuDBConfig(String filename) throws IOException {
        super(filename);
        this.read();
    }

    public BabuDBConfig copy() {
        return new BabuDBConfig(this.baseDir, this.dbLogDir, this.numThreads, this.maxLogfileSize, this.checkInterval, this.syncMode, this.pseudoSyncWait, this.maxQueueLength, this.compression, this.maxNumRecordsPerBlock, this.maxBlockFileSize);
    }

    public void dump(String filename) throws FileNotFoundException, IOException {
        this.write(filename);
    }

    public void read() throws IOException {
        this.debugLevel = this.readOptionalDebugLevel();
        this.debugCategory = this.readOptionalString("babudb.debug.category", "all");
        this.dbCfgFile = this.readOptionalString("babudb.cfgFile", "config.db");
        String dbDir = this.readRequiredString("babudb.baseDir");
        this.baseDir = dbDir.endsWith("/") || dbDir.endsWith("\\") ? dbDir : (dbDir.contains("/") ? dbDir + "/" : (dbDir.contains("\\") ? dbDir + "\\" : dbDir + File.separator));
        String dbLogDir = this.readRequiredString("babudb.logDir");
        this.dbLogDir = dbLogDir.endsWith("/") || dbLogDir.endsWith("\\") ? dbLogDir : (dbLogDir.contains("/") ? dbLogDir + "/" : (dbLogDir.contains("\\") ? dbLogDir + "\\" : dbLogDir + File.separator));
        this.syncMode = DiskLogger.SyncMode.valueOf(this.readRequiredString("babudb.sync"));
        this.numThreads = this.readOptionalInt("babudb.worker.numThreads", 1);
        this.maxQueueLength = this.readOptionalInt("babudb.worker.maxQueueLength", 0);
        this.maxLogfileSize = this.readOptionalInt("babudb.maxLogfileSize", 1);
        this.checkInterval = this.readOptionalInt("babudb.checkInterval", 0);
        this.pseudoSyncWait = this.readOptionalInt("babudb.pseudoSyncWait", 0);
        this.compression = this.readOptionalBoolean("babudb.compression", false);
        this.maxNumRecordsPerBlock = this.readOptionalInt("babudb.maxNumRecordsPerBlock", 64);
        this.maxBlockFileSize = this.readOptionalInt("babudb.maxBlockFileSize", 0x20000000);
        this.disableMMap = this.readOptionalBoolean("babudb.disableMmap", System.getProperty("os.arch") != null && !System.getProperty("os.arch").endsWith("64"));
        this.mmapLimit = this.readOptionalInt("babudb.mmapLimit", -1);
        int count = 0;
        String pluginConfigPath = null;
        while ((pluginConfigPath = this.readOptionalString("babudb.plugin." + count, null)) != null) {
            this.plugins.add(pluginConfigPath);
            ++count;
        }
        BabuDBConfig.checkArgs(this.baseDir, this.dbLogDir, this.numThreads, this.maxLogfileSize, this.checkInterval, this.syncMode, this.pseudoSyncWait, this.maxQueueLength, this.compression, this.maxNumRecordsPerBlock, this.maxBlockFileSize, this.mmapLimit);
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public String getDebugCategory() {
        return this.debugCategory;
    }

    public String getDbCfgFile() {
        return this.dbCfgFile;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public String getDbLogDir() {
        return this.dbLogDir;
    }

    public DiskLogger.SyncMode getSyncMode() {
        return this.syncMode;
    }

    public int getMaxQueueLength() {
        return this.maxQueueLength;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public long getMaxLogfileSize() {
        return this.maxLogfileSize;
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public int getPseudoSyncWait() {
        return this.pseudoSyncWait;
    }

    public boolean getCompression() {
        return this.compression;
    }

    public int getMaxNumRecordsPerBlock() {
        return this.maxNumRecordsPerBlock;
    }

    public int getMaxBlockFileSize() {
        return this.maxBlockFileSize;
    }

    public boolean getDisableMMap() {
        return this.disableMMap;
    }

    public int getMMapLimit() {
        return this.mmapLimit;
    }

    public List<String> getPlugins() {
        return this.plugins;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("############# CONFIGURATION #############\n");
        buf.append("#             database dir: " + this.baseDir + "\n");
        buf.append("#         database log dir: " + this.dbLogDir + "\n");
        buf.append("#                sync mode: " + (Object)((Object)this.syncMode) + "\n");
        if (this.syncMode != DiskLogger.SyncMode.ASYNC) {
            buf.append("#     pseudo sync interval: " + this.pseudoSyncWait + "\n");
        }
        buf.append("#        max. queue length: " + this.maxQueueLength + "\n");
        buf.append("#             num. threads: " + this.numThreads + "\n");
        buf.append("#   checkpointing interval: " + this.checkInterval + "\n");
        buf.append("#       max. log file size: " + this.maxLogfileSize + "\n");
        buf.append("#   num. records per block: " + this.maxNumRecordsPerBlock + "\n");
        buf.append("#     max. block file size: " + this.maxBlockFileSize + "\n");
        buf.append("#      compression enabled: " + this.compression + "\n");
        buf.append("#            mmap disabled: " + this.disableMMap + "\n");
        if (!this.disableMMap) {
            buf.append("#               mmap limit: " + this.mmapLimit + "\n");
        }
        for (int i = 0; i < this.plugins.size(); ++i) {
            buf.append("#               plugin-" + i + ": " + this.plugins.get(i) + "\n");
        }
        return buf.toString();
    }

    private static void checkArgs(String dbDir, String dbLogDir, int numThreads, long maxLogFileSize, int checkInterval, DiskLogger.SyncMode syncMode, int pseudoSyncWait, int maxQ, boolean compression, int maxNumRecordsPerBlock, int maxBlockFileSize, int mmapLimit) {
        if (dbDir == null) {
            throw new IllegalArgumentException("database directory needs to be specified!");
        }
        if (dbLogDir == null) {
            throw new IllegalArgumentException("database log directory needs to be specified!");
        }
        if (numThreads < 0) {
            throw new IllegalArgumentException("number of threads must be >= 0!");
        }
        if (maxLogFileSize < 0L) {
            throw new IllegalArgumentException("max. log file size must be be >= 0!");
        }
        if (checkInterval < 0) {
            throw new IllegalArgumentException("check interval for log file size must be >= 0!");
        }
        if (syncMode == null) {
            throw new IllegalArgumentException("log append synchronization mode needs to be specified!");
        }
        if (maxQ < 0) {
            throw new IllegalArgumentException("max. request queue length must be >= 0!");
        }
        if (maxNumRecordsPerBlock <= 0) {
            throw new IllegalArgumentException("number of records per block must be > 0!");
        }
        if (maxBlockFileSize <= 0) {
            throw new IllegalArgumentException("maximum block file size must be > 0!");
        }
        if (mmapLimit < -1) {
            throw new IllegalArgumentException("mmap limit must be >= -1!");
        }
    }
}

