/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.config;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.xtreemfs.babudb.config.BabuDBConfig;
import org.xtreemfs.babudb.log.DiskLogger;
import org.xtreemfs.foundation.logging.Logging;

public class ConfigBuilder {
    private Map<String, String> changes = new HashMap<String, String>();
    private int numOfRegisteredPlugins = 0;

    public ConfigBuilder setDataPath(String dir) {
        this.changes.put("babudb.baseDir", dir);
        this.changes.put("babudb.logDir", dir + "/log");
        return this;
    }

    public ConfigBuilder addPlugin(String configPath) {
        assert (configPath != null && configPath != "");
        this.changes.put("babudb.plugin." + this.numOfRegisteredPlugins, configPath);
        ++this.numOfRegisteredPlugins;
        return this;
    }

    public ConfigBuilder setDataPath(String dbDir, String logDir) {
        this.changes.put("babudb.baseDir", dbDir);
        this.changes.put("babudb.logDir", logDir);
        return this;
    }

    public ConfigBuilder setMultiThreaded(int numThreads) {
        this.changes.put("babudb.worker.numThreads", numThreads + "");
        return this;
    }

    public ConfigBuilder setCompressed(boolean compression) {
        this.changes.put("babudb.compression", compression + "");
        return this;
    }

    public ConfigBuilder setLogAppendSyncMode(DiskLogger.SyncMode syncMode) {
        this.changes.put("babudb.sync", syncMode.toString());
        return this;
    }

    public BabuDBConfig build() {
        Properties props = new Properties();
        BabuDBConfig cfg = null;
        try {
            props.load(ConfigBuilder.class.getResourceAsStream("default-config.properties"));
            props.put("babudb.disableMmap", (Object)(!"x86_64".equals(System.getProperty("os.arch")) ? 1 : 0));
            props.put("babudb.mmapLimit", (Object)("x86_64".equals(System.getProperty("os.arch")) ? -1 : 200));
            props.putAll(this.changes);
            cfg = new BabuDBConfig(props);
        }
        catch (IOException exc) {
            Logging.logError((int)3, null, (Throwable)exc);
        }
        if (cfg == null) {
            throw new NullPointerException();
        }
        return cfg;
    }
}

