/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.config;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.xtreemfs.babudb.config.Config;

public class PluginConfig
extends Config {
    protected String pluginLibraryPath;

    public PluginConfig(Properties prop) {
        super(prop);
        this.read();
    }

    public PluginConfig(String filename) throws IOException {
        super(filename);
        this.read();
    }

    public PluginConfig() {
    }

    private final void read() {
        this.pluginLibraryPath = this.readRequiredString("plugin.jar");
        PluginConfig.checkArgs(this.pluginLibraryPath);
    }

    private static void checkArgs(String pluginPath) {
        if (pluginPath == null || pluginPath == "") {
            throw new IllegalArgumentException("Path to plugin's library jar is missing.");
        }
        File f = new File(pluginPath);
        if (!f.exists() || !f.isFile()) {
            throw new IllegalArgumentException("Path '" + pluginPath + "' does not exist, " + "or is not a file.");
        }
    }

    public String getPluginLibraryPath() {
        return this.pluginLibraryPath;
    }
}

