/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.conversion;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import org.xtreemfs.babudb.BabuDBImpl;
import org.xtreemfs.babudb.api.dev.DatabaseInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.config.BabuDBConfig;
import org.xtreemfs.babudb.conversion.DBWriter;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.util.FSUtils;
import org.xtreemfs.foundation.util.OutputUtils;

public class AutoConverter {
    public static void initiateConversion(int dbVer, BabuDBConfig cfg) throws BabuDBException {
        if (!DBWriter.checkVersionSupport(dbVer)) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "on-disk format (version " + dbVer + ") is incompatible with this BabuDB release (version " + 4 + "); no automatic conversion possible");
        }
        Logging.logMessage((int)6, (Logging.Category)Logging.Category.storage, (Object)null, (String)"starting database conversion", (Object[])new Object[0]);
        File dbDir = new File(cfg.getBaseDir());
        final File dbLogDir = new File(cfg.getDbLogDir());
        final File targetDir = new File(dbDir, ".conversion");
        final File cfgFile = new File(dbDir, cfg.getDbCfgFile());
        final File backupDir = new File(cfg.getBaseDir(), ".backup-" + dbVer);
        File backupDBDir = new File(backupDir, "database");
        File backupLogDir = new File(backupDir, "db-log");
        if (targetDir.exists()) {
            FSUtils.delTree((File)targetDir);
        }
        try {
            DBWriter.writeDB(cfg, dbVer, targetDir.getAbsolutePath());
            File[] dbFilesToMove = dbDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return !pathname.equals(targetDir) && !pathname.equals(cfgFile) && !pathname.equals(backupDir) && !pathname.equals(dbLogDir);
                }
            });
            File[] logFilesToMove = dbLogDir.equals(dbDir) ? new File[]{} : dbLogDir.listFiles();
            backupDBDir.mkdirs();
            backupLogDir.mkdirs();
            if (backupDBDir.exists() && backupLogDir.exists()) {
                for (File f : dbFilesToMove) {
                    if (f.renameTo(new File(backupDBDir, f.getName()))) continue;
                    throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "an error occurred while trying to convert the database: '" + f.getAbsolutePath() + "' could not be moved");
                }
                for (File f : logFilesToMove) {
                    if (f.renameTo(new File(backupLogDir, f.getName()))) continue;
                    throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "an error occurred while trying to convert the database: '" + f.getAbsolutePath() + "' could not be moved");
                }
            } else {
                throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "an error occurred while trying to convert the database: backup directory could not be created");
            }
            FSUtils.copyTree((File)cfgFile, (File)new File(backupDir, cfgFile.getName()));
        }
        catch (IOException exc) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "an error occurred while trying to convert the database", exc);
        }
    }

    public static void completeConversion(BabuDBImpl babuDB) throws BabuDBException {
        File targetDir = new File(babuDB.getConfig().getBaseDir(), "/.conversion");
        File[] dbsToRestore = targetDir.listFiles();
        try {
            for (File dbDir : dbsToRestore) {
                File[] indexFiles = dbDir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return !pathname.isDirectory();
                    }
                });
                DatabaseInternal db = babuDB.getDatabaseManager().createDatabase(dbDir.getName(), indexFiles.length);
                for (File indexFile : indexFiles) {
                    int indexId = Integer.parseInt(indexFile.getName());
                    IndexFileIterator it = new IndexFileIterator(indexFile);
                    while (it.hasNext()) {
                        Object next = it.next();
                        if (next == null) {
                            throw new BabuDBException(BabuDBException.ErrorCode.INTERNAL_ERROR, "database conversion failed, dump corrupted");
                        }
                        db.singleInsert(indexId, (byte[])next.getKey(), (byte[])next.getValue(), null).get();
                    }
                    it.destroy();
                }
                File snapRootDir = new File(dbDir, "snapshots");
                File[] snapDirs = snapRootDir.listFiles();
                if (snapDirs == null) continue;
                for (File snapDir : snapDirs) {
                }
            }
        }
        catch (IOException exc) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "an error has occurred while trying to convert the database", exc);
        }
        FSUtils.delTree((File)targetDir);
        Logging.logMessage((int)6, (Logging.Category)Logging.Category.storage, (Object)null, (String)"conversion completed", (Object[])new Object[0]);
    }

    static class IndexFileIterator
    implements Iterator<Map.Entry<byte[], byte[]>> {
        private InputStream in;
        private ByteBuffer lenBytes;

        public IndexFileIterator(File file) {
            try {
                this.in = new FileInputStream(file);
                this.lenBytes = ByteBuffer.wrap(new byte[4]);
            }
            catch (IOException exc) {
                Logging.logMessage((int)3, (Logging.Category)Logging.Category.storage, (Object)this, (String)("an error occurred while trying to convert the database: " + OutputUtils.stackTraceToString((Throwable)exc)), (Object[])new Object[0]);
            }
        }

        @Override
        public boolean hasNext() {
            try {
                return this.in.available() > 0;
            }
            catch (IOException exc) {
                Logging.logMessage((int)3, (Logging.Category)Logging.Category.storage, (Object)this, (String)("an error occurred while trying to convert the database: " + OutputUtils.stackTraceToString((Throwable)exc)), (Object[])new Object[0]);
                return false;
            }
        }

        @Override
        public Map.Entry<byte[], byte[]> next() {
            try {
                int tmp = this.in.read(this.lenBytes.array());
                if (tmp != 4) {
                    Logging.logMessage((int)3, (Logging.Category)Logging.Category.storage, (Object)this, (String)"an error occurred while trying to convert the database; database dump corrupted (only %d bytes read, available: %d)", (Object[])new Object[]{tmp, this.in.available()});
                    return null;
                }
                int len = this.lenBytes.getInt();
                this.lenBytes.position(0);
                final byte[] key = new byte[len];
                int num = this.in.read(key);
                if (num != len) {
                    Logging.logMessage((int)3, (Logging.Category)Logging.Category.storage, (Object)this, (String)"an error occurred while trying to convert the database; expected key length: %d, actual key length: %d", (Object[])new Object[]{len, num});
                    return null;
                }
                tmp = this.in.read(this.lenBytes.array());
                if (tmp != 4) {
                    Logging.logMessage((int)3, (Logging.Category)Logging.Category.storage, (Object)this, (String)"an error occurred while trying to convert the database; database dump corrupted (only %d bytes read, available: %d)", (Object[])new Object[]{tmp, this.in.available()});
                    return null;
                }
                len = this.lenBytes.getInt();
                this.lenBytes.position(0);
                final byte[] val = new byte[len];
                num = this.in.read(val);
                if (num != len) {
                    System.out.println("remaining: " + this.in.available());
                    Logging.logMessage((int)3, (Logging.Category)Logging.Category.storage, (Object)this, (String)"an error occurred while trying to convert the database; expected value length: %d, actual value length: %d", (Object[])new Object[]{len, num});
                    return null;
                }
                return new Map.Entry<byte[], byte[]>(){

                    @Override
                    public byte[] setValue(byte[] value) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public byte[] getValue() {
                        return val;
                    }

                    @Override
                    public byte[] getKey() {
                        return key;
                    }
                };
            }
            catch (IOException exc) {
                Logging.logMessage((int)3, (Logging.Category)Logging.Category.storage, (Object)this, (String)("an error occurred while trying to convert the database: " + OutputUtils.stackTraceToString((Throwable)exc)), (Object[])new Object[0]);
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void destroy() throws IOException {
            this.in.close();
        }
    }
}

