/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.conversion;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import org.xtreemfs.foundation.logging.Logging;

public class BabuDBVersionReader
extends ClassLoader {
    private Map<String, byte[]> classes = new HashMap<String, byte[]>();
    private Object babuDB;

    public BabuDBVersionReader(int ver, Properties cfgProps) throws IOException {
        super(null);
        JarEntry next;
        JarInputStream jis = new JarInputStream(this.getClass().getResourceAsStream("jars/" + ver + ".jar"));
        while ((next = jis.getNextJarEntry()) != null) {
            int len;
            if (!next.getName().endsWith(".class")) continue;
            byte[] buf = new byte[4096];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((len = jis.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            String className = next.getName().substring(0, next.getName().length() - ".class".length()).replace('/', '.');
            this.classes.put(className, out.toByteArray());
            out.close();
        }
        jis.close();
        this.babuDB = this.initBabuDB(cfgProps);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        byte[] classBytes = this.classes.get(name);
        if (classBytes == null) {
            return this.findSystemClass(name);
        }
        Class<?> clazz = this.defineClass(name, classBytes, 0, classBytes.length);
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public Iterator<Map.Entry<byte[], byte[]>> getIndexContent(String dbName, int indexId) {
        try {
            Object dbManager = this.babuDB.getClass().getMethod("getDatabaseManager", new Class[0]).invoke(this.babuDB, new Object[0]);
            Object database = dbManager.getClass().getMethod("getDatabase", String.class).invoke(dbManager, dbName);
            Object query = database.getClass().getMethod("prefixLookup", Integer.TYPE, byte[].class, Object.class).invoke(database, indexId, new byte[0], null);
            Iterator it = (Iterator)query.getClass().getMethod("get", new Class[0]).invoke(query, new Object[0]);
            return it;
        }
        catch (Exception exc) {
            Logging.logError((int)2, (Object)this, (Throwable)exc);
            return null;
        }
    }

    public void shutdown() {
        if (this.babuDB == null) {
            return;
        }
        try {
            this.babuDB.getClass().getMethod("shutdown", new Class[0]).invoke(this.babuDB, new Object[0]);
            this.babuDB = null;
        }
        catch (Exception exc) {
            Logging.logError((int)3, (Object)this, (Throwable)exc);
        }
    }

    public Set<String> getAllDatabases() {
        try {
            Object dbManager = this.babuDB.getClass().getMethod("getDatabaseManager", new Class[0]).invoke(this.babuDB, new Object[0]);
            Map map = (Map)dbManager.getClass().getMethod("getDatabases", new Class[0]).invoke(dbManager, new Object[0]);
            return map.keySet();
        }
        catch (Exception exc) {
            Logging.logError((int)3, (Object)this, (Throwable)exc);
            return null;
        }
    }

    public int getNumIndics(String dbName) {
        try {
            Object dbManager = this.babuDB.getClass().getMethod("getDatabaseManager", new Class[0]).invoke(this.babuDB, new Object[0]);
            Object database = dbManager.getClass().getMethod("getDatabase", String.class).invoke(dbManager, dbName);
            int i = 0;
            try {
                while (true) {
                    Object query = database.getClass().getMethod("lookup", Integer.TYPE, byte[].class, Object.class).invoke(database, i, new byte[0], null);
                    query.getClass().getMethod("get", new Class[0]).invoke(query, new Object[0]);
                    ++i;
                }
            }
            catch (Exception exc) {
                return i;
            }
        }
        catch (Exception exc) {
            Logging.logError((int)3, (Object)this, (Throwable)exc);
            return 0;
        }
    }

    public String[] getAllSnapshots(String dbName) {
        try {
            Object snapManager = this.babuDB.getClass().getMethod("getSnapshotManager", new Class[0]).invoke(this.babuDB, new Object[0]);
            return (String[])snapManager.getClass().getMethod("getAllSnapshots", String.class).invoke(snapManager, dbName);
        }
        catch (Exception exc) {
            Logging.logError((int)3, (Object)this, (Throwable)exc);
            return null;
        }
    }

    public Iterator<Map.Entry<byte[], byte[]>> getIndexContent(String dbName, String snapName, int indexId) {
        try {
            Object snapManager = this.babuDB.getClass().getMethod("getSnapshotManager", new Class[0]).invoke(this.babuDB, new Object[0]);
            Object database = snapManager.getClass().getMethod("getSnapshotDB", String.class, String.class).invoke(snapManager, dbName, snapName);
            Object query = database.getClass().getMethod("prefixLookup", Integer.TYPE, byte[].class, Object.class).invoke(database, indexId, new byte[0], null);
            Iterator it = (Iterator)query.getClass().getMethod("get", new Class[0]).invoke(query, new Object[0]);
            return it;
        }
        catch (Exception exc) {
            Logging.logError((int)2, (Object)this, (Throwable)exc);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkVersionSupport(int ver) {
        ZipInputStream jis = null;
        try {
            jis = new JarInputStream(BabuDBVersionReader.class.getResourceAsStream("jars/" + ver + ".jar"));
            boolean bl = true;
            return bl;
        }
        catch (Exception exc) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (IOException exc) {}
            }
        }
    }

    protected Object initBabuDB(Properties cfgProps) {
        try {
            assert (this.babuDB == null);
            Class<?> cfgCls = this.loadClass("org.xtreemfs.babudb.config.BabuDBConfig");
            Object cfg = cfgCls.getConstructor(Properties.class).newInstance(cfgProps);
            Class<?> babuDBFactoryCls = this.loadClass("org.xtreemfs.babudb.BabuDBFactory");
            return babuDBFactoryCls.getMethod("createBabuDB", cfgCls).invoke(null, cfg);
        }
        catch (Exception exc) {
            Logging.logError((int)3, (Object)this, (Throwable)exc);
            return null;
        }
    }
}

