/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.conversion;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import org.xtreemfs.babudb.config.BabuDBConfig;
import org.xtreemfs.babudb.conversion.BabuDBVersionReader;

public class DBWriter {
    public static final String SNAPSHOT_DIR_NAME = "snapshots";

    public static boolean checkVersionSupport(int ver) {
        return BabuDBVersionReader.checkVersionSupport(ver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDB(BabuDBConfig cfg, int ver, String targetDir) throws IOException {
        BabuDBVersionReader reader = null;
        try {
            File trgDir = new File(targetDir);
            trgDir.mkdirs();
            reader = new BabuDBVersionReader(ver, cfg.getProps());
            for (String dbName : reader.getAllDatabases()) {
                File dbDir = new File(trgDir, dbName);
                dbDir.mkdir();
                for (int i = 0; i < reader.getNumIndics(dbName); ++i) {
                    DBWriter.writeIndexFile(dbName, null, i, new File(dbDir, i + ""), reader);
                }
                String[] snaps = reader.getAllSnapshots(dbName);
                if (snaps.length == 0) continue;
                for (String snapName : snaps) {
                    for (int i = 0; i < reader.getNumIndics(dbName); ++i) {
                        DBWriter.writeIndexFile(dbName, snapName, i, new File(dbDir, i + ""), reader);
                    }
                }
            }
        }
        finally {
            if (reader != null) {
                reader.shutdown();
            }
        }
    }

    private static void writeIndexFile(String dbName, String snapName, int indexId, File targetFile, BabuDBVersionReader reader) throws IOException {
        Iterator<Map.Entry<byte[], byte[]>> it;
        FileOutputStream out = new FileOutputStream(targetFile);
        ByteBuffer lenBytes = ByteBuffer.wrap(new byte[4]);
        Iterator<Map.Entry<byte[], byte[]>> iterator = it = snapName == null ? reader.getIndexContent(dbName, indexId) : reader.getIndexContent(dbName, snapName, indexId);
        while (it.hasNext()) {
            Map.Entry<byte[], byte[]> next = it.next();
            lenBytes.putInt(next.getKey().length);
            lenBytes.position(0);
            ((OutputStream)out).write(lenBytes.array());
            ((OutputStream)out).write(next.getKey());
            lenBytes.putInt(next.getValue().length);
            lenBytes.position(0);
            ((OutputStream)out).write(lenBytes.array());
            ((OutputStream)out).write(next.getValue());
        }
        ((OutputStream)out).close();
    }
}

