/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.index;

import java.nio.ByteBuffer;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.util.OutputUtils;

public class ByteRange {
    private final ByteBuffer buf;
    private final int startOffset;
    private final int endOffset;
    private final int size;
    private byte[] prefix;
    private ReusableBuffer rBuf;

    public ByteRange(ByteBuffer buf, int startOffset, int endOffset) {
        this.buf = buf;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.size = endOffset - startOffset;
        this.prefix = null;
        assert (endOffset < buf.limit()) : "buf.limit() == " + buf.limit() + ", endOffset == " + endOffset + ", startOffset == " + startOffset + ", buf.capacity == " + buf.capacity();
    }

    public ByteBuffer getBuf() {
        return this.buf;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getSize() {
        return this.size;
    }

    public void addPrefix(byte[] prefix) {
        this.prefix = prefix;
    }

    public byte[] toBuffer() {
        byte[] tmp;
        this.buf.position(this.startOffset);
        if (this.prefix == null) {
            tmp = new byte[this.size];
            this.buf.get(tmp);
        } else {
            tmp = new byte[this.prefix.length + this.size];
            System.arraycopy(this.prefix, 0, tmp, 0, this.prefix.length);
            this.buf.get(tmp, this.prefix.length, this.size);
        }
        return tmp;
    }

    public void setReusableBuf(ReusableBuffer rBuf) {
        this.rBuf = rBuf;
    }

    public ReusableBuffer getReusableBuf() {
        return this.rBuf;
    }

    public String toString() {
        ReusableBuffer buffer = new ReusableBuffer(this.buf);
        ReusableBuffer newBuf = buffer.createViewBuffer();
        newBuf.range(this.startOffset, this.endOffset - this.startOffset);
        return OutputUtils.byteArrayToHexString((byte[])newBuf.array());
    }
}

