/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.index;

import org.xtreemfs.babudb.api.index.ByteRangeComparator;
import org.xtreemfs.babudb.index.ByteRange;

public class DefaultByteRangeComparator
implements ByteRangeComparator {
    private static DefaultByteRangeComparator instance;

    @Override
    public byte[][] prefixToRange(byte[] prefix, boolean ascending) {
        byte[][] byArrayArray;
        if (prefix == null) {
            return new byte[][]{null, null};
        }
        byte[] bytes = new byte[prefix.length];
        System.arraycopy(prefix, 0, bytes, 0, prefix.length);
        for (int i = bytes.length - 1; i >= 0; --i) {
            if (i == 0 && bytes[i] == 127) {
                return null;
            }
            int n = i;
            bytes[n] = (byte)(bytes[n] + 1);
            if (bytes[i] != -128) break;
        }
        if (ascending) {
            byte[][] byArrayArray2 = new byte[2][];
            byArrayArray2[0] = prefix;
            byArrayArray = byArrayArray2;
            byArrayArray2[1] = bytes;
        } else {
            byte[][] byArrayArray3 = new byte[2][];
            byArrayArray3[0] = bytes;
            byArrayArray = byArrayArray3;
            byArrayArray3[1] = prefix;
        }
        return byArrayArray;
    }

    @Override
    public int compare(ByteRange rng, byte[] buf) {
        int n = rng.getStartOffset() + Math.min(rng.getSize(), buf.length);
        int j = 0;
        int i = rng.getStartOffset();
        while (i < n) {
            byte v2;
            assert (i < rng.getEndOffset()) : "i == " + i + ", endOffset == " + rng.getEndOffset();
            byte v1 = rng.getBuf().get(i);
            if (v1 != (v2 = buf[j])) {
                if (v1 < v2) {
                    return -1;
                }
                return 1;
            }
            ++i;
            ++j;
        }
        return rng.getSize() - buf.length;
    }

    @Override
    public int compare(byte[] buf1, byte[] buf2) {
        int n = Math.min(buf1.length, buf2.length);
        int i = 0;
        int j = 0;
        while (i < n) {
            byte v1 = buf1[i];
            byte v2 = buf2[j];
            if (v1 != v2) {
                if (v1 < v2) {
                    return -1;
                }
                return 1;
            }
            ++i;
            ++j;
        }
        return buf1.length - buf2.length;
    }

    public static DefaultByteRangeComparator getInstance() {
        if (instance == null) {
            instance = new DefaultByteRangeComparator();
        }
        return instance;
    }
}

