/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.NoSuchElementException;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.api.index.ByteRangeComparator;
import org.xtreemfs.babudb.index.OverlayMergeIterator;
import org.xtreemfs.babudb.index.overlay.MultiOverlayBufferTree;
import org.xtreemfs.babudb.index.reader.DiskIndex;
import org.xtreemfs.babudb.index.reader.InternalBufferUtil;
import org.xtreemfs.babudb.index.reader.InternalDiskIndexIterator;
import org.xtreemfs.babudb.index.reader.InternalMergeIterator;
import org.xtreemfs.babudb.index.writer.DiskIndexWriter;
import org.xtreemfs.babudb.snapshots.SnapshotConfig;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.util.OutputUtils;

public class LSMTree {
    private static long totalOnDiskSize = 0L;
    private static final byte[] NULL_ELEMENT = new byte[0];
    private MultiOverlayBufferTree overlay;
    private DiskIndex index;
    private final ByteRangeComparator comp;
    private final Object lock;
    private boolean compressed;
    private final int maxEntriesPerBlock;
    private final int maxBlockFileSize;
    private final boolean useMMap;
    private final int mmapLimitBytes;

    public LSMTree(String indexFile, ByteRangeComparator comp, boolean compressed, int maxEntriesPerBlock, int maxBlockFileSize, boolean useMMap, int mmapLimit) throws IOException {
        this.comp = comp;
        this.compressed = compressed;
        this.maxEntriesPerBlock = maxEntriesPerBlock;
        this.maxBlockFileSize = maxBlockFileSize;
        this.useMMap = useMMap;
        this.mmapLimitBytes = mmapLimit * 1024 * 1024;
        this.overlay = new MultiOverlayBufferTree(NULL_ELEMENT, comp);
        totalOnDiskSize += indexFile == null ? 0L : LSMTree.getTotalDirSize(new File(indexFile));
        this.index = indexFile == null ? null : new DiskIndex(indexFile, comp, compressed, this.useMmap());
        this.lock = new Object();
    }

    public byte[] lookup(byte[] key) {
        byte[] result = (byte[])this.overlay.lookup(key);
        if (result == NULL_ELEMENT) {
            return null;
        }
        if (result != null) {
            return result;
        }
        return this.index == null ? null : this.index.lookup(key);
    }

    public byte[] lookup(byte[] key, int snapId) {
        byte[] result = (byte[])this.overlay.lookup(key, snapId);
        if (result == NULL_ELEMENT) {
            return null;
        }
        if (result != null) {
            return result;
        }
        return this.index == null ? null : this.index.lookup(key);
    }

    public Map.Entry<byte[], byte[]> firstEntry() {
        ResultSet<byte[], byte[]> it = this.prefixLookup(new byte[0]);
        Map.Entry result = it.hasNext() ? (Map.Entry)it.next() : null;
        it.free();
        return result;
    }

    public Map.Entry<byte[], byte[]> firstEntry(int snapId) {
        ResultSet<byte[], byte[]> it = this.prefixLookup(new byte[0], snapId, true);
        Map.Entry result = it.hasNext() ? (Map.Entry)it.next() : null;
        it.free();
        return result;
    }

    public Map.Entry<byte[], byte[]> lastEntry() {
        ResultSet<byte[], byte[]> it = this.prefixLookup(new byte[0], false);
        Map.Entry result = it.hasNext() ? (Map.Entry)it.next() : null;
        it.free();
        return result;
    }

    public Map.Entry<byte[], byte[]> lastEntry(int snapId) {
        ResultSet<byte[], byte[]> it = this.prefixLookup(new byte[0], snapId, false);
        Map.Entry result = it.hasNext() ? (Map.Entry)it.next() : null;
        it.free();
        return result;
    }

    public ResultSet<byte[], byte[]> prefixLookup(byte[] prefix) {
        return this.prefixLookup(prefix, true);
    }

    public ResultSet<byte[], byte[]> prefixLookup(byte[] prefix, boolean ascending) {
        if (prefix != null && prefix.length == 0) {
            prefix = null;
        }
        ArrayList list = new ArrayList(2);
        list.add(this.overlay.prefixLookup(prefix, true, ascending));
        if (this.index != null) {
            byte[][] rng = this.comp.prefixToRange(prefix, ascending);
            list.add(this.index.rangeLookup(rng[0], rng[1], ascending));
        }
        return new OverlayMergeIterator<byte[], byte[]>(list, this.comp, NULL_ELEMENT, ascending);
    }

    public ResultSet<byte[], byte[]> prefixLookup(byte[] prefix, int snapId) {
        return this.prefixLookup(prefix, snapId, true);
    }

    public ResultSet<byte[], byte[]> prefixLookup(byte[] prefix, int snapId, boolean ascending) {
        if (prefix != null && prefix.length == 0) {
            prefix = null;
        }
        ArrayList list = new ArrayList(2);
        list.add(this.overlay.prefixLookup(prefix, snapId, true, ascending));
        if (this.index != null) {
            byte[][] rng = this.comp.prefixToRange(prefix, ascending);
            list.add(this.index.rangeLookup(rng[0], rng[1], ascending));
        }
        return new OverlayMergeIterator<byte[], byte[]>(list, this.comp, NULL_ELEMENT, ascending);
    }

    public ResultSet<byte[], byte[]> rangeLookup(byte[] from, byte[] to) {
        return this.rangeLookup(from, to, true);
    }

    public ResultSet<byte[], byte[]> rangeLookup(byte[] from, byte[] to, boolean ascending) {
        if (from.length == 0) {
            from = null;
        }
        if (to.length == 0) {
            to = null;
        }
        ArrayList list = new ArrayList(2);
        list.add(this.overlay.rangeLookup(from, to, true, ascending));
        if (this.index != null) {
            list.add(this.index.rangeLookup(from, to, ascending));
        }
        return new OverlayMergeIterator<byte[], byte[]>(list, this.comp, NULL_ELEMENT, ascending);
    }

    public ResultSet<byte[], byte[]> rangeLookup(byte[] from, byte[] to, int snapId) {
        return this.rangeLookup(from, to, snapId, true);
    }

    public ResultSet<byte[], byte[]> rangeLookup(byte[] from, byte[] to, int snapId, boolean ascending) {
        if (from.length == 0) {
            from = null;
        }
        if (to.length == 0) {
            to = null;
        }
        ArrayList list = new ArrayList(2);
        list.add(this.overlay.rangeLookup(from, to, snapId, true, ascending));
        if (this.index != null) {
            list.add(this.index.rangeLookup(from, to, ascending));
        }
        return new OverlayMergeIterator<byte[], byte[]>(list, this.comp, NULL_ELEMENT, ascending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(byte[] key, byte[] value) {
        Object object = this.lock;
        synchronized (object) {
            this.overlay.insert(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(byte[] key) {
        Object object = this.lock;
        synchronized (object) {
            this.overlay.insert(key, null);
        }
    }

    public int createSnapshot() {
        return this.overlay.newOverlay();
    }

    public void materializeSnapshot(String targetFile, int snapId) throws IOException {
        DiskIndexWriter writer = new DiskIndexWriter(targetFile, this.maxEntriesPerBlock, this.compressed, this.maxBlockFileSize);
        InternalMergeIterator it = this.internalPrefixLookup(null, snapId, true);
        writer.writeIndex(it);
        it.free();
    }

    public void materializeSnapshot(String targetFile, final int snapId, final int indexId, final SnapshotConfig snap) throws IOException {
        DiskIndexWriter writer = new DiskIndexWriter(targetFile, this.maxEntriesPerBlock, this.compressed, this.maxBlockFileSize);
        writer.writeIndex(new ResultSet<Object, Object>(){
            private ResultSet<Object, Object>[] iterators;
            private Map.Entry<Object, Object> next;
            private int currentIt;
            {
                byte[][] prefixes = snap.getPrefixes(indexId);
                this.currentIt = 0;
                if (prefixes != null) {
                    this.iterators = new ResultSet[prefixes.length];
                    for (int i = 0; i < prefixes.length; ++i) {
                        this.iterators[i] = LSMTree.this.internalPrefixLookup(prefixes[i], snapId, true);
                    }
                } else {
                    this.iterators = new ResultSet[]{LSMTree.this.prefixLookup(null, snapId, true)};
                }
                this.getNextElement();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Map.Entry<Object, Object> next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Map.Entry<Object, Object> tmp = this.next;
                this.getNextElement();
                return tmp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void free() {
                for (ResultSet<Object, Object> it : this.iterators) {
                    it.free();
                }
            }

            private void getNextElement() {
                while (true) {
                    if (this.currentIt < this.iterators.length && !this.iterators[this.currentIt].hasNext()) {
                        ++this.currentIt;
                        continue;
                    }
                    if (this.currentIt >= this.iterators.length) {
                        this.next = null;
                        return;
                    }
                    this.next = (Map.Entry)this.iterators[this.currentIt].next();
                    byte[] tmp = InternalBufferUtil.toBuffer(this.next.getKey());
                    if (snap.containsKey(indexId, tmp)) break;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkToSnapshot(String snapshotFile) throws IOException {
        DiskIndex oldIndex = this.index;
        Object object = this.lock;
        synchronized (object) {
            totalOnDiskSize -= this.index == null ? 0L : this.index.getSize();
            this.index = new DiskIndex(snapshotFile, this.comp, this.compressed, this.useMmap());
            totalOnDiskSize += this.index.getSize();
            if (oldIndex != null) {
                oldIndex.destroy();
            }
            this.overlay.cleanup();
        }
    }

    public boolean isMMapEnabled() {
        return this.useMMap;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.index != null) {
                totalOnDiskSize -= this.index.getSize();
                this.index.destroy();
            }
            this.overlay.cleanup();
        }
    }

    private boolean useMmap() {
        Logging.logMessage((int)7, (Object)this, (String)("DB size: " + OutputUtils.formatBytes((long)totalOnDiskSize)), (Object[])new Object[0]);
        return this.useMMap && (this.mmapLimitBytes < 0 || totalOnDiskSize < (long)this.mmapLimitBytes);
    }

    protected InternalMergeIterator internalPrefixLookup(byte[] prefix, int snapId, boolean ascending) {
        if (prefix != null && prefix.length == 0) {
            prefix = null;
        }
        ResultSet<byte[], byte[]> overlayIterator = this.overlay.prefixLookup(prefix, snapId, true, ascending);
        InternalDiskIndexIterator diskIndexIterator = null;
        if (this.index != null) {
            byte[][] rng = this.comp.prefixToRange(prefix, ascending);
            diskIndexIterator = this.index.internalRangeLookup(rng[0], rng[1], ascending);
        }
        return new InternalMergeIterator(overlayIterator, diskIndexIterator, this.comp, NULL_ELEMENT, ascending);
    }

    private static long getTotalDirSize(File dir) {
        if (!dir.exists()) {
            return 0L;
        }
        long size = 0L;
        if (dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                size += LSMTree.getTotalDirSize(child);
            }
        } else {
            size += dir.length();
        }
        return size;
    }
}

