/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.index;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.xtreemfs.babudb.api.database.ResultSet;

public class OverlayMergeIterator<K, V>
implements ResultSet<K, V> {
    private Map.Entry<K, V> nextElement;
    private Map.Entry<K, V>[] nextElements;
    private List<Iterator<Map.Entry<K, V>>> itList;
    private Comparator<K> comp;
    private V nullValue;
    private boolean ascending;

    public OverlayMergeIterator(List<Iterator<Map.Entry<K, V>>> itList, Comparator<K> comp, V nullValue, boolean ascending) {
        this.itList = itList;
        this.comp = comp;
        this.nullValue = nullValue;
        this.ascending = ascending;
        this.nextElements = new Map.Entry[itList.size()];
        for (int i = 0; i < this.nextElements.length; ++i) {
            this.nextElements[i] = itList.get(i).hasNext() ? itList.get(i).next() : null;
        }
        this.nextElement = this.getNextElement();
    }

    @Override
    public boolean hasNext() {
        return this.nextElement != null;
    }

    @Override
    public Map.Entry<K, V> next() {
        if (this.nextElement == null) {
            throw new NoSuchElementException();
        }
        Map.Entry<K, V> element = this.nextElement;
        this.nextElement = this.getNextElement();
        return element;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void free() {
        for (Iterator<Map.Entry<K, V>> it : this.itList) {
            if (!(it instanceof ResultSet)) continue;
            ((ResultSet)it).free();
        }
    }

    private Map.Entry<K, V> getNextElement() {
        Map.Entry<K, V> entry;
        do {
            Iterator<Map.Entry<K, V>> it;
            int smallest = 0;
            for (int i = 1; i < this.nextElements.length; ++i) {
                if (this.nextElements[i] == null) continue;
                if (this.nextElements[smallest] == null || this.ascending && this.comp.compare(this.nextElements[i].getKey(), this.nextElements[smallest].getKey()) < 0 || !this.ascending && this.comp.compare(this.nextElements[i].getKey(), this.nextElements[smallest].getKey()) > 0) {
                    smallest = i;
                    continue;
                }
                if (this.comp.compare(this.nextElements[i].getKey(), this.nextElements[smallest].getKey()) != 0) continue;
                it = this.itList.get(i);
                this.nextElements[i] = it.hasNext() ? it.next() : null;
            }
            entry = this.nextElements[smallest];
            it = this.itList.get(smallest);
            Map.Entry<K, V> entry2 = this.nextElements[smallest] = it.hasNext() ? it.next() : null;
            if (entry != null) continue;
            return null;
        } while (this.nullValue != null && entry.getValue() == this.nullValue);
        return entry;
    }
}

